/*
 * Decompiled with CFR 0.152.
 */
package com.crackedzombie.common;

import com.crackedzombie.common.CrackedZombie;
import com.crackedzombie.common.EntityAIMigrate;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityCrackedZombie
extends EntityMob {
    protected static final RangedAttribute reinforcements = new RangedAttribute("zombie.spawnReinforcements", 0.0, 0.0, 1.0).func_111117_a("Spawn Reinforcements Chance");
    private static final UUID uuid = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier speedBoost = new AttributeModifier(uuid, "Baby speed boost", 0.1, 0);
    private final boolean allowChildSpawns = CrackedZombie.instance.getAllowChildSpawns();
    private int conversionTime = 0;
    private final float attackDistance = 16.0f;

    public EntityCrackedZombie(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (CrackedZombie.instance.getDoorBusting()) {
            this.func_70661_as().func_75498_b(true);
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityChicken.class, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPig.class, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMigrate((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChicken.class, 8, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPig.class, 8, false));
        this.func_70105_a(0.6f, 1.8f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(CrackedZombie.instance.getFollowRange());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(CrackedZombie.instance.getMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(CrackedZombie.instance.getAttackDamage());
        this.func_110140_aT().func_111150_b((IAttribute)reinforcements).func_111128_a(this.field_70146_Z.nextDouble() * 0.1);
    }

    public boolean getHasTarget() {
        return this.isAttackableEntity((EntityLivingBase)this, 16.0);
    }

    public boolean isAttackableEntity(EntityLivingBase entityLiving, double distance) {
        List list = this.field_70170_p.func_82733_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(distance, 4.0, distance), (IEntitySelector)null);
        for (Entity entity : list) {
            double dist;
            EntityLivingBase target = (EntityLivingBase)entity;
            if (!this.isGoodTarget(target) || !((dist = target.func_70092_e(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v)) < distance * distance)) continue;
            return true;
        }
        return false;
    }

    public boolean isGoodTarget(EntityLivingBase target) {
        if (target == null || target == this || !target.func_70089_S()) {
            return false;
        }
        boolean player = target instanceof EntityPlayer;
        boolean villager = target instanceof EntityVillager;
        boolean chicken = target instanceof EntityChicken;
        boolean pig = target instanceof EntityPig;
        if (player && ((EntityPlayer)target).field_71075_bZ.field_75098_d) {
            return false;
        }
        return (player || villager || chicken || pig) && this.func_70685_l((Entity)target);
    }

    protected boolean func_70780_i() {
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (super.func_70097_a(damageSource, damage)) {
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (entitylivingbase == null && this.func_70777_m() instanceof EntityLivingBase) {
                entitylivingbase = (EntityLivingBase)this.func_70777_m();
            }
            if (entitylivingbase == null && damageSource.func_76346_g() instanceof EntityLivingBase) {
                entitylivingbase = (EntityLivingBase)damageSource.func_76346_g();
            }
            if (entitylivingbase != null && this.field_70170_p.field_73013_u.func_151525_a() >= EnumDifficulty.NORMAL.func_151525_a() && (double)this.field_70146_Z.nextFloat() < this.func_110148_a((IAttribute)reinforcements).func_111126_e()) {
                int i = MathHelper.func_76128_c((double)this.field_70165_t);
                int j = MathHelper.func_76128_c((double)this.field_70163_u);
                int k = MathHelper.func_76128_c((double)this.field_70161_v);
                EntityCrackedZombie crackedZombie = new EntityCrackedZombie(this.field_70170_p);
                for (int l = 0; l < 50; ++l) {
                    int k1;
                    int j1;
                    int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    if (!World.func_147466_a((IBlockAccess)this.field_70170_p, (int)i1, (int)((j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1)) - 1), (int)(k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1)))) continue;
                    crackedZombie.func_70107_b(i1, j1, k1);
                    if (!this.field_70170_p.func_72855_b(crackedZombie.field_70121_D) || !this.field_70170_p.func_72945_a((Entity)crackedZombie, crackedZombie.field_70121_D).isEmpty() || this.field_70170_p.func_72953_d(crackedZombie.field_70121_D)) continue;
                    this.field_70170_p.func_72838_d((Entity)crackedZombie);
                    crackedZombie.func_70624_b(entitylivingbase);
                    crackedZombie.func_110161_a(null);
                    this.func_110148_a((IAttribute)reinforcements).func_111121_a(new AttributeModifier("Zombie reinforcement caller charge", (double)-0.05f, 0));
                    crackedZombie.func_110148_a((IAttribute)reinforcements).func_111121_a(new AttributeModifier("Zombie reinforcement callee charge", (double)-0.05f, 0));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                int strength = 0;
                if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                    strength = 7;
                } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                    strength = 15;
                }
                if (CrackedZombie.instance.getSickness()) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, strength * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        float brightness;
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_()) {
            ItemStack itemstack;
            brightness = this.func_70013_c(1.0f);
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.field_70163_u);
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            boolean canSeeBlock = this.field_70170_p.func_72937_j(x, y, z);
            if (brightness > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && canSeeBlock && (itemstack = this.func_71124_b(4)) != null && itemstack.func_77984_f()) {
                itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                    this.func_70669_a(itemstack);
                    this.func_70062_b(4, null);
                }
            }
        }
        this.func_82168_bl();
        brightness = this.func_70013_c(1.0f);
        if (brightness > 0.5f) {
            this.field_70708_bq += 2;
        }
        super.func_70636_d();
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70601_bi() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean notColliding = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty();
        boolean isLiquid = this.field_70170_p.func_72953_d(this.field_70121_D);
        boolean isGrass = this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150349_c;
        boolean isSand = this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150354_m;
        boolean isClay = this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150405_ch;
        boolean isStainedClay = this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150406_ce;
        boolean isDirt = this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150346_d;
        boolean isStone = this.field_70146_Z.nextInt(8) == 0 && this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150348_b;
        return (isGrass || isSand || isStone || isClay || isStainedClay || isDirt) && notColliding && !isLiquid;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.func_70096_w().func_75682_a(13, (Object)0);
        this.func_70096_w().func_75682_a(14, (Object)0);
    }

    public int func_70658_aO() {
        int armor = super.func_70658_aO() + 2;
        if (armor > 20) {
            armor = 20;
        }
        return armor;
    }

    protected boolean func_70692_ba() {
        return !this.isConverting();
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean func_70631_g_() {
        return this.func_70096_w().func_75683_a(12) == 1;
    }

    public void setChild(boolean unused) {
        if (this.allowChildSpawns) {
            this.func_70096_w().func_75692_b(12, (Object)((byte)(unused ? 1 : 0)));
            if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
                IAttributeInstance attributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                attributeinstance.func_111124_b(speedBoost);
                if (unused) {
                    attributeinstance.func_111121_a(speedBoost);
                }
            }
        }
    }

    public boolean isVillager() {
        return this.func_70096_w().func_75683_a(13) == 1;
    }

    public void setVillager(boolean set) {
        this.func_70096_w().func_75692_b(13, (Object)((byte)(set ? 1 : 0)));
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.isConverting()) {
            int boost = this.getConversionTimeBoost();
            this.conversionTime -= boost;
            if (this.conversionTime <= 0) {
                this.convertToVillager();
            }
        }
        super.func_70071_h_();
    }

    public void func_70077_a(EntityLightningBolt entityLightningBolt) {
        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5f, true, true);
        this.func_70081_e(5);
        this.func_70015_d(8);
    }

    public int getAttackStrength(Entity entity) {
        ItemStack itemstack = this.func_70694_bm();
        int strength = 4;
        if (itemstack != null) {
            strength += 2;
        }
        return strength;
    }

    protected String func_70639_aQ() {
        return "mob.zombie.say";
    }

    protected String func_70621_aR() {
        return "mob.zombie.hurt";
    }

    protected String func_70673_aS() {
        return "mob.zombie.death";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.zombie.step", 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        ItemStack heldItem = this.func_70694_bm();
        if (heldItem != null) {
            return heldItem.func_77973_b();
        }
        return Items.field_151078_bh;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected void func_70600_l(int unused) {
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                this.func_145779_a(Items.field_151042_j, 1);
                break;
            }
            case 1: {
                this.func_145779_a(Items.field_151172_bF, 1);
                break;
            }
            case 2: {
                this.func_145779_a(Items.field_151174_bG, 1);
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.func_70631_g_()) {
            nbt.func_74757_a("IsBaby", true);
        }
        if (this.isVillager()) {
            nbt.func_74757_a("IsVillager", true);
        }
        nbt.func_74768_a("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (nbt.func_74767_n("IsVillager")) {
            this.setVillager(true);
        }
        if (nbt.func_74764_b("ConversionTime") && nbt.func_74762_e("ConversionTime") > -1) {
            this.startConversion(nbt.func_74762_e("ConversionTime"));
        }
    }

    protected void func_82164_bB() {
        super.func_82164_bB();
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            switch (this.field_70146_Z.nextInt(6)) {
                case 0: {
                    this.func_70062_b(0, new ItemStack(Items.field_151048_u));
                    break;
                }
                case 1: {
                    this.func_70062_b(0, new ItemStack(Items.field_151040_l));
                    break;
                }
                case 2: {
                    this.func_70062_b(0, new ItemStack(Items.field_151047_v));
                    break;
                }
                case 3: {
                    this.func_70062_b(0, new ItemStack(Items.field_151037_a));
                }
            }
        }
    }

    public void func_70074_a(EntityLivingBase entityLiving) {
        super.func_70074_a(entityLiving);
        if (this.field_70170_p.field_73013_u.func_151525_a() >= EnumDifficulty.NORMAL.func_151525_a() && entityLiving instanceof EntityVillager) {
            if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL && this.field_70146_Z.nextBoolean()) {
                return;
            }
            EntityCrackedZombie crackedZombie = new EntityCrackedZombie(this.field_70170_p);
            crackedZombie.func_82149_j((Entity)entityLiving);
            this.field_70170_p.func_72900_e((Entity)entityLiving);
            crackedZombie.func_110161_a(null);
            crackedZombie.setVillager(true);
            if (entityLiving.func_70631_g_()) {
                crackedZombie.setChild(true);
            }
            this.field_70170_p.func_72838_d((Entity)crackedZombie);
            this.field_70170_p.func_72889_a((EntityPlayer)null, 1016, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        }
    }

    public boolean isConverting() {
        return this.func_70096_w().func_75683_a(14) == 1;
    }

    public boolean func_70085_c(EntityPlayer entityPlayer) {
        ItemStack equippedItem = entityPlayer.func_71045_bC();
        if (equippedItem != null && equippedItem.func_77973_b() == Items.field_151153_ao && equippedItem.func_77960_j() == 0 && this.isVillager() && this.func_70644_a(Potion.field_76437_t)) {
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                --equippedItem.field_77994_a;
            }
            if (equippedItem.field_77994_a <= 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.startConversion(this.field_70146_Z.nextInt(2401) + 3600);
            }
            return true;
        }
        return false;
    }

    protected void startConversion(int conTime) {
        this.conversionTime = conTime;
        this.func_70096_w().func_75692_b(14, (Object)1);
        this.func_82170_o(Potion.field_76437_t.field_76415_H);
        this.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, conTime, Math.min(this.field_70170_p.field_73013_u.func_151525_a() - 1, 0)));
        this.field_70170_p.func_72960_a((Entity)this, (byte)16);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte health) {
        if (health == 16) {
            this.field_70170_p.func_72980_b(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "mob.zombie.remedy", 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
        } else {
            super.func_70103_a(health);
        }
    }

    protected void convertToVillager() {
        EntityVillager villager = new EntityVillager(this.field_70170_p);
        villager.func_82149_j((Entity)this);
        villager.func_110161_a(null);
        villager.func_82187_q();
        if (this.func_70631_g_()) {
            villager.func_70873_a(-24000);
        }
        this.field_70170_p.func_72900_e((Entity)this);
        this.field_70170_p.func_72838_d((Entity)villager);
        villager.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 0));
        this.field_70170_p.func_72889_a((EntityPlayer)null, 1017, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
    }

    protected int getConversionTimeBoost() {
        int boostTime = 1;
        if (this.field_70146_Z.nextFloat() < 0.01f) {
            int count = 0;
            for (int x = (int)this.field_70165_t - 4; x < (int)this.field_70165_t + 4 && count < 14; ++x) {
                for (int y = (int)this.field_70163_u - 4; y < (int)this.field_70163_u + 4 && count < 14; ++y) {
                    for (int z = (int)this.field_70161_v - 4; z < (int)this.field_70161_v + 4 && count < 14; ++z) {
                        Block block = this.field_70170_p.func_147439_a(x, y, z);
                        if (block != Blocks.field_150411_aY && block != Blocks.field_150324_C) continue;
                        if (this.field_70146_Z.nextFloat() < 0.3f) {
                            ++boostTime;
                        }
                        ++count;
                    }
                }
            }
        }
        return boostTime;
    }
}

