/*
 * Decompiled with CFR 0.152.
 */
package com.crackedzombie.common;

import com.crackedzombie.common.CommonProxyCrackedZombie;
import com.crackedzombie.common.ConfigHandler;
import com.crackedzombie.common.EntityCrackedPigZombie;
import com.crackedzombie.common.EntityCrackedZombie;
import com.crackedzombie.common.PlayerJoinedWorldEventHandler;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="crackedzombiemod", name="Cracked Zombie Mod", version="3.2.4", guiFactory="com.crackedzombie.client.CrackedZombieConfigGUIFactory", acceptedMinecraftVersions="[1.8.9]")
public class CrackedZombie {
    public static final String mcversion = "1.8.9";
    public static final String modversion = "3.2.4";
    public static final String modid = "crackedzombiemod";
    public static final String name = "Cracked Zombie Mod";
    public static final String zombieName = "CrackedZombie";
    public static final String pigzombieName = "CrackedPigZombie";
    public static final String guifactory = "com.crackedzombie.client.CrackedZombieConfigGUIFactory";
    public int entityID = 0;
    @Mod.Instance(value="crackedzombiemod")
    public static CrackedZombie instance;
    @SidedProxy(clientSide="com.crackedzombie.client.ClientProxyCrackedZombie", serverSide="com.crackedzombie.common.CommonProxyCrackedZombie")
    public static CommonProxyCrackedZombie proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.startConfig(event);
        EntityRegistry.registerModEntity(EntityCrackedZombie.class, (String)zombieName, (int)this.entityID++, (Object)instance, (int)80, (int)3, (boolean)true, (int)44975, (int)7969861);
        EntityRegistry.registerModEntity(EntityCrackedPigZombie.class, (String)pigzombieName, (int)this.entityID, (Object)instance, (int)80, (int)3, (boolean)true, (int)44975, (int)7969861);
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        if (ConfigHandler.getStartWithSword()) {
            MinecraftForge.EVENT_BUS.register((Object)new PlayerJoinedWorldEventHandler());
        }
        proxy.registerRenderers();
        DungeonHooks.addDungeonMob((String)zombieName, (int)200);
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151040_l), 1, 1, 4));
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        BiomeDictionary.registerAllBiomesAndGenerateEvents();
        proxy.info("*** Scanning for available biomes");
        BiomeGenBase[] allBiomes = (BiomeGenBase[])Iterators.toArray((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])BiomeGenBase.func_150565_n()), (Predicate)Predicates.notNull()), BiomeGenBase.class);
        this.printBiomeList(allBiomes);
        int zombieSpawnProb = ConfigHandler.getZombieSpawnProbility();
        int pigzombieSpawnProb = ConfigHandler.getPigZombieSpawnProbility();
        int minSpawn = ConfigHandler.getMinSpawn();
        int maxSpawn = ConfigHandler.getMaxSpawn();
        int minPZSpawn = ConfigHandler.getMinPZSpawn();
        int maxPZSpawn = ConfigHandler.getMaxPZSpawn();
        EntityRegistry.addSpawn(EntityCrackedZombie.class, (int)zombieSpawnProb, (int)minSpawn, (int)maxSpawn, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
        if (ConfigHandler.getAllowPigZombieSpawns()) {
            proxy.info("*** Allowing CrackedPigZombie spawns");
            EntityRegistry.addSpawn(EntityCrackedPigZombie.class, (int)pigzombieSpawnProb, (int)minPZSpawn, (int)maxPZSpawn, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
        } else {
            proxy.info("*** Not allowing CrackedPigZombie spawns");
        }
        if (!ConfigHandler.getZombieSpawns()) {
            proxy.info("*** Disabling default zombie spawns for all biomes");
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Zombie");
        } else {
            proxy.info("NOT disabling default zombie spawns, there will be fewer CrackedZombies!");
        }
        if (!ConfigHandler.getPigZombieSpawns()) {
            proxy.info("*** Disabling default pig zombie spawns for all biomes");
            EntityRegistry.removeSpawn(EntityPigZombie.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
        } else {
            proxy.info("NOT disabling default zombie spawns, there will be fewer CrackedPigZombies!");
        }
        if (!ConfigHandler.getSpawnCreepers()) {
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
            proxy.info("*** Removing creeper spawns");
        }
        if (!ConfigHandler.getSpawnSkeletons()) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Skeleton");
            proxy.info("*** Removing skeleton spawns and dungeon spawners");
        }
        if (!ConfigHandler.getSpawnEnderman()) {
            EntityRegistry.removeSpawn(EntityEnderman.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
            proxy.info("*** Removing enderman spawns");
        }
        if (!ConfigHandler.getSpawnSpiders()) {
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Spider");
            proxy.info("*** Removing spider spawns and dungeon spawners");
        }
        if (!ConfigHandler.getSpawnSlime()) {
            EntityRegistry.removeSpawn(EntitySlime.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
            proxy.info("*** Removing slime spawns");
        }
        if (!ConfigHandler.getSpawnWitches()) {
            EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
            proxy.info("*** Removing witch spawns");
        }
    }

    public void printBiomeList(BiomeGenBase[] biomes) {
        for (BiomeGenBase bgb : biomes) {
            proxy.info("  >>> Including biome " + bgb.field_76791_y + " for spawning");
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(modid)) {
            if (event.requiresMcRestart) {
                proxy.info("The configuration changes require a Minecraft restart!");
            }
            proxy.info("Configuration changes have been updated for the Cracked Zombie Mod");
            ConfigHandler.updateConfigInfo();
        }
    }
}

