/*
 * Decompiled with CFR 0.152.
 */
package com.crackedzombie.common;

import com.crackedzombie.common.ConfigHandler;
import com.crackedzombie.common.EntityAIMigrate;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCrackedZombie
extends EntityMob {
    protected static final IAttribute reinforcements = new RangedAttribute(null, "zombie.spawnReinforcements", 0.0, 0.0, 1.0).func_111117_a("Spawn Reinforcements Chance");
    private static final UUID uuid = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier speedBoost = new AttributeModifier(uuid, "Baby speed boost", 0.1, 0);
    private final double noSpawnRadius = ConfigHandler.getTorchNoSpawnRadius();
    private final boolean allowChildSpawns = ConfigHandler.getAllowChildSpawns();
    private final boolean attackPigs = ConfigHandler.getAttackPigs();
    private final boolean attackVillagers = ConfigHandler.getAttackVillagers();
    private int conversionTime = 0;
    private float zombieWidth = -1.0f;
    private float zombieHeight;

    public EntityCrackedZombie(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179690_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (ConfigHandler.getDoorBusting()) {
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2, false));
        if (this.attackVillagers) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, true));
        }
        if (this.attackPigs) {
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPig.class, 1.0, false));
        }
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMigrate((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.applyEntityAI();
        this.func_70105_a(0.6f, 1.8f);
    }

    private void applyEntityAI() {
        if (this.attackVillagers) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, true));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityIronGolem.class, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        if (this.attackPigs) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPig.class, false));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(ConfigHandler.getFollowRange());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ConfigHandler.getMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.getAttackDamage());
        this.func_110140_aT().func_111150_b(reinforcements).func_111128_a(this.field_70146_Z.nextDouble() * 0.1);
    }

    public boolean getHasTarget() {
        float attackDistance = 16.0f;
        return this.isAttackableEntity((EntityLivingBase)this, attackDistance);
    }

    public boolean isAttackableEntity(EntityLivingBase entityLiving, double distance) {
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, 4.0, distance));
        for (Object aList : list) {
            double dist;
            Entity entity = (Entity)aList;
            EntityLivingBase target = (EntityLivingBase)entity;
            if (!this.isGoodTarget(target) || !((dist = target.func_70092_e(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v)) < distance * distance)) continue;
            return true;
        }
        return false;
    }

    public boolean isGoodTarget(EntityLivingBase target) {
        boolean pig;
        if (target == null || target == this || !target.func_70089_S()) {
            return false;
        }
        boolean player = target instanceof EntityPlayer;
        boolean villager = this.attackVillagers && target instanceof EntityVillager;
        boolean bl = pig = this.attackPigs && target instanceof EntityPig;
        if (player && ((EntityPlayer)target).field_71075_bZ.field_75098_d) {
            return false;
        }
        return (player || villager || pig) && this.func_70685_l((Entity)target);
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (super.func_70097_a(damageSource, damage)) {
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (entitylivingbase == null && damageSource.func_76346_g() instanceof EntityLivingBase) {
                entitylivingbase = (EntityLivingBase)damageSource.func_76346_g();
            }
            int posx = MathHelper.func_76128_c((double)this.field_70165_t);
            int posy = MathHelper.func_76128_c((double)this.field_70163_u);
            int posz = MathHelper.func_76128_c((double)this.field_70161_v);
            if (entitylivingbase != null && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && (double)this.field_70146_Z.nextFloat() < this.func_110148_a(reinforcements).func_111126_e()) {
                EntityCrackedZombie crackedZombie = new EntityCrackedZombie(this.field_70170_p);
                for (int l = 0; l < 50; ++l) {
                    int z;
                    int y;
                    int x = posx + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    BlockPos bp = new BlockPos(x, (y = posy + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1)) - 1, z = posz + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1));
                    if (!World.func_175683_a((IBlockAccess)this.field_70170_p, (BlockPos)bp)) continue;
                    crackedZombie.func_70107_b(x, y, z);
                    if (!this.field_70170_p.func_72855_b(crackedZombie.func_174813_aQ()) || !this.field_70170_p.func_72945_a((Entity)crackedZombie, crackedZombie.func_174813_aQ()).isEmpty() || this.field_70170_p.func_72953_d(crackedZombie.func_174813_aQ())) continue;
                    this.field_70170_p.func_72838_d((Entity)crackedZombie);
                    crackedZombie.func_70624_b(entitylivingbase);
                    crackedZombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)crackedZombie)), null);
                    this.func_110148_a(reinforcements).func_111121_a(new AttributeModifier("Zombie reinforcement caller charge", -0.05, 0));
                    crackedZombie.func_110148_a(reinforcements).func_111121_a(new AttributeModifier("Zombie reinforcement callee charge", -0.05, 0));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                int strength = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    strength = 7;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    strength = 15;
                }
                if (ConfigHandler.getSickness()) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, strength * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_()) {
            ItemStack itemstack;
            float brightness = this.func_70013_c(1.0f);
            BlockPos blockpos = new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (brightness > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos) && (itemstack = this.func_71124_b(4)) != null && itemstack.func_77984_f()) {
                itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                    this.func_70669_a(itemstack);
                    this.func_70062_b(4, null);
                }
            }
        }
        if (this.func_70115_ae() && this.func_70638_az() != null && this.field_70154_o instanceof EntityChicken) {
            ((EntityLiving)this.field_70154_o).func_70661_as().func_75484_a(this.func_70661_as().func_75505_d(), 1.5);
        }
        super.func_70636_d();
    }

    public boolean func_70601_bi() {
        AxisAlignedBB entityAABB = this.func_174813_aQ();
        if (this.noSpawnRadius > 0.0 && this.foundNearbyTorches(entityAABB)) {
            return false;
        }
        boolean notColliding = this.field_70170_p.func_72945_a((Entity)this, entityAABB).isEmpty();
        boolean isLiquid = this.field_70170_p.func_72953_d(entityAABB);
        BlockPos bp = new BlockPos(this.field_70165_t, entityAABB.field_72338_b - 1.0, this.field_70161_v);
        Block block = this.field_70170_p.func_180495_p(bp).func_177230_c();
        boolean isGrass = block == Blocks.field_150349_c;
        boolean isSand = block == Blocks.field_150354_m;
        boolean isClay = block == Blocks.field_150405_ch || block == Blocks.field_150406_ce;
        boolean isDirt = block == Blocks.field_150346_d;
        boolean isStone = this.field_70146_Z.nextBoolean() && block == Blocks.field_150348_b;
        return (isGrass || isSand || isStone || isClay || isDirt) && notColliding && !isLiquid;
    }

    public boolean foundNearbyTorches(AxisAlignedBB aabb) {
        boolean result = false;
        int xMin = MathHelper.func_76128_c((double)(aabb.field_72340_a - this.noSpawnRadius));
        int xMax = MathHelper.func_76128_c((double)(aabb.field_72336_d + this.noSpawnRadius));
        int yMin = MathHelper.func_76128_c((double)(aabb.field_72338_b - this.noSpawnRadius));
        int yMax = MathHelper.func_76128_c((double)(aabb.field_72337_e + this.noSpawnRadius));
        int zMin = MathHelper.func_76128_c((double)(aabb.field_72339_c - this.noSpawnRadius));
        int zMax = MathHelper.func_76128_c((double)(aabb.field_72334_f + this.noSpawnRadius));
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    Block block = this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                    if (!(block instanceof BlockTorch)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.func_70096_w().func_75682_a(13, (Object)0);
        this.func_70096_w().func_75682_a(14, (Object)0);
    }

    public int func_70658_aO() {
        int armor = super.func_70658_aO() + 2;
        if (armor > 20) {
            armor = 20;
        }
        return armor;
    }

    protected boolean func_70692_ba() {
        return !this.isConverting();
    }

    public boolean func_70631_g_() {
        return this.func_70096_w().func_75683_a(12) == 1;
    }

    public void setChild(boolean childZombie) {
        if (this.allowChildSpawns) {
            this.func_70096_w().func_75692_b(12, (Object)((byte)(childZombie ? 1 : 0)));
            if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
                IAttributeInstance attributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                attributeinstance.func_111124_b(speedBoost);
                if (childZombie) {
                    attributeinstance.func_111121_a(speedBoost);
                }
            }
            this.setChildSize(childZombie);
        }
    }

    protected final void func_70105_a(float width, float height) {
        boolean isSizeValid = this.zombieWidth > 0.0f && this.zombieHeight > 0.0f;
        this.zombieWidth = width;
        this.zombieHeight = height;
        if (!isSizeValid) {
            this.multiplySize(1.0f);
        }
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.zombieWidth * size, this.zombieHeight * size);
    }

    public boolean isVillager() {
        return this.func_70096_w().func_75683_a(13) == 1;
    }

    public void setVillager(boolean set) {
        this.func_70096_w().func_75692_b(13, (Object)((byte)(set ? 1 : 0)));
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.isConverting()) {
            int boost = this.getConversionTimeBoost();
            this.conversionTime -= boost;
            if (this.conversionTime <= 0) {
                this.convertToVillager();
            }
        }
        super.func_70071_h_();
    }

    public void func_70077_a(EntityLightningBolt entityLightningBolt) {
        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5f, true, true);
        this.func_70081_e(5);
        this.func_70015_d(8);
    }

    protected String func_70639_aQ() {
        return "mob.zombie.say";
    }

    protected String func_70621_aR() {
        return "mob.zombie.hurt";
    }

    protected String func_70673_aS() {
        return "mob.zombie.death";
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_85030_a("mob.zombie.step", 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        ItemStack heldItem = this.func_70694_bm();
        if (heldItem != null) {
            return heldItem.func_77973_b();
        }
        return Items.field_151078_bh;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected void func_82164_bB() {
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                this.func_145779_a(Items.field_151042_j, 1);
                break;
            }
            case 1: {
                this.func_145779_a(Items.field_151172_bF, 1);
                break;
            }
            case 2: {
                this.func_145779_a(Items.field_151174_bG, 1);
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.func_70631_g_()) {
            nbt.func_74757_a("IsBaby", true);
        }
        if (this.isVillager()) {
            nbt.func_74757_a("IsVillager", true);
        }
        nbt.func_74768_a("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (nbt.func_74767_n("IsVillager")) {
            this.setVillager(true);
        }
        if (nbt.func_74764_b("ConversionTime") && nbt.func_74762_e("ConversionTime") > -1) {
            this.startConversion(nbt.func_74762_e("ConversionTime"));
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            switch (this.field_70146_Z.nextInt(4)) {
                case 0: {
                    this.func_70062_b(0, new ItemStack(Items.field_151048_u));
                    break;
                }
                case 1: {
                    this.func_70062_b(0, new ItemStack(Items.field_151040_l));
                    break;
                }
                case 2: {
                    this.func_70062_b(0, new ItemStack(Items.field_151047_v));
                    break;
                }
                case 3: {
                    this.func_70062_b(0, new ItemStack(Items.field_151037_a));
                }
            }
        }
    }

    public void func_70074_a(EntityLivingBase entityLiving) {
        super.func_70074_a(entityLiving);
        if (this.field_70170_p.func_175659_aa().func_151525_a() >= EnumDifficulty.NORMAL.func_151525_a() && entityLiving instanceof EntityVillager) {
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL && this.field_70146_Z.nextBoolean()) {
                return;
            }
            EntityCrackedZombie crackedZombie = new EntityCrackedZombie(this.field_70170_p);
            crackedZombie.func_82149_j((Entity)entityLiving);
            this.field_70170_p.func_72900_e((Entity)entityLiving);
            crackedZombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)crackedZombie)), null);
            crackedZombie.setVillager(true);
            if (entityLiving.func_70631_g_()) {
                crackedZombie.setChild(true);
            }
            this.field_70170_p.func_72838_d((Entity)crackedZombie);
            this.field_70170_p.func_180498_a(null, 1016, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 16) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_72980_b(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "mob.zombie.remedy", 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isConverting() {
        return this.func_70096_w().func_75683_a(14) == 1;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        IEntityLivingData zombieGroupData = super.func_180482_a(difficulty, livingdata);
        float additionalDifficulty = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * additionalDifficulty);
        if (zombieGroupData == null) {
            zombieGroupData = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance, this.field_70170_p.field_73012_v.nextFloat() < 0.05f, null);
        }
        if (zombieGroupData instanceof GroupData) {
            GroupData groupdata = (GroupData)zombieGroupData;
            if (groupdata.isVillager) {
                this.setVillager(true);
            }
            if (groupdata.isChild) {
                this.setChild(true);
                if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    List list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntitySelectors.field_152785_b);
                    if (!list.isEmpty()) {
                        EntityChicken entitychicken = (EntityChicken)list.get(0);
                        entitychicken.func_152117_i(true);
                        this.func_70078_a((Entity)entitychicken);
                    }
                } else if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    EntityChicken chicken = new EntityChicken(this.field_70170_p);
                    chicken.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    chicken.func_180482_a(difficulty, null);
                    chicken.func_152117_i(true);
                    this.field_70170_p.func_72838_d((Entity)chicken);
                    this.func_70078_a((Entity)chicken);
                }
            }
        }
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_71124_b(4) == null) {
            Calendar calendar = this.field_70170_p.func_83015_S();
            int day = calendar.get(5);
            int month = calendar.get(2) + 1;
            if (month == 10 && day == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
                this.func_70062_b(4, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
                this.field_82174_bp[4] = 0.0f;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * 0.05, 0));
        double spawnBonus = this.field_70146_Z.nextDouble() * 1.5 * (double)additionalDifficulty;
        if (spawnBonus > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", spawnBonus, 2));
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.05f) {
            this.func_110148_a(reinforcements).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 0.25 + 0.5, 0));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
        }
        return zombieGroupData;
    }

    public boolean func_70085_c(EntityPlayer entityPlayer) {
        ItemStack equippedItem = entityPlayer.func_71045_bC();
        if (equippedItem != null && equippedItem.func_77973_b() == Items.field_151153_ao && equippedItem.func_77952_i() == 0 && this.isVillager() && this.func_70644_a(Potion.field_76437_t)) {
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                --equippedItem.field_77994_a;
            }
            if (equippedItem.field_77994_a <= 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.startConversion(this.field_70146_Z.nextInt(2401) + 3600);
            }
            return true;
        }
        return false;
    }

    protected void startConversion(int conTime) {
        this.conversionTime = conTime;
        this.func_70096_w().func_75692_b(14, (Object)1);
        this.func_82170_o(Potion.field_76437_t.field_76415_H);
        this.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, conTime, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.field_70170_p.func_72960_a((Entity)this, (byte)16);
    }

    protected void convertToVillager() {
        EntityVillager villager = new EntityVillager(this.field_70170_p);
        villager.func_82149_j((Entity)this);
        villager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)villager)), null);
        villager.func_82187_q();
        if (this.func_70631_g_()) {
            villager.func_70873_a(-24000);
        }
        this.field_70170_p.func_72900_e((Entity)this);
        this.field_70170_p.func_72838_d((Entity)villager);
        villager.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 0));
        this.field_70170_p.func_180498_a(null, 1017, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), 0);
    }

    protected int getConversionTimeBoost() {
        int boostTime = 1;
        if (this.field_70146_Z.nextFloat() < 0.01f) {
            int count = 0;
            for (double x = this.field_70165_t - 4.0; x < this.field_70165_t + 4.0 && count < 14; x += 1.0) {
                for (double y = this.field_70163_u - 4.0; y < this.field_70163_u + 4.0 && count < 14; y += 1.0) {
                    for (double z = this.field_70161_v - 4.0; z < this.field_70161_v + 4.0 && count < 14; z += 1.0) {
                        Block block = this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        if (block != Blocks.field_150411_aY && block != Blocks.field_150324_C) continue;
                        if (this.field_70146_Z.nextFloat() < 0.3f) {
                            ++boostTime;
                        }
                        ++count;
                    }
                }
            }
        }
        return boostTime;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isChild = false;
        public boolean isVillager = false;

        private GroupData(boolean setChild, boolean setVillager) {
            this.isChild = setChild;
            this.isVillager = setVillager;
        }

        GroupData(boolean setChild, boolean setVillager, Object object) {
            this(setChild, setVillager);
        }
    }
}

