/*
 * Decompiled with CFR 0.152.
 */
package com.crackedzombie.common;

import com.crackedzombie.common.CrackedZombie;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHandler {
    public static Configuration config;
    private static int zombieSpawnProb;
    private static int pigzombieSpawnProb;
    private static boolean zombieSpawns;
    private static boolean pigZombieSpawns;
    private static boolean spawnCreepers;
    private static boolean spawnSkeletons;
    private static boolean spawnEnderman;
    private static boolean spawnSpiders;
    private static boolean spawnSlime;
    private static boolean spawnWitches;
    private static boolean doorBusting;
    private static boolean sickness;
    private static boolean pzSickness;
    private static boolean startWithSword;
    private static boolean enchantSword;
    private static int minSpawn;
    private static int maxSpawn;
    private static int minPZSpawn;
    private static int maxPZSpawn;
    private static double torchNoSpawnRadius;
    private static boolean allowChildSpawns;
    private static boolean allowPigZombieSpawns;
    private static double followRange;
    private static double moveSpeed;
    private static double attackDamage;
    private static double pzMoveSpeed;
    private static double pzAttackDamage;
    private static boolean attackPigs;
    private static boolean attackVillagers;
    private static boolean nightSpawnOnly;
    private static final String generalComments = "Cracked Zombie Mod Config\nMichael Sheppard (crackedEgg)\nFor Minecraft Version 1.9.4\n";
    private static final String spawnProbComment = "zombieSpawnProb adjust to probability of zombies spawning\nThe higher the number the more likely zombies will spawn.";
    private static final String pzSpawnProbComment = "pigzombieSpawnProb adjust to probability of pigzombies spawning\nThe higher the number the more likely pigzombies will spawn.";
    private static final String zombieComment = "zombieSpawns allows/disallows vanilla zombies spawns, default is false,\n no vanilla minecraft zombies will spawn. Only the CrackedZombies will spawn.\n If set to true, fewer CrackedZombies will spawn.";
    private static final String pigZombieComment = "pigZombieSpawns allows/disallows vanilla pig zombies spawns, default is false,\n no vanilla minecraft pig zombies will spawn. Only the CrackedPigZombies will spawn.\n If set to true, fewer CrackedPigZombies will spawn.";
    private static final String creeperComment = "creeperSpawns, set to false to disable creeper spawning, set to true if you want to spawn creepers";
    private static final String skeletonComment = "skeletonSpawns, set to false to disable skeleton spawning, set to true if you want to spawn skeletons";
    private static final String endermanComment = "endermanSpawns, set to false to disable enderman spawning, set to true if you want to spawn enderman";
    private static final String spiderComment = "spiderSpawns, set to false to disable spider spawning, set to true if you want to spawn spiders";
    private static final String slimeComment = "slimeSpawns, set to false to disable slime spawning, set to true if you want to spawn slimes";
    private static final String witchComment = "witchSpawns, set to false to disable witch spawning, set to true if you want to spawn witches";
    private static final String doorBustingComment = "doorBusting, set to true to have zombies try to break down doors, otherwise set to false. It's quieter.";
    private static final String crackedPigZombieComment = "allow CrackedPigZombies to spawn";
    private static final String childComment = "allowChildSpawns, set to true to have child zombies, otherwise set to false.";
    private static final String sicknessComment = "Sickness, set to true to have contact with zombies poison the player.";
    private static final String minSpawnComment = "minSpawn, minimum number of crackedzombies per spawn event";
    private static final String maxSpawnComment = "maxSpawn, maximum number of crackedzombies per spawn event";
    private static final String pzSicknessComment = "Pig Zombie Sickness, set to true to have contact with pigzombies poison the player.";
    private static final String minPZSpawnComment = "minPZSpawn, minimum number of crackedpigzombies per spawn event";
    private static final String maxPZSpawnComment = "maxPZSpawn, maximum number of crackedpigzombies per spawn event";
    private static final String startWithSwordComment = "Allows the player to spawn with a random type sword, handy in the apocalypse!";
    private static final String enchantSwordComment = "set true to enchant the sword given to the player";
    private static final String noSpawnRadiusComment = "set the radius in blocks for no spawning near torches, zero enables spawing near torches";
    private static final String followRangeComment = "set the follow range of the zombies";
    private static final String moveSpeedComment = "set the movement speed of the zombies";
    private static final String attackDamageComment = "set the initial attack damage caused by the zombies";
    private static final String pzMoveSpeedComment = "set the movement speed of the pig zombies";
    private static final String pzAttackDamageComment = "set the initial attack damage caused by the pig zombies";
    private static final String attackPigsComment = "Attack and kill pigs";
    private static final String attackVillagersComment = "Attack and convert villagers";
    private static final String nightSpawnOnlyComment = "Spawn cracked zombies at night only";

    public static void startConfig(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        ConfigHandler.updateConfigInfo();
    }

    public static void updateConfigInfo() {
        try {
            config.addCustomCategoryComment("general", generalComments);
            zombieSpawnProb = config.get("general", "zombieSpawnProb", 15, spawnProbComment).getInt();
            pigzombieSpawnProb = config.get("general", "pigzombieSpawnProb", 10, pzSpawnProbComment).getInt();
            zombieSpawns = config.get("general", "zombieSpawns", false, zombieComment).getBoolean(false);
            pigZombieSpawns = config.get("general", "pigZombieSpawns", false, pigZombieComment).getBoolean(false);
            spawnCreepers = config.get("general", "spawnCreepers", false, creeperComment).getBoolean(false);
            spawnSkeletons = config.get("general", "spawnSkeletons", false, skeletonComment).getBoolean(false);
            spawnEnderman = config.get("general", "spawnEnderman", false, endermanComment).getBoolean(false);
            spawnSpiders = config.get("general", "spawnSpiders", true, spiderComment).getBoolean(true);
            spawnSlime = config.get("general", "spawnSlime", false, slimeComment).getBoolean(false);
            spawnWitches = config.get("general", "spawnWitches", true, witchComment).getBoolean(true);
            doorBusting = config.get("general", "doorBusting", false, doorBustingComment).getBoolean(false);
            sickness = config.get("general", "sickness", false, sicknessComment).getBoolean(false);
            pzSickness = config.get("general", "pzSickness", false, pzSicknessComment).getBoolean(false);
            startWithSword = config.get("general", "startWithSword", false, startWithSwordComment).getBoolean(false);
            enchantSword = config.get("general", "enchantSword", false, enchantSwordComment).getBoolean(false);
            minSpawn = config.get("general", "minSpawn", 4, minSpawnComment).getInt();
            maxSpawn = config.get("general", "maxSpawn", 4, maxSpawnComment).getInt();
            minPZSpawn = config.get("general", "minPZSpawn", 4, minPZSpawnComment).getInt();
            maxPZSpawn = config.get("general", "maxPZSpawn", 4, maxPZSpawnComment).getInt();
            torchNoSpawnRadius = config.get("general", "noSpawnTorchRadius", 3.0, noSpawnRadiusComment).getDouble();
            allowChildSpawns = config.get("general", "allowChildSpawns", true, childComment).getBoolean(true);
            allowPigZombieSpawns = config.get("general", "allowPigZombieSpawns", true, crackedPigZombieComment).getBoolean(true);
            followRange = config.get("general", "followRange", 35.0, followRangeComment).getDouble();
            moveSpeed = config.get("general", "moveSpeed", 0.23, moveSpeedComment).getDouble();
            attackDamage = config.get("general", "attackDamage", 3.0, attackDamageComment).getDouble();
            pzMoveSpeed = config.get("general", "pzMoveSpeed", 0.23, pzMoveSpeedComment).getDouble();
            pzAttackDamage = config.get("general", "pzAttackDamage", 5.0, pzAttackDamageComment).getDouble();
            attackPigs = config.get("general", "attackPigs", true, attackPigsComment).getBoolean(true);
            attackVillagers = config.get("general", "attackVillagers", true, attackVillagersComment).getBoolean(true);
            nightSpawnOnly = config.get("general", "nightSpawnOnly", false, nightSpawnOnlyComment).getBoolean(false);
        }
        catch (Exception e) {
            CrackedZombie.proxy.info("failed to load or read the config file");
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static boolean getSpawnCreepers() {
        return spawnCreepers;
    }

    public static boolean getSpawnSkeletons() {
        return spawnSkeletons;
    }

    public static boolean getSpawnEnderman() {
        return spawnEnderman;
    }

    public static boolean getSpawnSpiders() {
        return spawnSpiders;
    }

    public static boolean getSpawnSlime() {
        return spawnSlime;
    }

    public static boolean getSpawnWitches() {
        return spawnWitches;
    }

    public static int getMinSpawn() {
        return minSpawn;
    }

    public static int getMaxSpawn() {
        return maxSpawn;
    }

    public static int getMinPZSpawn() {
        return minPZSpawn;
    }

    public static int getMaxPZSpawn() {
        return maxPZSpawn;
    }

    public static int getZombieSpawnProbility() {
        return zombieSpawnProb;
    }

    public static int getPigZombieSpawnProbility() {
        return pigzombieSpawnProb;
    }

    public static boolean getZombieSpawns() {
        return zombieSpawns;
    }

    public static boolean getPigZombieSpawns() {
        return pigZombieSpawns;
    }

    public static boolean getDoorBusting() {
        return doorBusting;
    }

    public static boolean getSickness() {
        return sickness;
    }

    public static boolean getPZSickness() {
        return pzSickness;
    }

    public static boolean getStartWithSword() {
        return startWithSword;
    }

    public static boolean getEnchantSword() {
        return enchantSword;
    }

    public static double getTorchNoSpawnRadius() {
        return torchNoSpawnRadius;
    }

    public static boolean getAllowChildSpawns() {
        return allowChildSpawns;
    }

    public static boolean getAllowPigZombieSpawns() {
        return allowPigZombieSpawns;
    }

    public static double getMovementSpeed() {
        return moveSpeed;
    }

    public static double getPZMovementSpeed() {
        return pzMoveSpeed;
    }

    public static double getFollowRange() {
        return followRange;
    }

    public static double getAttackDamage() {
        return attackDamage;
    }

    public static double getPZAttackDamage() {
        return pzAttackDamage;
    }

    public static boolean getAttackPigs() {
        return attackPigs;
    }

    public static boolean getAttackVillagers() {
        return attackVillagers;
    }

    public static boolean getNightSpawnOnly() {
        return nightSpawnOnly;
    }
}

