/*
 * Decompiled with CFR 0.152.
 */
package com.crackedzombie.common;

import com.crackedzombie.common.CommonProxyCrackedZombie;
import com.crackedzombie.common.ConfigHandler;
import com.crackedzombie.common.EntityCrackedPigZombie;
import com.crackedzombie.common.EntityCrackedZombie;
import com.crackedzombie.common.PlayerJoinedWorldEventHandler;
import java.util.LinkedList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="crackedzombiemod", name="Cracked Zombie Mod", version="3.4.1", guiFactory="com.crackedzombie.client.CrackedZombieConfigGUIFactory", acceptedMinecraftVersions="[1.9.4]")
public class CrackedZombie {
    public static final String mcversion = "1.9.4";
    public static final String modversion = "3.4.1";
    public static final String modid = "crackedzombiemod";
    public static final String name = "Cracked Zombie Mod";
    public static final String zombieName = "CrackedZombie";
    public static final String pigzombieName = "CrackedPigZombie";
    public static final String guifactory = "com.crackedzombie.client.CrackedZombieConfigGUIFactory";
    private int entityID = 0;
    private BiomeDictionary.Type[] biometypes = new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MESA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND};
    @Mod.Instance(value="crackedzombiemod")
    public static CrackedZombie instance;
    @SidedProxy(clientSide="com.crackedzombie.client.ClientProxyCrackedZombie", serverSide="com.crackedzombie.common.CommonProxyCrackedZombie")
    public static CommonProxyCrackedZombie proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.startConfig(event);
        EntityRegistry.registerModEntity(EntityCrackedZombie.class, (String)zombieName, (int)this.entityID++, (Object)instance, (int)80, (int)3, (boolean)true, (int)44975, (int)7969861);
        EntityRegistry.registerModEntity(EntityCrackedPigZombie.class, (String)pigzombieName, (int)this.entityID, (Object)instance, (int)80, (int)3, (boolean)true, (int)7969861, (int)44975);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        if (ConfigHandler.getStartWithSword()) {
            MinecraftForge.EVENT_BUS.register((Object)new PlayerJoinedWorldEventHandler());
        }
        DungeonHooks.addDungeonMob((String)zombieName, (int)200);
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        BiomeDictionary.registerAllBiomesAndGenerateEvents();
        proxy.info("*** Scanning for available biomes");
        Biome[] allBiomes = this.getBiomes(this.biometypes);
        int zombieSpawnProb = ConfigHandler.getZombieSpawnProbility();
        int pigzombieSpawnProb = ConfigHandler.getPigZombieSpawnProbility();
        int minSpawn = ConfigHandler.getMinSpawn();
        int maxSpawn = ConfigHandler.getMaxSpawn();
        int minPZSpawn = ConfigHandler.getMinPZSpawn();
        int maxPZSpawn = ConfigHandler.getMaxPZSpawn();
        EntityRegistry.addSpawn(EntityCrackedZombie.class, (int)zombieSpawnProb, (int)minSpawn, (int)maxSpawn, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
        if (ConfigHandler.getAllowPigZombieSpawns()) {
            proxy.info("*** Allowing CrackedPigZombie spawns");
            EntityRegistry.addSpawn(EntityCrackedPigZombie.class, (int)pigzombieSpawnProb, (int)minPZSpawn, (int)maxPZSpawn, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
        } else {
            proxy.info("*** Not allowing CrackedPigZombie spawns");
        }
        if (!ConfigHandler.getZombieSpawns()) {
            proxy.info("*** Disabling default zombie spawns for all biomes");
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Zombie");
        } else {
            proxy.info("NOT disabling default zombie spawns, there will be fewer CrackedZombies!");
        }
        if (!ConfigHandler.getPigZombieSpawns()) {
            proxy.info("*** Disabling default pig zombie spawns for all biomes");
            EntityRegistry.removeSpawn(EntityPigZombie.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
        } else {
            proxy.info("NOT disabling default zombie spawns, there will be fewer CrackedPigZombies!");
        }
        if (!ConfigHandler.getSpawnCreepers()) {
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
            proxy.info("*** Removing creeper spawns");
        }
        if (!ConfigHandler.getSpawnSkeletons()) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Skeleton");
            proxy.info("*** Removing skeleton spawns and dungeon spawners");
        }
        if (!ConfigHandler.getSpawnEnderman()) {
            EntityRegistry.removeSpawn(EntityEnderman.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
            proxy.info("*** Removing enderman spawns");
        }
        if (!ConfigHandler.getSpawnSpiders()) {
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Spider");
            proxy.info("*** Removing spider spawns and dungeon spawners");
        }
        if (!ConfigHandler.getSpawnSlime()) {
            EntityRegistry.removeSpawn(EntitySlime.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
            proxy.info("*** Removing slime spawns");
        }
        if (!ConfigHandler.getSpawnWitches()) {
            EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])allBiomes);
            proxy.info("*** Removing witch spawns");
        }
    }

    public Biome[] getBiomes(BiomeDictionary.Type ... types) {
        LinkedList<Biome> list = new LinkedList<Biome>();
        for (BiomeDictionary.Type t : types) {
            Biome[] biomes;
            for (Biome bgb : biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)t)) {
                if (list.contains(bgb)) continue;
                list.add(bgb);
                proxy.info("  >>> Including biome " + bgb.func_185359_l() + " for spawning");
            }
        }
        return list.toArray(new Biome[0]);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(modid)) {
            if (event.isRequiresMcRestart()) {
                proxy.info("The configuration changes require a Minecraft restart!");
            }
            proxy.info("Configuration changes have been updated for the Cracked Zombie Mod");
            ConfigHandler.updateConfigInfo();
        }
    }
}

