/*
 * Decompiled with CFR 0.152.
 */
package com.crackedzombie.common;

import com.crackedzombie.common.CheckSpawnEvent;
import com.crackedzombie.common.CommonProxyCrackedZombie;
import com.crackedzombie.common.ConfigHandler;
import com.crackedzombie.common.EntityCrackedPigZombie;
import com.crackedzombie.common.EntityCrackedZombie;
import com.crackedzombie.common.PlayerJoinedWorldEventHandler;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="crackedzombiemod", name="Cracked Zombie Mod", version="3.6.2", guiFactory="com.crackedzombie.client.CrackedZombieConfigGUIFactory", acceptedMinecraftVersions="[1.11.2]")
public class CrackedZombie {
    public static final String mcversion = "1.11.2";
    public static final String modversion = "3.6.2";
    public static final String modid = "crackedzombiemod";
    public static final String name = "Cracked Zombie Mod";
    public static final String zombieName = "CrackedZombie";
    public static final String pigzombieName = "CrackedPigZombie";
    public static final String guifactory = "com.crackedzombie.client.CrackedZombieConfigGUIFactory";
    private int entityID = 0;
    private static boolean spawnInNether = ConfigHandler.getSpawnInNether();
    private static boolean spawnInEnd = ConfigHandler.getSpawnInEnd();
    @Mod.Instance(value="crackedzombiemod")
    public static CrackedZombie instance;
    @SidedProxy(clientSide="com.crackedzombie.client.ClientProxyCrackedZombie", serverSide="com.crackedzombie.common.CommonProxyCrackedZombie")
    public static CommonProxyCrackedZombie proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.startConfig(event);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modid, zombieName), EntityCrackedZombie.class, (String)zombieName, (int)this.entityID++, (Object)instance, (int)80, (int)3, (boolean)true, (int)44975, (int)7969861);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modid, pigzombieName), EntityCrackedPigZombie.class, (String)pigzombieName, (int)this.entityID, (Object)instance, (int)80, (int)3, (boolean)true, (int)7969861, (int)44975);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerJoinedWorldEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CheckSpawnEvent());
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation(modid, zombieName), (int)200);
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        proxy.info("*** Scanning for available biomes");
        Biome[] spawnBiomes = this.getSpawnBiomes();
        int zombieSpawnProb = ConfigHandler.getZombieSpawnProbility();
        int pigzombieSpawnProb = ConfigHandler.getPigZombieSpawnProbility();
        int minSpawn = ConfigHandler.getMinSpawn();
        int maxSpawn = ConfigHandler.getMaxSpawn();
        int minPZSpawn = ConfigHandler.getMinPZSpawn();
        int maxPZSpawn = ConfigHandler.getMaxPZSpawn();
        EntityRegistry.addSpawn(EntityCrackedZombie.class, (int)zombieSpawnProb, (int)minSpawn, (int)maxSpawn, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
        if (ConfigHandler.getAllowPigZombieSpawns()) {
            proxy.info("*** Allowing CrackedPigZombie spawns");
            EntityRegistry.addSpawn(EntityCrackedPigZombie.class, (int)pigzombieSpawnProb, (int)minPZSpawn, (int)maxPZSpawn, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
        } else {
            proxy.info("*** Not allowing CrackedPigZombie spawns");
        }
    }

    public Biome[] getSpawnBiomes() {
        LinkedList<Biome> list = new LinkedList<Biome>();
        Set biomes = Biome.field_150597_n;
        for (Biome bgb : biomes) {
            if (bgb.func_185359_l().equalsIgnoreCase("void") || bgb.func_185359_l().equalsIgnoreCase("end") && !spawnInEnd || bgb.func_185359_l().equalsIgnoreCase("nether") && !spawnInNether || list.contains(bgb)) continue;
            list.add(bgb);
            proxy.info("  >>> Including biome " + bgb.func_185359_l() + " for spawning");
        }
        return list.toArray(new Biome[0]);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(modid)) {
            if (event.isRequiresMcRestart()) {
                proxy.info("The configuration changes require a Minecraft restart!");
            }
            proxy.info("Configuration changes have been updated for the Cracked Zombie Mod");
            ConfigHandler.updateConfigInfo();
        }
    }
}

