/*
 * Decompiled with CFR 0.152.
 */
package com.crackedzombie.common;

import com.crackedzombie.common.ConfigHandler;
import com.crackedzombie.common.EntityAICrackedZombieAttack;
import com.crackedzombie.common.EntityCrackedPigZombie;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCrackedZombie
extends EntityMob {
    protected static final IAttribute reinforcementChance = new RangedAttribute(null, "zombie.spawnReinforcements", 0.0, 0.0, 1.0).func_111117_a("Spawn Reinforcements Chance");
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityCrackedZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VILLAGER_TYPE = EntityDataManager.func_187226_a(EntityCrackedZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CONVERTING = EntityDataManager.func_187226_a(EntityCrackedZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityCrackedZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private final double noSpawnRadius = ConfigHandler.getTorchNoSpawnRadius();
    private final boolean allowChildSpawns = ConfigHandler.getAllowChildSpawns();
    private final boolean attackPigs = ConfigHandler.getAttackPigs();
    private final boolean attackVillagers = ConfigHandler.getAttackVillagers();
    private boolean isBreakDoorsTaskSet = ConfigHandler.getDoorBusting();
    private int conversionTime = 0;
    private float zombieWidth = -1.0f;
    private float zombieHeight;

    public EntityCrackedZombie(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICrackedZombieAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityCrackedPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        if (this.attackVillagers) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        }
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        if (this.attackPigs) {
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPig.class, true));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(ConfigHandler.getFollowRange());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ConfigHandler.getMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.getAttackDamage());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(reinforcementChance).func_111128_a(this.field_70146_Z.nextDouble() * 0.1);
    }

    public boolean getHasTarget() {
        float attackDistance = 16.0f;
        return this.isAttackableEntity((EntityLivingBase)this, attackDistance);
    }

    public boolean isAttackableEntity(EntityLivingBase entityLiving, double distance) {
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, 4.0, distance));
        for (Object aList : list) {
            double dist;
            Entity entity = (Entity)aList;
            EntityLivingBase target = (EntityLivingBase)entity;
            if (!this.isGoodTarget(target) || !((dist = target.func_70092_e(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v)) < distance * distance)) continue;
            return true;
        }
        return false;
    }

    public boolean isGoodTarget(EntityLivingBase target) {
        boolean pig;
        if (target == null || target == this || !target.func_70089_S()) {
            this.setArmsRaised(false);
            return false;
        }
        boolean player = target instanceof EntityPlayer;
        boolean villager = this.attackVillagers && target instanceof EntityVillager;
        boolean bl = pig = this.attackPigs && target instanceof EntityPig;
        if (player && ((EntityPlayer)target).field_71075_bZ.field_75098_d) {
            this.setArmsRaised(false);
            return false;
        }
        if ((player || villager || pig) && this.func_70685_l((Entity)target)) {
            this.setArmsRaised(true);
            return true;
        }
        this.setArmsRaised(false);
        return false;
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }

    public boolean isBreakDoorsTaskSet() {
        return this.isBreakDoorsTaskSet;
    }

    public void setBreakDoorsAItask(boolean breakDoorsAItask) {
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(breakDoorsAItask);
        if (breakDoorsAItask) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (entitylivingbase == null && source.func_76346_g() instanceof EntityLivingBase) {
                entitylivingbase = (EntityLivingBase)source.func_76346_g();
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            if (entitylivingbase != null && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && (double)this.field_70146_Z.nextFloat() < this.func_110148_a(reinforcementChance).func_111126_e() && this.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
                EntityCrackedZombie entityzombie = new EntityCrackedZombie(this.field_70170_p);
                for (int l = 0; l < 50; ++l) {
                    int k1;
                    int j1;
                    int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    if (!this.field_70170_p.func_180495_p(new BlockPos(i1, (j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1)) - 1, k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1))).isSideSolid((IBlockAccess)this.field_70170_p, new BlockPos(i1, j1 - 1, k1), EnumFacing.UP) || this.field_70170_p.func_175671_l(new BlockPos(i1, j1, k1)) >= 10) continue;
                    entityzombie.func_70107_b(i1, j1, k1);
                    if (this.field_70170_p.func_175636_b((double)i1, (double)j1, (double)k1, 7.0) || !this.field_70170_p.func_72917_a(entityzombie.func_174813_aQ(), (Entity)entityzombie) || !this.field_70170_p.func_184144_a((Entity)entityzombie, entityzombie.func_174813_aQ()).isEmpty() || this.field_70170_p.func_72953_d(entityzombie.func_174813_aQ())) continue;
                    this.field_70170_p.func_72838_d((Entity)entityzombie);
                    entityzombie.func_70624_b(entitylivingbase);
                    entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), null);
                    this.func_110148_a(reinforcementChance).func_111121_a(new AttributeModifier("Zombie reinforcement caller charge", -0.05, 0));
                    entityzombie.func_110148_a(reinforcementChance).func_111121_a(new AttributeModifier("Zombie reinforcement callee charge", -0.05, 0));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                int strength = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    strength = 7;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    strength = 15;
                }
                if (ConfigHandler.getSickness()) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.func_180142_b((String)"poison"), strength * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_()) {
            float brightness = this.func_70013_c(1.0f);
            BlockPos blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            boolean setFire = false;
            if (brightness > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                ItemStack itemstack;
                if (ConfigHandler.getNightSpawnOnly()) {
                    setFire = true;
                }
                if ((itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD)) != null) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_70669_a(itemstack);
                            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    setFire = false;
                }
                if (setFire) {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    public boolean func_70601_bi() {
        AxisAlignedBB entityAABB = this.func_174813_aQ();
        if (this.noSpawnRadius > 0.0 && this.foundNearbyTorches(entityAABB)) {
            return false;
        }
        if (ConfigHandler.getNightSpawnOnly()) {
            BlockPos blockpos = new BlockPos(this.field_70165_t, entityAABB.field_72338_b, this.field_70161_v);
            if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
                return false;
            }
            int lightFromNeighbors = this.field_70170_p.func_175671_l(blockpos);
            if (this.field_70170_p.func_72911_I()) {
                int skylightSubtracted = this.field_70170_p.func_175657_ab();
                this.field_70170_p.func_175692_b(10);
                lightFromNeighbors = this.field_70170_p.func_175671_l(blockpos);
                this.field_70170_p.func_175692_b(skylightSubtracted);
            }
            return lightFromNeighbors <= this.field_70146_Z.nextInt(8);
        }
        boolean notColliding = this.field_70170_p.func_184144_a((Entity)this, entityAABB).isEmpty();
        boolean isLiquid = this.field_70170_p.func_72953_d(entityAABB);
        BlockPos bp = new BlockPos(this.field_70165_t, entityAABB.field_72338_b - 1.0, this.field_70161_v);
        Block block = this.field_70170_p.func_180495_p(bp).func_177230_c();
        boolean isGrass = block == Blocks.field_150349_c;
        boolean isSand = block == Blocks.field_150354_m;
        boolean isClay = block == Blocks.field_150405_ch || block == Blocks.field_150406_ce;
        boolean isDirt = block == Blocks.field_150346_d;
        boolean isStone = this.field_70146_Z.nextBoolean() && block == Blocks.field_150348_b;
        return (isGrass || isSand || isStone || isClay || isDirt) && notColliding && !isLiquid;
    }

    public boolean foundNearbyTorches(AxisAlignedBB aabb) {
        boolean result = false;
        int xMin = MathHelper.func_76128_c((double)(aabb.field_72340_a - this.noSpawnRadius));
        int xMax = MathHelper.func_76128_c((double)(aabb.field_72336_d + this.noSpawnRadius));
        int yMin = MathHelper.func_76128_c((double)(aabb.field_72338_b - this.noSpawnRadius));
        int yMax = MathHelper.func_76128_c((double)(aabb.field_72337_e + this.noSpawnRadius));
        int zMin = MathHelper.func_76128_c((double)(aabb.field_72339_c - this.noSpawnRadius));
        int zMax = MathHelper.func_76128_c((double)(aabb.field_72334_f + this.noSpawnRadius));
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    Block block = this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                    if (!(block instanceof BlockTorch)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
        this.func_184212_Q().func_187214_a(VILLAGER_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(CONVERTING, (Object)false);
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)false);
    }

    public int func_70658_aO() {
        int armor = super.func_70658_aO() + 2;
        if (armor > 20) {
            armor = 20;
        }
        return armor;
    }

    protected boolean func_70692_ba() {
        return !this.isConverting();
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    public void setChild(boolean childZombie) {
        if (this.allowChildSpawns) {
            this.func_184212_Q().func_187227_b(IS_CHILD, (Object)childZombie);
            if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
                IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                iattributeinstance.func_111124_b(babySpeedBoostModifier);
                if (childZombie) {
                    iattributeinstance.func_111121_a(babySpeedBoostModifier);
                }
            }
            this.setChildSize(childZombie);
        }
    }

    protected final void func_70105_a(float width, float height) {
        boolean isSizeValid = this.zombieWidth > 0.0f && this.zombieHeight > 0.0f;
        this.zombieWidth = width;
        this.zombieHeight = height;
        if (!isSizeValid) {
            this.multiplySize(1.0f);
        }
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.zombieWidth * size, this.zombieHeight * size);
    }

    public boolean isVillager() {
        return (Integer)this.func_184212_Q().func_187225_a(VILLAGER_TYPE) > 0;
    }

    public int getVillagerType() {
        return (Integer)this.func_184212_Q().func_187225_a(VILLAGER_TYPE) - 1;
    }

    public void setVillagerType(int villagerType) {
        this.func_184212_Q().func_187227_b(VILLAGER_TYPE, (Object)(villagerType + 1));
    }

    public void setToNotVillager() {
        this.func_184212_Q().func_187227_b(VILLAGER_TYPE, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.setChildSize(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.isConverting()) {
            int boost = this.getConversionTimeBoost();
            this.conversionTime -= boost;
            if (this.conversionTime <= 0) {
                this.convertToVillager();
            }
        }
        super.func_70071_h_();
    }

    public void func_70077_a(EntityLightningBolt entityLightningBolt) {
        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5f, true, true);
        this.func_70081_e(5);
        this.func_70015_d(8);
    }

    protected SoundEvent func_184639_G() {
        return this.isVillager() ? SoundEvents.field_187940_hn : SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ() {
        return this.isVillager() ? SoundEvents.field_187944_hr : SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return this.isVillager() ? SoundEvents.field_187943_hq : SoundEvents.field_187930_hd;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.isVillager() ? SoundEvents.field_187946_ht : SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        ItemStack heldItem = this.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem != null) {
            return heldItem.func_77973_b();
        }
        return Items.field_151078_bh;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186383_ah;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.func_70631_g_()) {
            tagCompound.func_74757_a("IsBaby", true);
        }
        if (this.isVillager()) {
            tagCompound.func_74757_a("IsVillager", true);
            tagCompound.func_74768_a("VillagerProfession", this.getVillagerType());
        }
        tagCompound.func_74768_a("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        tagCompound.func_74757_a("CanBreakDoors", this.isBreakDoorsTaskSet());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (tagCompund.func_74767_n("IsVillager")) {
            if (tagCompund.func_150297_b("VillagerProfession", 99)) {
                this.setVillagerType(tagCompund.func_74762_e("VillagerProfession"));
            } else {
                this.setVillagerType(this.field_70170_p.field_73012_v.nextInt(5));
            }
        }
        if (tagCompund.func_150297_b("ConversionTime", 99) && tagCompund.func_74762_e("ConversionTime") > -1) {
            this.startConversion(tagCompund.func_74762_e("ConversionTime"));
        }
        this.setBreakDoorsAItask(tagCompund.func_74767_n("CanBreakDoors"));
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            switch (this.field_70146_Z.nextInt(4)) {
                case 0: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u));
                    break;
                }
                case 1: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                    break;
                }
                case 2: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151047_v));
                    break;
                }
                case 3: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151037_a));
                }
            }
        }
    }

    public void func_70074_a(EntityLivingBase entityLiving) {
        super.func_70074_a(entityLiving);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 16) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187942_hp, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isConverting() {
        return (Boolean)this.func_184212_Q().func_187225_a(CONVERTING);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        float additionalDifficulty = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * additionalDifficulty);
        if (livingdata == null) {
            livingdata = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance, this.field_70170_p.field_73012_v.nextFloat() < 0.05f);
        }
        if (livingdata instanceof GroupData) {
            GroupData entityzombie$groupdata = (GroupData)livingdata;
            if (entityzombie$groupdata.isVillager) {
                this.setVillagerType(this.field_70146_Z.nextInt(5));
            }
            if (entityzombie$groupdata.isChild) {
                this.setChild(true);
                if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    List list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntitySelectors.field_152785_b);
                    if (!list.isEmpty()) {
                        EntityChicken entitychicken = (EntityChicken)list.get(0);
                        entitychicken.func_152117_i(true);
                        this.func_184220_m((Entity)entitychicken);
                    }
                } else if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    EntityChicken entitychicken1 = new EntityChicken(this.field_70170_p);
                    entitychicken1.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    entitychicken1.func_180482_a(difficulty, null);
                    entitychicken1.func_152117_i(true);
                    this.field_70170_p.func_72838_d((Entity)entitychicken1);
                    this.func_184220_m((Entity)entitychicken1);
                }
            }
        }
        this.setBreakDoorsAItask(this.isBreakDoorsTaskSet && this.field_70146_Z.nextFloat() < additionalDifficulty * 0.1f);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD) == null) {
            Calendar calendar = Calendar.getInstance();
            Calendar halloween = Calendar.getInstance();
            halloween.clear();
            halloween.set(calendar.get(1), 10, 31);
            if (calendar.compareTo(halloween) == 0 && this.field_70146_Z.nextFloat() < 0.25f) {
                this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
                this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, 0));
        double d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)additionalDifficulty;
        if (d0 > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d0, 2));
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.05f) {
            this.func_110148_a(reinforcementChance).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 0.25 + 0.5, 0));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
            this.setBreakDoorsAItask(this.isBreakDoorsTaskSet);
        }
        return livingdata;
    }

    protected void startConversion(int ticks) {
        this.conversionTime = ticks;
        this.func_184212_Q().func_187227_b(CONVERTING, (Object)true);
        this.func_184589_d(MobEffects.field_76437_t);
        this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, ticks, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.field_70170_p.func_72960_a((Entity)this, (byte)16);
    }

    protected void convertToVillager() {
        EntityVillager entityvillager = new EntityVillager(this.field_70170_p);
        entityvillager.func_82149_j((Entity)this);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        entityvillager.func_82187_q();
        if (this.func_70631_g_()) {
            entityvillager.func_70873_a(-24000);
        }
        this.field_70170_p.func_72900_e((Entity)this);
        entityvillager.func_94061_f(this.func_175446_cd());
        entityvillager.func_70938_b(this.getVillagerType());
        if (this.func_145818_k_()) {
            entityvillager.func_96094_a(this.func_95999_t());
            entityvillager.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_72838_d((Entity)entityvillager);
        entityvillager.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
        this.field_70170_p.func_180498_a(null, 1027, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
    }

    protected int getConversionTimeBoost() {
        int boostTime = 1;
        if (this.field_70146_Z.nextFloat() < 0.01f) {
            int count = 0;
            for (double x = this.field_70165_t - 4.0; x < this.field_70165_t + 4.0 && count < 14; x += 1.0) {
                for (double y = this.field_70163_u - 4.0; y < this.field_70163_u + 4.0 && count < 14; y += 1.0) {
                    for (double z = this.field_70161_v - 4.0; z < this.field_70161_v + 4.0 && count < 14; z += 1.0) {
                        Block block = this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        if (block != Blocks.field_150411_aY && block != Blocks.field_150324_C) continue;
                        if (this.field_70146_Z.nextFloat() < 0.3f) {
                            ++boostTime;
                        }
                        ++count;
                    }
                }
            }
        }
        return boostTime;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isChild = false;
        public boolean isVillager = false;

        private GroupData(boolean setChild, boolean setVillager) {
            this.isChild = setChild;
            this.isVillager = setVillager;
        }

        GroupData(boolean setChild, boolean setVillager, Object object) {
            this(setChild, setVillager);
        }
    }
}

