package mods.immibis.core.commands;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;

public class TPSCommand extends CommandBase {
	
	static {
		TickRegistry.registerTickHandler(new TickHandler(), Side.SERVER);
	}
	
	{
		TickHandler.reset();
	}
	
	private static class TickHandler implements ITickHandler {
		
		private static List<Integer> tickTime = new LinkedList<Integer>();
		private static long lastTickTime = System.nanoTime();
		
		static void reset() {
			tickTime.clear();
			lastTickTime = System.nanoTime();
		}
		
		@Override
		public String getLabel() {
			return "Immibis Core TPS calculator";
		}
		
		@Override
		public EnumSet<TickType> ticks() {
			return EnumSet.of(TickType.SERVER);
		}
		
		@Override
		public void tickEnd(EnumSet<TickType> type, Object... tickData) {
		}
		
		@Override
		public void tickStart(EnumSet<TickType> type, Object... tickData) {
			long thisTime = System.nanoTime();
			long tickTimeNS = thisTime - lastTickTime;
			lastTickTime = thisTime;
			
			int tickTimeMS = (int)((tickTimeNS + 500000) / 1000000);
			if(tickTime.size() == 100)
				tickTime.remove(99);
			tickTime.add(0, tickTimeMS);
		}

		public static double getTPS1() {
			return 1000.0 / getTickTime();
		}
		public static int getTickTime() {
			return tickTime.get(0);
		}
		public static double getTPS(int nTicks) {
			return 1000.0 / getTickTime(nTicks);
		}
		
		private static double getTickTime(int avgTicks) {
			if(avgTicks > tickTime.size())
				return getTickTime(tickTime.size());
			
			int total = 0;
			Iterator<Integer> it = tickTime.iterator();
			for(int k = 0; k < avgTicks; k++)
				total += it.next();
			
			return total / (double)avgTicks;
		}
	}

	@Override
	public String getCommandName() {
		return "tps";
	}

	@Override
	public void processCommand(ICommandSender ply, String[] astring) {
		for(int nTicks : new int[] {200, 20, 5}) {
			// Average TPS over last X ticks: Y
			ply.sendChatToPlayer(
				new ChatMessageComponent()
				.setColor(EnumChatFormatting.YELLOW)
				.addFormatted("mods.immibis.core.tps.avg", nTicks,
					new ChatMessageComponent()
					.setColor(EnumChatFormatting.AQUA)
					.addFormatted("mods.immibis.core.tps.tps", TickHandler.getTPS(nTicks))
				)
			);
		}
		
		// Time between last two ticks: X (Y TPS)
		ply.sendChatToPlayer(
			new ChatMessageComponent()
			.setColor(EnumChatFormatting.YELLOW)
			.addFormatted("mods.immibis.core.tps.lastTime",
				new ChatMessageComponent().setColor(EnumChatFormatting.AQUA).addFormatted("mods.immibis.core.tps.time", TickHandler.getTickTime()),
				new ChatMessageComponent().setColor(EnumChatFormatting.AQUA).addFormatted("mods.immibis.core.tps.tps", TickHandler.getTPS1())
			)
		);
	}

	@Override
	public boolean canCommandSenderUseCommand(ICommandSender par1iCommandSender) {
		return true;
	}

	@Override
	public String getCommandUsage(ICommandSender icommandsender) {
		return "/tps";
	}

}
