package mods.immibis.microblocks;

import mods.immibis.core.api.FMLModInfo;
import mods.immibis.core.api.util.ErrorScreen;
import mods.immibis.microblocks.coremod.MicroblocksCoreMod;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.event.FMLInitializationEvent;

// metadata required for AutoPublisher
@Mod(version=ModProperties.MOD_VERSION, modid="ImmibisMicroblocksInstallCheck", name="Immibis's Microblocks (Check for incorrect installation)")
@FMLModInfo(
		modid=ModProperties.MODID,
		name=ModProperties.MOD_NAME,
		url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
		description="",
		authors="immibis"
		)
public class MicroblocksNonCoreMod {
	
	@Init
	public void init(FMLInitializationEvent evt) {
		if(!MicroblocksCoreMod.TEST_DISABLED && !Loader.isModLoaded("ImmibisMicroblocks"))
			ErrorScreen.displayFatalError(
				"Immibis's Microblocks must be installed in the coremods folder.",
				"Please correct the problem and restart Minecraft.");
	}
}
