package mods.immibis.microblocks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import mods.immibis.core.api.net.IPacket;

public class PacketDummyTEDestroy implements IPacket {
	public int x, y, z;
	
	@Override
	public String getChannel() {
		return MicroblockSystem.CHANNEL;
	}
	
	@Override
	public byte getID() {
		return MicroblockSystem.PKT_S2C_DUMMY_TE_DESTROY;
	}
	
	@SideOnly(Side.CLIENT)
	@Override
	public void onReceived(EntityPlayer source) {
		if(source == null) {
			Minecraft.getMinecraft().theWorld.setBlockTileEntity(x, y, z, null);
		}
	}
	
	@Override
	public void read(DataInputStream in) throws IOException {
		x = in.readInt();
		y = in.readInt();
		z = in.readInt();
	}
	
	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeInt(x);
		out.writeInt(y);
		out.writeInt(z);
	}
}
