package mods.immibis.redlogic.wires;

import net.minecraft.util.Icon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public enum EnumWires {
	RED_ALLOY("Red alloy wire", "wire-red-alloy", 2, 2, PlainRedAlloyTile.class, 0x800000);
	
	public final String name;
	public final String textureName;
	public final double thickness, width;
	public final Class<? extends WireTile> teclass;
	public final int itemColour;
	
	@SideOnly(Side.CLIENT)
	public Icon texture;
	
	private EnumWires(String name, String texName, int thicknessPixels, int widthPixels, Class<? extends WireTile> teclass, int itemColour) {
		this.name = name;
		this.textureName = "immibis/redlogic:" + texName;
		this.thickness = thicknessPixels / 16.0;
		this.width = widthPixels / 16.0;
		this.teclass = teclass;
		this.itemColour = itemColour;
	}
	
	public static final EnumWires[] VALUES = values();
}
