package mods.immibis.redlogic.gates;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public enum EnumGates {
	AND(GateLogic.AND.class, GateRendering.AND.class),
	OR(GateLogic.OR.class, GateRendering.OR.class),
	NOT(GateLogic.NOT.class, GateRendering.NOT.class),
	RSLATCH(GateLogic.RSLatch.class, GateRendering.RSLatch.class),
	TOGGLE(GateLogic.ToggleLatch.class, GateRendering.ToggleLatch.class),
	NOR(GateLogic.NOR.class, GateRendering.NOR.class),
	NAND(GateLogic.NAND.class, GateRendering.NAND.class),
	XOR(GateLogic.XOR.class, GateRendering.XOR.class),
	XNOR(GateLogic.XNOR.class, GateRendering.XNOR.class),
	Buffer(GateLogic.Buffer.class, GateRendering.Buffer.class),
	Multiplexer(GateLogic.Multiplexer.class, GateRendering.Multiplexer.class),
	Repeater(GateLogic.Repeater.class, GateRendering.Repeater.class),
	Timer(GateLogic.Timer.class, GateRendering.Timer.class),
	Counter(GateLogic.Counter.class, GateRendering.Counter.class),
	Sequencer(GateLogic.Sequencer.class, GateRendering.Sequencer.class),
	PulseFormer(GateLogic.PulseFormer.class, GateRendering.PulseFormer.class),
	Randomizer(GateLogic.Randomizer.class, GateRendering.Randomizer.class),
	StateCell(GateLogic.StateCell.class, GateRendering.StateCell.class),
	Synchronizer(GateLogic.Synchronizer.class, GateRendering.Synchronizer.class),
	DLatch(GateLogic.DLatch.class, GateRendering.DLatch.class),
	DFlop(GateLogic.DFlop.class, GateRendering.DFlop.class),
	BundledLatch(GateLogic.BundledLatch.class, GateRendering.BundledLatch.class),
	BundledRelay(GateLogic.BundledRelay.class, GateRendering.BundledRelay.class),
	BundledMultiplexer(GateLogic.BundledMultiplexer.class, GateRendering.BundledMultiplexer.class),
	;
	
	private Class<? extends GateLogic> logicClass;
	private Class<? extends GateRendering> renderClass;
	private GateLogic logicInst;
	private GateRendering renderInst;
	
	private EnumGates(Class<? extends GateLogic> logicClass, Class<? extends GateRendering> renderClass) {
		this.logicClass = logicClass;
		this.renderClass = renderClass;
		
		if(GateLogic.Stateless.class.isAssignableFrom(logicClass))
			logicInst = createLogic();
	}
	
	public GateLogic createLogic() {
		if(logicInst != null)
			return logicInst;
		try {
			return logicClass.getConstructor().newInstance();
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	@SideOnly(Side.CLIENT)
	public GateRendering getRendering() {
		if(renderInst != null)
			return renderInst;
		try {
			renderInst = renderClass.getConstructor().newInstance(); 
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
		return renderInst;
	}

	public Class<? extends GateLogic> getLogicClass() {
		return logicClass;
	}
	
	public static final EnumGates[] VALUES = values();
}
