package mods.immibis.redlogic;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import mods.immibis.core.ItemCombined;
import mods.immibis.redlogic.chips.ingame.TileChipScanner;

public class RLMachineBlockItem extends ItemCombined {
	public RLMachineBlockItem(int id_m256) {
		super(id_m256, "redlogic", new String[] {
			"chipscanner",
			"chipiomarker",
			"chipcompiler",
			"chipfabricator",
		});
	}
	
	@Override
	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
		if(!super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata))
			return false;
		
		if(metadata == RLMachineBlock.META_CHIP_SCANNER) {
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te instanceof TileChipScanner)
				((TileChipScanner)te).setInitialRotation(player);
		}
		
		return true;
	}
}
