package mods.immibis.redlogic.recipes;

import mods.immibis.core.api.util.Colour;
import mods.immibis.redlogic.RLMachineBlock;
import mods.immibis.redlogic.RLNormalBlock;
import mods.immibis.redlogic.api.misc.ILampBlock.LampType;
import mods.immibis.redlogic.array.ArrayCellType;
import mods.immibis.redlogic.gates.EnumGates;
import mods.immibis.redlogic.interaction.LumarButtonModel;
import mods.immibis.redlogic.interaction.LumarButtonType;
import mods.immibis.redlogic.interaction.RecipeDyeLumarButton;
import mods.immibis.redlogic.interaction.TileLumarButton;
import mods.immibis.redlogic.lamps.BlockLampNonCube;
import mods.immibis.redlogic.lamps.BlockLampNonCubeItem;
import mods.immibis.redlogic.wires.EnumWireType;
import mods.immibis.redlogic.wires.WireDamageValues;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import cpw.mods.fml.common.registry.GameRegistry;
import static mods.immibis.redlogic.RedLogicMod.*;

public class RecipesOriginal {

	public static void addRecipes() {
		GameRegistry.addRecipe(new ItemStack(screwdriver),
			" YI",
			" IB",
			"/  ",
			'Y', new ItemStack(Item.dyePowder, 1, Colour.YELLOW.dyeId()),
			'B', new ItemStack(Item.dyePowder, 1, Colour.BLACK.dyeId()),
			'/', Item.stick,
			'I', Item.ingotIron
			);
		
		GameRegistry.addRecipe(new ItemStack(wire, 16, EnumWireType.RED_ALLOY.ordinal()),
			"R R",
			"RIR",
			"R R",
			'R', Item.redstone,
			'I', Item.ingotIron
			);
		
		for(int k = 0; k < 16; k++) {
			GameRegistry.addRecipe(new ItemStack(wire, 8, EnumWireType.INSULATED_WIRE[k].ordinal()),
				"WWW",
				"WDW",
				"WWW",
				'W', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal()),
				'D', new ItemStack(Item.dyePowder, 1, 15 - k));
			
			GameRegistry.addRecipe(new ItemStack(wire, 8, EnumWireType.INSULATED_WIRE[k].ordinal()),
				"WWW",
				"WDW",
				"WWW",
				'W', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal()),
				'D', new ItemStack(Block.cloth, 1, k));
		}
		
		GameRegistry.addRecipe(new ItemStack(wire, 2, EnumWireType.BUNDLED.ordinal()),
			"WWW",
			"WSW",
			"WWW",
			'W', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal()),
			'S', Item.silk
		);
		
		for(EnumWireType type : EnumWireType.VALUES) {
			if(!type.hasJacketedForm())
				continue;
			
			ItemStack plain = new ItemStack(wire, 1, type.ordinal());
			ItemStack free = new ItemStack(wire, 1, type.ordinal() | WireDamageValues.DMG_FLAG_JACKETED);
			
			GameRegistry.addRecipe(plain, "X", 'X', free);
			GameRegistry.addRecipe(free, "X", 'X', plain);
		}
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.AND.ordinal()),
			" T ",
			"TTT",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.OR.ordinal()),
			" T ",
			"RTR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.NOT.ordinal()),
			" R ",
			"RTR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
			"STR",
			"R R",
			"RTS",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.cobblestone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.TOGGLE.ordinal()),
			" T ",
			"RLR",
			" T ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'L', Block.lever);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.NOR.ordinal()),
			" T ",
			"RRR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.NAND.ordinal()),
			" R ",
			"TTT",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.XOR.ordinal()),
			"RRR",
			"TRT",
			"RTR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.XNOR.ordinal()),
			"RTR",
			"TRT",
			"RTR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Buffer.ordinal()),
			"RTR",
			"RTR",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Multiplexer.ordinal()),
			"RTR",
			"T T",
			"RTR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Repeater.ordinal()),
			"RRR",
			"R_R",
			"RRR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'_', Item.redstoneRepeater);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Timer.ordinal()),
			" T ",
			"RIR",
			"   ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Counter.ordinal()),
			"T  ",
			"IRR",
			"T  ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Sequencer.ordinal()),
			" T ",
			"TIT",
			" T ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.PulseFormer.ordinal()),
			"RTR",
			"TRT",
			"RR ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Randomizer.ordinal()),
			" T ",
			"TGT",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'G', Item.glowstone);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.StateCell.ordinal()),
			" RT",
			"RXI",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
			'I', Item.ingotIron);
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Synchronizer.ordinal()),
			"RTR",
			"XRX",
			"R R",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.DLatch.ordinal()),
			"XTR",
			"TRR",
			"RRR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.DFlop.ordinal()),
			"XTR",
			"TRY",
			"RRR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'X', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
			'Y', new ItemStack(gates, 1, EnumGates.PulseFormer.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledLatch.ordinal()),
			" B ",
			" DR",
			" B ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'D', new ItemStack(gates, 1, EnumGates.DLatch.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledRelay.ordinal()),
			" B ",
			" AR",
			" B ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'A', new ItemStack(gates, 1, EnumGates.AND.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledMultiplexer.ordinal()),
			" B ",
			"BMB",
			" R ",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'M', new ItemStack(gates, 1, EnumGates.Multiplexer.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledAND.ordinal()),
			"RBR",
			"BMB",
			"RBR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'M', new ItemStack(gates, 1, EnumGates.AND.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledOR.ordinal()),
			"RBR",
			"BMB",
			"RBR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'M', new ItemStack(gates, 1, EnumGates.OR.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledNOT.ordinal()),
			"RBR",
			"BMB",
			"RBR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'M', new ItemStack(gates, 1, EnumGates.NOT.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.BundledXOR.ordinal()),
			"RBR",
			"BMB",
			"RBR",
			'R', Item.redstone,
			'T', Block.torchRedstoneActive,
			'S', Block.stone,
			'M', new ItemStack(gates, 1, EnumGates.XOR.ordinal()),
			'B', new ItemStack(wire, 1, EnumWireType.BUNDLED.ordinal()));
		
		GameRegistry.addRecipe(new ItemStack(gates, 1, EnumGates.Comparator.ordinal()),
			" R ",
			"RCR",
			'R', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal()),
			'C', Item.comparator);
		
		for(int k = 0; k < 16; k++) {
			GameRegistry.addRecipe(new ItemStack(lampCubeIndicatorOff, 1, k),
				"GrG",
				"GrG",
				"GdG",
				'G', Block.glass,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone);
			GameRegistry.addRecipe(new ItemStack(lampCubeOff, 1, k),
				"GrG",
				"GgG",
				"GdG",
				'G', Block.glass,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone,
				'g', Block.glowStone);
			GameRegistry.addRecipe(new ItemStack(lampCubeDecorative, 1, k),
				"G G",
				"GgG",
				"GdG",
				'G', Block.glass,
				'g', Block.glowStone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone);
			
			GameRegistry.addRecipe(BlockLampNonCubeItem.getItemStack(BlockLampNonCube.MODEL_FLAT, LampType.Decorative, k),
				"GGG",
				" g ",
				" d ",
				'G', Block.glass,
				'g', Block.glowStone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone);
			
			GameRegistry.addRecipe(BlockLampNonCubeItem.getItemStack(BlockLampNonCube.MODEL_FLAT, LampType.Indicator, k),
				"GGG",
				"rdr",
				'G', Block.glass,
				'g', Block.glowStone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone);
			
			GameRegistry.addRecipe(BlockLampNonCubeItem.getItemStack(BlockLampNonCube.MODEL_FLAT, LampType.Normal, k),
				"GGG",
				"dgr",
				'G', Block.glass,
				'g', Block.glowStone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone);
			
			GameRegistry.addRecipe(BlockLampNonCubeItem.getItemStack(BlockLampNonCube.MODEL_CAGE, LampType.Decorative, k),
				"###",
				"#d#",
				" g ",
				'G', Block.glass,
				'g', Block.glowStone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone,
				'#', Block.fenceIron);
			
			GameRegistry.addRecipe(BlockLampNonCubeItem.getItemStack(BlockLampNonCube.MODEL_CAGE, LampType.Indicator, k),
				"###",
				"#d#",
				"r r",
				'G', Block.glass,
				'g', Block.glowStone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone,
				'#', Block.fenceIron);
			
			GameRegistry.addRecipe(BlockLampNonCubeItem.getItemStack(BlockLampNonCube.MODEL_CAGE, LampType.Normal, k),
				"###",
				"#d#",
				"g r",
				'G', Block.glass,
				'g', Block.glowStone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k),
				'r', Item.redstone,
				'#', Block.fenceIron);
		}
		
		for(int k = 0; k < 16; k++) {
			GameRegistry.addRecipe(TileLumarButton.getItemStack(k, LumarButtonType.Normal, LumarButtonModel.Button),
				" d ",
				"rbg",
				'b', Block.stoneButton,
				'g', Item.glowstone,
				'r', Item.redstone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k));
			
			GameRegistry.addRecipe(TileLumarButton.getItemStack(k, LumarButtonType.Latch, LumarButtonModel.Button),
				" d ",
				"rbg",
				'b', Block.stoneButton,
				'g', Item.glowstone,
				'r', Block.torchRedstoneActive,
				'd', new ItemStack(Item.dyePowder, 1, 15-k));
			
			GameRegistry.addRecipe(TileLumarButton.getItemStack(k, LumarButtonType.SelfLatch, LumarButtonModel.Button),
				" d ",
				"rbg",
				'b', Block.stoneButton,
				'g', Item.glowstone,
				'r', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
				'd', new ItemStack(Item.dyePowder, 1, 15-k));
			
			GameRegistry.addRecipe(TileLumarButton.getItemStack(k, LumarButtonType.Normal, LumarButtonModel.Plate),
				" d ",
				"rbg",
				'b', Block.pressurePlateStone,
				'g', Item.glowstone,
				'r', Item.redstone,
				'd', new ItemStack(Item.dyePowder, 1, 15-k));
			
			GameRegistry.addRecipe(TileLumarButton.getItemStack(k, LumarButtonType.Latch, LumarButtonModel.Plate),
				" d ",
				"rbg",
				'b', Block.pressurePlateStone,
				'g', Item.glowstone,
				'r', Block.torchRedstoneActive,
				'd', new ItemStack(Item.dyePowder, 1, 15-k));
			
			GameRegistry.addRecipe(TileLumarButton.getItemStack(k, LumarButtonType.SelfLatch, LumarButtonModel.Plate),
				" d ",
				"rbg",
				'b', Block.pressurePlateStone,
				'g', Item.glowstone,
				'r', new ItemStack(gates, 1, EnumGates.RSLATCH.ordinal()),
				'd', new ItemStack(Item.dyePowder, 1, 15-k));
		}
		
		GameRegistry.addRecipe(new RecipeDyeLumarButton());
		
		GameRegistry.addRecipe(new ItemStack(plainBlock, 16, RLNormalBlock.META_CLEANWALL),
			"SBS",
			"ISI",
			"SBS",
			'S', Block.sand,
			'I', Item.ingotIron,
			'B', Block.brick);
		
		GameRegistry.addRecipe(new ItemStack(plainBlock, 1, RLNormalBlock.META_CLEANFILTER),
			"BBB",
			"BWB",
			"BBB",
			'B', Block.fenceIron,
			'W', new ItemStack(plainBlock, 1, RLNormalBlock.META_CLEANWALL));
		
		GameRegistry.addRecipe(new ItemStack(machineBlock, 1, RLMachineBlock.META_CHIP_SCANNER),
			"RRR",
			"RWR",
			"RDR",
			'R', Item.redstone,
			'D', Item.diamond,
			'W', new ItemStack(plainBlock, 1, RLNormalBlock.META_CLEANWALL));
		
		GameRegistry.addRecipe(new ItemStack(machineBlock, 1, RLMachineBlock.META_IO_MARKER),
			"OOO",
			"OGO",
			"ORO",
			'R', Item.redstone,
			'O', Block.obsidian,
			'G', Block.blockGold);
		
		GameRegistry.addRecipe(new ItemStack(machineBlock, 1, RLMachineBlock.META_CHIP_COMPILER),
			"ORR",
			"ODR",
			"OYR",
			'D', Block.blockDiamond,
			'O', Block.obsidian,
			'R', Item.redstone,
			'Y', new ItemStack(Item.dyePowder, 1, Colour.YELLOW.dyeId())
			);
		
		GameRegistry.addRecipe(new ItemStack(machineBlock, 1, RLMachineBlock.META_CHIP_FABRICATOR),
			"ORR",
			"OIR",
			"OWR",
			'I', Block.blockIron,
			'O', Block.obsidian,
			'R', Item.redstone,
			'W', new ItemStack(Item.dyePowder, 1, Colour.WHITE.dyeId())
			);
		
		GameRegistry.addRecipe(new ItemStack(arrayCells, 1, ArrayCellType.NULL.ordinal()),
			"SXS",
			"XXX",
			"SXS",
			'S', Block.stone,
			'X', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal())
			);
		
		GameRegistry.addRecipe(new ItemStack(arrayCells, 1, ArrayCellType.INVERT.ordinal()),
			"SXS",
			"XiX",
			"SXS",
			'S', Block.stone,
			'X', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal()),
			'i', Block.torchRedstoneActive
			);
		
		GameRegistry.addRecipe(new ItemStack(arrayCells, 1, ArrayCellType.NON_INVERT.ordinal()),
			"SXS",
			"XrX",
			"SXS",
			'S', Block.stone,
			'X', new ItemStack(wire, 1, EnumWireType.RED_ALLOY.ordinal()),
			'r', Block.redstoneRepeaterActive
			);
	}

}
