package mods.immibis.redlogic.chips.ingame;

import java.util.List;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.immibis.redlogic.RedLogicMod;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemChip extends Item {

	public ItemChip(int idm256) {
		super(idm256);
		
		setMaxStackSize(64);
		setUnlocalizedName("redlogic.old-circuit");
		setTextureName("redlogic:chip");
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	@SideOnly(Side.CLIENT)
	public void addInformation(ItemStack stack, EntityPlayer ply, List lines, boolean showIDs) {
		super.addInformation(stack, ply, lines, showIDs);
		
		lines.add(I18n.getString("item.redlogic.old-circuit.line1"));
		lines.add(I18n.getString("item.redlogic.old-circuit.line2"));
	}
	
	@Override
	public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
		par1ItemStack.itemID = RedLogicMod.customCircuitBlock.blockID;
		return par1ItemStack;
	}
	
	@Override
	public boolean onItemUse(ItemStack stack, EntityPlayer ply, World w, int x, int y, int z, int side, float subX, float subY, float subZ) {
		stack.itemID = RedLogicMod.customCircuitBlock.blockID;
		return true;
	}

}
