/*
 * Decompiled with CFR 0.152.
 */
package parachute.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import parachute.common.CommonProxyParachute;
import parachute.common.EntityParachute;
import parachute.common.ItemParachute;
import parachute.common.ParachutePacketHandler;

@Mod(modid="ParachuteMod", name="Parachute Mod", version="1.6.2")
@NetworkMod(versionBounds="[1.6.2]", clientSideRequired=true, serverSideRequired=false, packetHandler=ParachutePacketHandler.class, connectionHandler=ParachutePacketHandler.class, channels={"ParachuteMod"})
public class Parachute {
    public static final String ID = "ParachuteMod";
    public static final String VER = "1.6.2";
    public static final String CHANNEL = "ParachuteMod";
    public static final String name = "Parachute Mod";
    public static final String entityName = "Parachute";
    private int heightLimit;
    private int chuteColor;
    private boolean thermals;
    private boolean autoDeploy;
    private int fallDistance;
    private boolean useTexturePack;
    private static int itemID;
    private int entityID = EntityRegistry.findGlobalUniqueEntityId();
    @SidedProxy(clientSide="parachute.client.ClientProxyParachute", serverSide="parachute.common.CommonProxyParachute")
    public static CommonProxyParachute proxy;
    public static Item parachuteItem;
    @Mod.Instance
    public static Parachute instance;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        String generalComments = "Parachute Mod Config\nMichael Sheppard (crackedEgg)";
        String itemComment = "itemID - customize the ItemID (2500)";
        String heightComment = "heightLimit  - 0 (zero) disables altitude limiting (225)";
        String thermalComment = "allowThermals - true|false enable/disable thermals (true)";
        String deployComment = "autoDeploy - true|false enable/disable auto parachute deployment (false)";
        String fallComment = "fallDistance - maximum falling distance before auto deploy (2 - 20) (5)";
        String colorComment = "Color index numbers:\nblack        -  0\nblue         -  1\nbrown        -  2\ncyan         -  3\ngray         -  4\ngreen        -  5\nlight blue   -  6\nlime         -  7\nmagneta      -  8\norange       -  9\npink         - 10\npurple       - 11\nred          - 12\nsilver       - 13\nwhite        - 14\nyellow       - 15\nblue/white   - 16\nred/white    - 17\nyellow/green - 18";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.heightLimit = config.get("general", "heightLimit", 225, heightComment).getInt();
        this.chuteColor = config.get("general", "chuteColor", 18, colorComment).getInt();
        this.thermals = config.get("general", "allowThermals", true, thermalComment).getBoolean(true);
        this.autoDeploy = config.get("general", "autoDeploy", false, deployComment).getBoolean(false);
        this.fallDistance = config.get("general", "fallDistance", 5, fallComment).getInt();
        itemID = config.get("general", "itemID", 2500, itemComment).getInt();
        this.fallDistance = this.fallDistance < 2 ? 2 : (this.fallDistance > 20 ? 20 : this.fallDistance);
        config.addCustomCategoryComment("general", generalComments);
        config.save();
        proxy.registerRenderer();
        proxy.registerKeyHandler();
        if (this.autoDeploy) {
            proxy.registerServerTickHandler();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        EntityRegistry.registerModEntity(EntityParachute.class, (String)entityName, (int)this.entityID, (Object)this, (int)64, (int)10, (boolean)true);
        parachuteItem = new ItemParachute(itemID, EnumToolMaterial.WOOD).func_77655_b(entityName);
        parachuteItem.func_111206_d("parachute");
        GameRegistry.addRecipe((ItemStack)new ItemStack(parachuteItem, 1), (Object[])new Object[]{"###", "X X", " L ", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('L'), Item.field_77770_aF});
        LanguageRegistry.addName((Object)parachuteItem, (String)entityName);
        NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)new ParachutePacketHandler());
        instance = this;
    }

    public String getVersion() {
        return VER;
    }

    public double getMaxAltitude() {
        return this.heightLimit;
    }

    public boolean getAllowThermals() {
        return this.thermals;
    }

    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    public int getChuteColor() {
        return this.chuteColor;
    }

    public int getFallDistance() {
        return this.fallDistance;
    }

    public static int getItemID() {
        return itemID;
    }
}

