/*
 * Decompiled with CFR 0.152.
 */
package parachute.client;

import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;

public class ParachuteTexturedQuad {
    private final float texSize = 16.0f;
    public PositionTextureVertex[] vertexPositions;
    public int nVertices = 0;
    private boolean invertNormal = false;

    public ParachuteTexturedQuad(PositionTextureVertex[] texCoords) {
        this.vertexPositions = texCoords;
        this.nVertices = texCoords.length;
    }

    public ParachuteTexturedQuad(PositionTextureVertex[] texCoords, int i, int j, int k, int l) {
        this(texCoords);
        texCoords[0] = texCoords[0].func_78240_a((float)k / 16.0f, (float)j / 16.0f);
        texCoords[1] = texCoords[1].func_78240_a((float)i / 16.0f, (float)j / 16.0f);
        texCoords[2] = texCoords[2].func_78240_a((float)i / 16.0f, (float)l / 16.0f);
        texCoords[3] = texCoords[3].func_78240_a((float)k / 16.0f, (float)l / 16.0f);
    }

    public void flipFace() {
        PositionTextureVertex[] texCoords = new PositionTextureVertex[this.vertexPositions.length];
        for (int i = 0; i < this.vertexPositions.length; ++i) {
            texCoords[i] = this.vertexPositions[this.vertexPositions.length - i - 1];
        }
        this.vertexPositions = texCoords;
    }

    public void draw(Tessellator tessellator, float f) {
        Vec3 vec3d = this.vertexPositions[1].field_78243_a.func_72444_a(this.vertexPositions[0].field_78243_a);
        Vec3 vec3d1 = this.vertexPositions[1].field_78243_a.func_72444_a(this.vertexPositions[2].field_78243_a);
        Vec3 vec3d2 = vec3d1.func_72431_c(vec3d).func_72432_b();
        tessellator.func_78382_b();
        if (this.invertNormal) {
            tessellator.func_78375_b(-((float)vec3d2.field_72450_a), -((float)vec3d2.field_72448_b), -((float)vec3d2.field_72449_c));
        } else {
            tessellator.func_78375_b((float)vec3d2.field_72450_a, (float)vec3d2.field_72448_b, (float)vec3d2.field_72449_c);
        }
        for (int i = 0; i < 4; ++i) {
            PositionTextureVertex positiontexturevertex = this.vertexPositions[i];
            tessellator.func_78374_a((double)((float)positiontexturevertex.field_78243_a.field_72450_a * f), (double)((float)positiontexturevertex.field_78243_a.field_72448_b * f), (double)((float)positiontexturevertex.field_78243_a.field_72449_c * f), (double)positiontexturevertex.field_78241_b, (double)positiontexturevertex.field_78242_c);
        }
        tessellator.func_78381_a();
    }
}

