/*
 * Decompiled with CFR 0.152.
 */
package parachute.common;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.NetLoginHandler;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet1Login;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import parachute.client.RenderParachute;
import parachute.common.PlayerInfo;
import parachute.common.PlayerManagerParachute;

public class ParachutePacketHandler
implements IPacketHandler,
IConnectionHandler {
    public static final byte KeyPress = 0;
    private static final int KEY_DESCEND = 45;
    private static final int KEY_ASCEND = 46;
    private static final int KEY_COLOR = 52;

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player p) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        byte keyCode = 0;
        try {
            byte type = dis.readByte();
            EntityPlayer player = (EntityPlayer)p;
            if (player == null) {
                return;
            }
            if (type == 0) {
                PlayerInfo pi = PlayerManagerParachute.getInstance().getPlayerInfoFromPlayer(player);
                if (pi == null) {
                    return;
                }
                keyCode = dis.readByte();
                boolean pressed = dis.readBoolean();
                if (keyCode == 46) {
                    if (pressed) {
                        pi.setLiftMode(1);
                    } else {
                        pi.setLiftMode(0);
                    }
                }
                if (keyCode == 45) {
                    if (pressed) {
                        pi.setLiftMode(2);
                    } else {
                        pi.setLiftMode(0);
                    }
                }
                if (keyCode == 52 && pressed) {
                    int idx = pi.changeColor();
                    RenderParachute.setParachuteColor(idx);
                }
            }
        }
        catch (IOException e) {
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendKeyPress(int keyCode, boolean pressed) {
        Minecraft client = FMLClientHandler.instance().getClient();
        WorldClient world = client.field_71441_e;
        if (world == null || !world.field_72995_K) {
            return;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            dos.write(0);
            dos.writeByte(keyCode);
            dos.writeBoolean(pressed);
            dos.close();
            packet.field_73630_a = "ParachuteMod";
            packet.field_73629_c = bos.toByteArray();
            packet.field_73628_b = bos.size();
            packet.field_73287_r = false;
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void playerLoggedIn(Player p, NetHandler netHandler, INetworkManager manager) {
        PlayerManagerParachute.getInstance().Players.add(new PlayerInfo(((EntityPlayer)p).field_71092_bJ, manager));
    }

    public String connectionReceived(NetLoginHandler netHandler, INetworkManager manager) {
        return null;
    }

    public void connectionOpened(NetHandler netClientHandler, String server, int port, INetworkManager manager) {
    }

    public void connectionOpened(NetHandler netClientHandler, MinecraftServer server, INetworkManager manager) {
    }

    public void connectionClosed(INetworkManager manager) {
        PlayerInfo PI = new PlayerInfo("", manager);
        for (int i = 0; i < PlayerManagerParachute.getInstance().Players.size() && PI != null; ++i) {
            if (PlayerManagerParachute.getInstance().Players.get((int)i).networkManager != manager) continue;
            PlayerManagerParachute.getInstance().Players.remove(i);
        }
    }

    public void clientLoggedIn(NetHandler clientHandler, INetworkManager manager, Packet1Login login) {
        PlayerManagerParachute.getInstance().Players.add(new PlayerInfo(clientHandler.getPlayer().field_71092_bJ, manager));
    }
}

