/*
 * Decompiled with CFR 0.152.
 */
package parachute.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;
import parachute.client.ParachuteTexturedQuad;

public class ParachuteModelRenderer {
    private PositionTextureVertex[] corners;
    private ParachuteTexturedQuad[] faces;
    private int left;
    private int top;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled = false;
    private int displayList = 0;
    public boolean mirror = false;
    public boolean showModel = true;
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    public List cubeList = new ArrayList();

    public ParachuteModelRenderer(int x, int y) {
        this.setTextureSize(this.textureWidth, this.textureHeight);
    }

    public void addBox(float x, float y, float z, int i, int j, int k) {
        this.corners = new PositionTextureVertex[8];
        this.faces = new ParachuteTexturedQuad[6];
        float width = x + (float)i;
        float height = y + (float)j;
        float depth = z + (float)k;
        if (this.mirror) {
            float tmp = width;
            width = x;
            x = tmp;
        }
        this.corners[0] = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
        this.corners[1] = new PositionTextureVertex(width, y, z, 0.0f, 8.0f);
        this.corners[2] = new PositionTextureVertex(width, height, z, 8.0f, 8.0f);
        this.corners[3] = new PositionTextureVertex(x, height, z, 8.0f, 0.0f);
        this.corners[4] = new PositionTextureVertex(x, y, depth, 0.0f, 0.0f);
        this.corners[5] = new PositionTextureVertex(width, y, depth, 0.0f, 8.0f);
        this.corners[6] = new PositionTextureVertex(width, height, depth, 8.0f, 8.0f);
        this.corners[7] = new PositionTextureVertex(x, height, depth, 8.0f, 0.0f);
        int r1 = i > 16 ? 16 : i;
        int r2 = k > 16 ? 16 : k;
        int bottom = j > 16 ? 16 : j;
        this.faces[0] = new ParachuteTexturedQuad(new PositionTextureVertex[]{this.corners[5], this.corners[1], this.corners[2], this.corners[6]}, this.left, this.top, this.left + r1, this.top + bottom);
        this.faces[1] = new ParachuteTexturedQuad(new PositionTextureVertex[]{this.corners[0], this.corners[4], this.corners[7], this.corners[3]}, this.left, this.top, this.left + r1, this.top + bottom);
        this.faces[2] = new ParachuteTexturedQuad(new PositionTextureVertex[]{this.corners[5], this.corners[4], this.corners[0], this.corners[1]}, this.left, this.top, this.left + r1, this.top + r2);
        this.faces[3] = new ParachuteTexturedQuad(new PositionTextureVertex[]{this.corners[2], this.corners[3], this.corners[7], this.corners[6]}, this.left, this.top, this.left + r1, this.top + r2);
        this.faces[4] = new ParachuteTexturedQuad(new PositionTextureVertex[]{this.corners[1], this.corners[0], this.corners[3], this.corners[2]}, this.left, this.top, this.left + r1, this.top + bottom);
        this.faces[5] = new ParachuteTexturedQuad(new PositionTextureVertex[]{this.corners[4], this.corners[5], this.corners[6], this.corners[7]}, this.left, this.top, this.left + r1, this.top + bottom);
        if (this.mirror) {
            for (int l = 0; l < this.faces.length; ++l) {
                this.faces[l].flipFace();
            }
        }
    }

    public void setRotationPoint(float x, float y, float z) {
        this.rotationPointX = x;
        this.rotationPointY = y;
        this.rotationPointZ = z;
    }

    public void render(float f) {
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glCallList((int)this.displayList);
            GL11.glPopMatrix();
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            GL11.glCallList((int)this.displayList);
            GL11.glTranslatef((float)(-this.rotationPointX * f), (float)(-this.rotationPointY * f), (float)(-this.rotationPointZ * f));
        } else {
            GL11.glCallList((int)this.displayList);
        }
    }

    public void renderWithRotation(float f) {
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        if (this.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glCallList((int)this.displayList);
        GL11.glPopMatrix();
    }

    public void postRender(float f) {
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        }
    }

    private void compileDisplayList(float f) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < this.faces.length; ++i) {
            this.faces[i].draw(tessellator, f);
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public final ParachuteModelRenderer setTextureSize(float x, float y) {
        this.textureWidth = x;
        this.textureHeight = y;
        return this;
    }
}

