/*
 * Decompiled with CFR 0.152.
 */
package parachute.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import parachute.common.Parachute;
import parachute.common.PlayerInfo;
import parachute.common.PlayerManagerParachute;

public class EntityParachute
extends Entity {
    private boolean isTurning;
    private int newRotationInc;
    private double newPosX;
    private double newPosY;
    private double newPosZ;
    private double newRotationYaw;
    private double newRotationPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private double motionFactor;
    private double maxAltitude;
    private boolean allowThermals;
    private boolean smallCanopy = Parachute.instance.isSmallCanopy();
    private final int hitTime = 10;
    private final float maxDamage = 40.0f;
    static final double drift = 0.004;
    static final double ascend = -0.04;
    static final int modeDrift = 0;
    static final int modeAscend = 1;
    static final double forwardSpeed = 0.75;
    private static double descentRate = 0.004;

    public EntityParachute(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 1.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        descentRate = 0.004;
        this.motionFactor = 0.07;
        this.isTurning = true;
        this.allowThermals = Parachute.instance.getAllowThermals();
        this.maxAltitude = Parachute.instance.getMaxAltitude();
    }

    public EntityParachute(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity != this.field_70153_n && entity.field_70154_o != this) {
            return entity.field_70121_D;
        }
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return this.smallCanopy ? -2.5 : -3.5;
    }

    public void destroyParachute() {
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource damagesource, float damage) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + damage * 10.0f);
            this.func_70018_K();
            if (this.getDamageTaken() > 40.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.destroyParachute();
            }
        }
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int inc) {
        if (this.isTurning) {
            this.newRotationInc = inc + 5;
        } else {
            double newX = x - this.field_70165_t;
            double newY = y - this.field_70163_u;
            double newZ = z - this.field_70161_v;
            double magnitude = newX * newX + newY * newY + newZ * newZ;
            if (magnitude <= 1.0) {
                return;
            }
            this.newRotationInc = 3;
        }
        this.newPosX = x;
        this.newPosY = y;
        this.newPosZ = z;
        this.newRotationYaw = yaw;
        this.newRotationPitch = pitch;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.velocityZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70153_n == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.destroyParachute();
            }
            return;
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double velocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        this.checkShouldDropChute(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.smallCanopy ? 3.5 : 4.5);
        if (this.field_70170_p.field_72995_K && this.isTurning) {
            if (this.newRotationInc > 0) {
                double x = this.field_70165_t + (this.newPosX - this.field_70165_t) / (double)this.newRotationInc;
                double y = this.field_70163_u + (this.newPosY - this.field_70163_u) / (double)this.newRotationInc;
                double z = this.field_70161_v + (this.newPosZ - this.field_70161_v) / (double)this.newRotationInc;
                double adjYaw = MathHelper.func_76138_g((double)(this.newRotationYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + adjYaw / (double)this.newRotationInc);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.newRotationPitch - (double)this.field_70125_A) / (double)this.newRotationInc);
                --this.newRotationInc;
                this.func_70107_b(x, y, z);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.field_70181_x -= this.currentDescentRate();
                double x = this.field_70165_t + this.field_70159_w;
                double y = this.field_70163_u + this.field_70181_x;
                double z = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(x, y, z);
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.99;
            }
        } else {
            double adjustedYaw;
            double localvelocity;
            double forwardMovement;
            double d = forwardMovement = this.allowThermals ? (double)((EntityLivingBase)this.field_70153_n).field_70701_bs : 0.75;
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                if (forwardMovement > 0.0) {
                    double x = -Math.sin((double)this.field_70153_n.field_70177_z * 0.0174532925199433);
                    double z = Math.cos((double)this.field_70153_n.field_70177_z * 0.0174532925199433);
                    this.field_70159_w += x * this.motionFactor * 0.05 * forwardMovement;
                    this.field_70179_y += z * this.motionFactor * 0.05 * forwardMovement;
                }
                this.field_70153_n.field_70143_R = 0.0f;
                this.field_70153_n.field_70132_H = false;
            }
            if ((localvelocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.35) {
                double motionAdj = 0.35 / localvelocity;
                this.field_70159_w *= motionAdj;
                this.field_70179_y *= motionAdj;
                localvelocity = 0.35;
            }
            if (localvelocity > velocity && this.motionFactor < 0.35) {
                this.motionFactor += (0.35 - this.motionFactor) / 35.0;
                if (this.motionFactor > 0.35) {
                    this.motionFactor = 0.35;
                }
            } else {
                this.motionFactor -= (this.motionFactor - 0.07) / 35.0;
                if (this.motionFactor < 0.07) {
                    this.motionFactor = 0.07;
                }
            }
            this.field_70181_x -= this.currentDescentRate();
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.99;
            this.field_70181_x *= 0.95;
            this.field_70179_y *= 0.99;
            this.field_70125_A = 0.0f;
            double yaw = this.field_70177_z;
            double delta_X = this.field_70169_q - this.field_70165_t;
            double delta_Z = this.field_70166_s - this.field_70161_v;
            if (delta_X * delta_X + delta_Z * delta_Z > 0.001) {
                yaw = (float)(Math.atan2(delta_Z, delta_X) * (double)57.29578f);
            }
            if ((adjustedYaw = MathHelper.func_76138_g((double)(yaw - (double)this.field_70177_z))) > 20.0) {
                adjustedYaw = 20.0;
            }
            if (adjustedYaw < -20.0) {
                adjustedYaw = -20.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + adjustedYaw);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
                if (list != null && list.isEmpty()) {
                    for (int k = 0; k < list.size(); ++k) {
                        Entity entity = (Entity)list.get(k);
                        if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityParachute)) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                for (int l = 0; l < 4; ++l) {
                    int chuteX = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(l % 2) - 0.5) * 0.8));
                    int chuteZ = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(l / 2) - 0.5) * 0.8));
                    for (int k1 = 0; k1 < 2; ++k1) {
                        int chuteY = MathHelper.func_76128_c((double)this.field_70163_u) + k1;
                        int blockID = this.field_70170_p.func_72798_a(chuteX, chuteY, chuteZ);
                        if (blockID != Block.field_71952_K.field_71990_ca) continue;
                        this.field_70159_w *= 0.15;
                        this.field_70181_x *= 0.05;
                        this.field_70179_y *= 0.15;
                    }
                }
                if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                    this.field_70153_n = null;
                    if (!this.field_70170_p.field_72995_K) {
                        this.destroyParachute();
                    }
                }
            }
        }
        descentRate = 0.004;
    }

    public double currentDescentRate() {
        PlayerInfo pInfo;
        descentRate = 0.004;
        if (!this.allowThermals) {
            return descentRate;
        }
        EntityPlayer player = (EntityPlayer)this.field_70153_n;
        if (player != null && (pInfo = PlayerManagerParachute.getInstance().getPlayerInfoFromPlayer(player)) != null) {
            switch (pInfo.mode) {
                case 0: {
                    descentRate = 0.004;
                    break;
                }
                case 1: {
                    descentRate = -0.04;
                }
            }
        }
        if (this.maxAltitude > 0.0 && this.field_70163_u >= this.maxAltitude) {
            descentRate = 0.004;
        }
        return descentRate;
    }

    protected boolean checkShouldDropChute(double x, double y, double z, double distance) {
        boolean shouldDrop = false;
        if (this.isNearGround(x, y, z, distance)) {
            if (this.field_70153_n != null) {
                this.field_70153_n.field_70143_R = 0.0f;
                this.field_70153_n.func_70078_a((Entity)this);
                if (!this.field_70170_p.field_72995_K) {
                    this.destroyParachute();
                } else {
                    this.field_70153_n = null;
                }
            }
            shouldDrop = true;
        }
        return shouldDrop;
    }

    public boolean isNearGround(double posx, double posy, double posz, double distance) {
        int z;
        int y;
        boolean nearGround = false;
        int x = MathHelper.func_76128_c((double)posx);
        if (!this.field_70170_p.func_72799_c(x, y = MathHelper.func_76128_c((double)(posy - distance)), z = MathHelper.func_76128_c((double)posz))) {
            nearGround = true;
        }
        return nearGround;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double cosYaw = Math.cos((double)this.field_70177_z * 0.01745329252) * 0.4;
            double sinYaw = Math.sin((double)this.field_70177_z * 0.01745329252) * 0.4;
            this.field_70153_n.func_70107_b(this.field_70165_t + cosYaw, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + sinYaw);
        }
    }

    public void func_70098_U() {
        if (this.field_70154_o.field_70128_L) {
            this.field_70154_o = null;
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70071_h_();
            if (this.field_70154_o != null) {
                this.field_70154_o.func_70043_V();
            }
        }
    }

    protected void dropRemains() {
        this.func_70025_b(Block.field_72101_ab.field_71990_ca, 1);
        this.func_70025_b(Item.field_77683_K.field_77779_bT, 1);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void setDamageTaken(float f) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(f));
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setTimeSinceHit(int time) {
        this.field_70180_af.func_75692_b(17, (Object)time);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int forward) {
        this.field_70180_af.func_75692_b(18, (Object)forward);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70270_d(boolean turning) {
        this.isTurning = turning;
    }
}

