/*
 * Decompiled with CFR 0.152.
 */
package parachute.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.EnumHelper;
import parachute.common.CommonProxyParachute;
import parachute.common.EntityParachute;
import parachute.common.ItemAutoActivateDevice;
import parachute.common.ItemHopAndPop;
import parachute.common.ItemParachute;
import parachute.common.ItemRipCord;
import parachute.common.ParachutePacketHandler;

@Mod(modid="ParachuteMod", name="Parachute Mod", version="1.6.4")
@NetworkMod(versionBounds="[1.6.4]", clientSideRequired=true, serverSideRequired=false, packetHandler=ParachutePacketHandler.class, connectionHandler=ParachutePacketHandler.class, channels={"ParachuteMod"})
public class Parachute {
    static EnumArmorMaterial NYLON = EnumHelper.addArmorMaterial((String)"nylon", (int)15, (int[])new int[]{2, 5, 4, 1}, (int)12);
    static EnumToolMaterial RIPSTOP = EnumHelper.addToolMaterial((String)"ripstop", (int)0, (int)59, (float)2.0f, (float)0.0f, (int)15);
    public static final String modid = "ParachuteMod";
    public static final String mcversion = "1.6.4";
    public static final String channel = "ParachuteMod";
    public static final String name = "Parachute Mod";
    public static final String parachuteName = "Parachute";
    public static final String ripcordName = "Ripcord";
    public static final String aadName = "AutoActivationDevice";
    public static final String hopnpopName = "HopAndPop";
    private String type = "Parachute";
    private boolean singleUse;
    private int heightLimit;
    private int chuteColor;
    private boolean thermals;
    private static double AADAltitude;
    private boolean smallCanopy;
    private static int parachuteID;
    private static int ripcordID;
    private static int aadID;
    private static int popID;
    private static boolean AADActive;
    private static double fallThreshold;
    private final int entityID = EntityRegistry.findGlobalUniqueEntityId();
    private static final int armorType = 1;
    public static final int armorSlot = 2;
    @SidedProxy(clientSide="parachute.client.ClientProxyParachute", serverSide="parachute.common.CommonProxyParachute")
    public static CommonProxyParachute proxy;
    public static ItemParachute parachuteItem;
    public static ItemHopAndPop hopnpopItem;
    public static ItemRipCord ripcordItem;
    public static ItemAutoActivateDevice aadItem;
    @Mod.Instance
    public static Parachute instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String generalComments = "Parachute Mod Config\nMichael Sheppard (crackedEgg)";
        String itemComment = "parachuteID - customize the Parachute Item ID (2500)";
        String cordComment = "ripcordID - customize the Ripcord Item ID (2501)";
        String aadComment = "auto activation device ID - customize the AAD Item ID (2502)";
        String popComment = "popID - customize the hop-n-pop Item ID (2503)";
        String usageComment = "singleUse - set to true for hop n pop single use (false)";
        String heightComment = "heightLimit  - 0 (zero) disables altitude limiting (256)";
        String thermalComment = "allowThermals - true|false enable/disable thermals (true)";
        String aadAltitudeComment = "AADAltitude - altitude (in meters) at which auto deploy occurs (10)";
        String fallThresholdComment = "fallThreshold - player must have fallen this far to activate AAD (5.0)";
        String aaDActiveComment = "AADActive - whether the AAD is active or not. default is inactive. (false)";
        String typeComment = "smallCanopy - set to true to use the smaller 3 panel canopy, false for the\nlarger 4 panel canopy (true)";
        String colorComment = "Color index numbers:\nblack        -  0\nblue         -  1\nbrown        -  2\ncyan         -  3\ngray         -  4\ngreen        -  5\nlight blue   -  6\nlime         -  7\nmagneta      -  8\norange       -  9\npink         - 10\npurple       - 11\nred          - 12\nsilver       - 13\nwhite        - 14\nyellow       - 15\nblue/white   - 16\nred/white    - 17\nyellow/green - 18";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        parachuteID = config.get("general", "parachuteID", 2500, itemComment).getInt();
        ripcordID = config.get("general", "ripcordID", 2501, cordComment).getInt();
        aadID = config.get("general", "aadID", 2502, aadComment).getInt();
        popID = config.get("general", "popID", 2503, popComment).getInt();
        this.singleUse = config.get("general", "singleUse", false, usageComment).getBoolean(false);
        this.heightLimit = config.get("general", "heightLimit", 256, heightComment).getInt();
        this.thermals = config.get("general", "allowThermals", true, thermalComment).getBoolean(true);
        fallThreshold = config.get("general", "fallThreshold", 5.0, fallThresholdComment).getDouble(5.0);
        AADAltitude = config.get("general", "AADAltitude", 15.0, aadAltitudeComment).getDouble(15.0);
        AADActive = config.get("general", "AADActive", false, aaDActiveComment).getBoolean(false);
        this.smallCanopy = config.get("general", "smallCanopy", true, typeComment).getBoolean(true);
        this.chuteColor = config.get("general", "chuteColor", 18, colorComment).getInt();
        config.addCustomCategoryComment("general", generalComments);
        config.save();
        fallThreshold = fallThreshold < 2.0 ? 2.0 : fallThreshold;
        proxy.registerRenderer();
        proxy.registerServerTickHandler();
        proxy.registerPlayerTickHandler();
        proxy.registerConnectionHandler();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        int chuteID = proxy.addArmor("parachute");
        EntityRegistry.registerModEntity(EntityParachute.class, (String)parachuteName, (int)this.entityID, (Object)this, (int)64, (int)10, (boolean)true);
        parachuteItem = new ItemParachute(parachuteID, NYLON, chuteID, 1);
        parachuteItem.func_111206_d("ParachuteMod".toLowerCase() + ":Parachute");
        parachuteItem.func_77655_b(parachuteName);
        Parachute.NYLON.customCraftingMaterial = Item.field_77683_K;
        Parachute.RIPSTOP.customCraftingMaterial = Item.field_77683_K;
        ripcordItem = (ItemRipCord)new ItemRipCord(ripcordID).func_77655_b(ripcordName);
        aadItem = (ItemAutoActivateDevice)new ItemAutoActivateDevice(aadID).func_77655_b(aadName);
        hopnpopItem = (ItemHopAndPop)new ItemHopAndPop(popID, RIPSTOP).func_77655_b(hopnpopName);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)parachuteItem, 1), (Object[])new Object[]{"###", "X X", " L ", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('L'), Item.field_77770_aF});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)hopnpopItem, 1), (Object[])new Object[]{"###", "X X", " X ", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ripcordItem, 1), (Object[])new Object[]{"#  ", " # ", "  *", Character.valueOf('#'), Item.field_77683_K, Character.valueOf('*'), Item.field_77703_o});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)aadItem, 1), (Object[])new Object[]{" * ", " % ", " # ", Character.valueOf('*'), Item.field_94585_bY, Character.valueOf('%'), Item.field_77767_aC, Character.valueOf('#'), ripcordItem});
        LanguageRegistry.addName((Object)((Object)parachuteItem), (String)parachuteName);
        LanguageRegistry.addName((Object)((Object)ripcordItem), (String)ripcordName);
        LanguageRegistry.addName((Object)((Object)aadItem), (String)aadName);
        LanguageRegistry.addName((Object)((Object)hopnpopItem), (String)hopnpopName);
        instance = this;
    }

    public String getVersion() {
        return mcversion;
    }

    public double getMaxAltitude() {
        return this.heightLimit;
    }

    public boolean getAllowThermals() {
        return this.thermals;
    }

    public int getChuteColor() {
        return this.chuteColor;
    }

    public static double getAADAltitude() {
        return AADAltitude;
    }

    public static boolean getAADActive() {
        return AADActive;
    }

    public static double getFallThreshold() {
        return fallThreshold;
    }

    public void setAADActive(boolean active) {
        AADActive = active;
    }

    public boolean isSmallCanopy() {
        return this.smallCanopy;
    }

    public static int getItemID() {
        return parachuteID;
    }

    public void setType(String type) {
        this.type = type;
        if (this.type.equals(hopnpopName)) {
            this.smallCanopy = true;
        }
    }

    public String getType() {
        return this.type;
    }

    public int getHopAndPopDamageAmount() {
        if (this.singleUse) {
            return hopnpopItem.func_77612_l() + 1;
        }
        return 1;
    }

    public static boolean playerIsWearingParachute(EntityPlayer player) {
        Item item;
        ItemStack stack;
        ItemStack itemStack = stack = player == null ? null : player.func_82169_q(2);
        return stack != null && (item = stack.func_77973_b()) != null && item instanceof ItemParachute;
    }

    public static boolean isFalling(EntityPlayer entity) {
        return entity.field_70143_R > 0.0f && !entity.field_70122_E && !entity.func_70617_f_();
    }
}

