/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.client;

import com.parachute.client.ModelParachute;
import com.parachute.common.EntityParachute;
import com.parachute.common.Parachute;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderParachute
extends Render {
    private static String curColor = Parachute.instance.getChuteColor();
    protected static ModelBase modelParachute;
    private static ResourceLocation parachuteTexture;
    private static final Random rand;

    public RenderParachute() {
        this.field_76989_e = 0.0f;
        modelParachute = new ModelParachute();
    }

    public void renderParachute(EntityParachute entityparachute, double x, double y, double z, float rotation, float center) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        float time = (float)entityparachute.getTimeSinceHit() - center;
        float damage = entityparachute.getDamageTaken() - center;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (time > 0.0f) {
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)time) * time * damage / 20.0f * (float)entityparachute.getForwardDirection()), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.func_110777_b(entityparachute);
        modelParachute.func_78088_a((Entity)entityparachute, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        if (entityparachute.field_70153_n != null) {
            EntityPlayer rider = (EntityPlayer)entityparachute.field_70153_n;
            if (Parachute.instance.isSmallCanopy()) {
                this.renderSmallParachuteCords(rider, center);
            } else {
                this.renderLargeParachuteCords(rider, center);
            }
        }
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float rotation, float center) {
        this.renderParachute((EntityParachute)entity, x, y, z, rotation, center);
    }

    public void renderLargeParachuteCords(EntityPlayer rider, float center) {
        float zOffset = 3.0f;
        float x = -5.0f;
        float y = 2.5f;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            y = 1.5f;
        }
        float zl = -zOffset;
        float zr = zOffset;
        float b = rider.func_70013_c(center);
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glScalef((float)0.0625f, (float)-1.0f, (float)0.0625f);
        GL11.glBegin((int)1);
        GL11.glColor3f((float)(b * 0.5f), (float)(b * 0.5f), (float)(b * 0.65f));
        GL11.glVertex3f((float)-8.0f, (float)0.37f, (float)-31.5f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glVertex3f((float)8.0f, (float)0.37f, (float)-31.5f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glVertex3f((float)-8.0f, (float)0.12f, (float)-16.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glVertex3f((float)8.0f, (float)0.12f, (float)-16.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glColor3f((float)(b * 0.65f), (float)(b * 0.5f), (float)(b * 0.5f));
        GL11.glVertex3f((float)-8.0f, (float)0.37f, (float)31.5f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glVertex3f((float)8.0f, (float)0.37f, (float)31.5f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glVertex3f((float)-8.0f, (float)0.12f, (float)16.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glVertex3f((float)8.0f, (float)0.12f, (float)16.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glColor3f((float)(b * 0.5f), (float)(b * 0.65f), (float)(b * 0.5f));
        GL11.glVertex3f((float)-8.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glVertex3f((float)8.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glVertex3f((float)-8.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glVertex3f((float)8.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public void renderSmallParachuteCords(EntityPlayer rider, float center) {
        float zOffset = 3.0f;
        float x = -5.0f;
        float y = 1.5f;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            y = 1.25f;
        }
        float zl = -zOffset;
        float zr = zOffset;
        float b = rider.func_70013_c(center);
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glScalef((float)0.0625f, (float)-1.0f, (float)0.0625f);
        GL11.glBegin((int)1);
        GL11.glColor3f((float)(b * 0.5f), (float)(b * 0.5f), (float)(b * 0.65f));
        GL11.glVertex3f((float)-8.0f, (float)0.25f, (float)-23.5f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glVertex3f((float)8.0f, (float)0.25f, (float)-23.5f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glVertex3f((float)-8.0f, (float)0.0f, (float)-8.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glVertex3f((float)8.0f, (float)0.0f, (float)-8.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zl);
        GL11.glColor3f((float)(b * 0.65f), (float)(b * 0.5f), (float)(b * 0.5f));
        GL11.glVertex3f((float)-8.0f, (float)0.25f, (float)23.5f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glVertex3f((float)8.0f, (float)0.25f, (float)23.5f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glVertex3f((float)-8.0f, (float)0.0f, (float)8.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glVertex3f((float)8.0f, (float)0.0f, (float)8.0f);
        GL11.glVertex3f((float)x, (float)y, (float)zr);
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void setParachuteColor(String color) {
        parachuteTexture = color.equalsIgnoreCase("random") ? new ResourceLocation("textures/blocks/wool_colored_" + RenderParachute.getRandomColor() + ".png") : new ResourceLocation("textures/blocks/wool_colored_" + color + ".png");
        curColor = color;
    }

    protected static ResourceLocation getParachuteColor(String color) {
        if (parachuteTexture == null) {
            parachuteTexture = color.equalsIgnoreCase("random") ? new ResourceLocation("textures/blocks/wool_colored_" + RenderParachute.getRandomColor() + ".png") : new ResourceLocation("textures/blocks/wool_colored_" + color + ".png");
            curColor = color;
        }
        return parachuteTexture;
    }

    protected static String getRandomColor() {
        String[] colors = new String[]{"black", "blue", "brown", "cyan", "gray", "green", "light_blue", "lime", "magenta", "orange", "pink", "purple", "red", "silver", "white", "yellow"};
        return colors[rand.nextInt(16)];
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        parachuteTexture = RenderParachute.getParachuteColor(curColor);
        return parachuteTexture;
    }

    static {
        parachuteTexture = null;
        rand = new Random(System.currentTimeMillis());
    }
}

