/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.common.Parachute;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityParachute
extends Entity {
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private double motionFactor;
    private double maxAltitude;
    private boolean allowThermals;
    private boolean smallCanopy = Parachute.instance.isSmallCanopy();
    static final double drift = 0.004;
    static final double ascend = -0.04;
    static final int modeDrift = 0;
    static final int modeAscend = 1;
    static final double forwardSpeed = 0.75;
    private final double d2r = 0.0174532925199433;
    private final double r2d = 57.2957795130823;
    private static boolean ascendMode;

    public EntityParachute(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 1.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.motionFactor = 0.07;
        ascendMode = false;
        this.allowThermals = Parachute.instance.getAllowThermals();
        this.maxAltitude = Parachute.instance.getMaxAltitude();
    }

    public EntityParachute(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public static void setAscendMode(boolean mode) {
        ascendMode = mode;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)1);
        this.field_70180_af.func_75682_a(19, (Object)Float.valueOf(0.0f));
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity != this.field_70153_n && entity.field_70154_o != this) {
            return entity.field_70121_D;
        }
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return this.smallCanopy ? -2.5 : -3.5;
    }

    public void destroyParachute() {
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int inc) {
        double deltaX = x - this.field_70165_t;
        double deltaY = y - this.field_70163_u;
        double deltaZ = z - this.field_70161_v;
        double magnitude = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (magnitude <= 1.0) {
            return;
        }
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.velocityZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        List list;
        double adjustedYaw;
        double localvelocity;
        double offset;
        super.func_70071_h_();
        if (this.field_70153_n == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.destroyParachute();
            }
            return;
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double velocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (Parachute.instance.isAutoDismount() && this.checkShouldDropChute(this.field_70165_t, this.field_70163_u, this.field_70161_v, (offset = Math.abs(this.func_70042_X())) + 1.0)) {
            return;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
            double forwardMovement;
            EntityLivingBase rider = (EntityLivingBase)this.field_70153_n;
            double d = forwardMovement = this.allowThermals ? (double)rider.field_70701_bs : 0.75;
            if (forwardMovement > 0.0) {
                double f = (double)rider.field_70177_z + (double)(-rider.field_70702_br) * 90.0;
                this.field_70159_w += -Math.sin(f * 0.0174532925199433) * this.motionFactor * 0.05 * forwardMovement;
                this.field_70179_y += Math.cos(f * 0.0174532925199433) * this.motionFactor * 0.05 * forwardMovement;
            }
        }
        if ((localvelocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.35) {
            double motionAdj = 0.35 / localvelocity;
            this.field_70159_w *= motionAdj;
            this.field_70179_y *= motionAdj;
            localvelocity = 0.35;
        }
        if (localvelocity > velocity && this.motionFactor < 0.35) {
            this.motionFactor += (0.35 - this.motionFactor) / 35.0;
            if (this.motionFactor > 0.35) {
                this.motionFactor = 0.35;
            }
        } else {
            this.motionFactor -= (this.motionFactor - 0.07) / 35.0;
            if (this.motionFactor < 0.07) {
                this.motionFactor = 0.07;
            }
        }
        this.field_70181_x -= this.currentDescentRate();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.95;
        this.field_70179_y *= 0.99;
        this.field_70125_A = 0.0f;
        double yaw = this.field_70177_z;
        double delta_X = this.field_70169_q - this.field_70165_t;
        double delta_Z = this.field_70166_s - this.field_70161_v;
        if (delta_X * delta_X + delta_Z * delta_Z > 0.001) {
            yaw = (float)(Math.atan2(delta_Z, delta_X) * 57.2957795130823);
        }
        if ((adjustedYaw = MathHelper.func_76138_g((double)(yaw - (double)this.field_70177_z))) > 20.0) {
            adjustedYaw = 20.0;
        }
        if (adjustedYaw < -20.0) {
            adjustedYaw = -20.0;
        }
        this.field_70177_z = (float)((double)this.field_70177_z + adjustedYaw);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (!this.field_70170_p.field_72995_K && (list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2))) != null && list.isEmpty()) {
            for (Object list1 : list) {
                Entity entity = (Entity)list1;
                if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityParachute)) continue;
                entity.func_70108_f((Entity)this);
            }
        }
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
            if (!this.field_70170_p.field_72995_K) {
                this.destroyParachute();
            }
        }
    }

    public double currentDescentRate() {
        double descentRate = 0.004;
        if (!this.allowThermals) {
            return descentRate;
        }
        if (ascendMode) {
            descentRate = -0.04;
        }
        if (this.maxAltitude > 0.0 && this.field_70163_u >= this.maxAltitude) {
            descentRate = 0.004;
        }
        return descentRate;
    }

    protected boolean checkShouldDropChute(double x, double y, double z, double distance) {
        boolean shouldDrop = false;
        if (this.isNearGround(x, y, z, distance)) {
            if (this.field_70153_n != null) {
                this.dropParachute(this);
                if (!this.field_70170_p.field_72995_K) {
                    this.destroyParachute();
                } else {
                    this.field_70153_n = null;
                }
            }
            shouldDrop = true;
        }
        return shouldDrop;
    }

    public boolean isNearGround(double posx, double posy, double posz, double distance) {
        int z;
        int y;
        boolean result = false;
        int x = MathHelper.func_76128_c((double)posx);
        if (!this.field_70170_p.func_147437_c(x, y = MathHelper.func_76128_c((double)(posy - distance)), z = MathHelper.func_76128_c((double)posz))) {
            return true;
        }
        return result;
    }

    public void dropParachute(Entity parachute) {
        if (parachute == null) {
            if (this.field_70154_o != null) {
                this.func_70012_b(this.field_70154_o.field_70165_t, this.field_70154_o.field_70121_D.field_72338_b + (double)this.field_70154_o.field_70131_O, this.field_70154_o.field_70161_v, this.field_70177_z, this.field_70125_A);
                this.field_70154_o.field_70153_n = null;
            }
            this.field_70154_o = null;
        } else {
            if (this.field_70154_o != null) {
                this.field_70154_o.field_70153_n = null;
            }
            this.field_70154_o = parachute;
            parachute.field_70153_n = this;
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double cosYaw = Math.cos((double)this.field_70177_z * 0.0174532925199433) * 0.4;
            double sinYaw = Math.sin((double)this.field_70177_z * 0.0174532925199433) * 0.4;
            this.field_70153_n.func_70107_b(this.field_70165_t + cosYaw, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + sinYaw);
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void setDamageTaken(float f) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(f));
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setTimeSinceHit(int time) {
        this.field_70180_af.func_75692_b(17, (Object)time);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int forward) {
        this.field_70180_af.func_75692_b(18, (Object)forward);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }
}

