/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.common.AADTick;
import com.parachute.common.CommonProxyParachute;
import com.parachute.common.EntityParachute;
import com.parachute.common.ItemAutoActivateDevice;
import com.parachute.common.ItemHopAndPop;
import com.parachute.common.ItemParachute;
import com.parachute.common.ItemRipCord;
import com.parachute.common.PacketHandler;
import com.parachute.common.PlayerFallEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="parachutemod", name="Parachute Mod", version="1.7.10")
public class Parachute {
    static ItemArmor.ArmorMaterial NYLON = EnumHelper.addArmorMaterial((String)"nylon", (int)15, (int[])new int[]{2, 5, 4, 1}, (int)12);
    static Item.ToolMaterial RIPSTOP = EnumHelper.addToolMaterial((String)"ripstop", (int)0, (int)59, (float)2.0f, (float)0.0f, (int)15);
    public static final String modid = "parachutemod";
    public static final String mcversion = "1.7.10";
    public static final String channel = "parachutemod";
    public static final String name = "Parachute Mod";
    public static final String parachuteName = "Parachute";
    public static final String ripcordName = "Ripcord";
    public static final String aadName = "AutoActivationDevice";
    public static final String hopnpopName = "HopAndPop";
    private String type = "Parachute";
    private boolean singleUse = false;
    private int heightLimit = 256;
    private String chuteColor = "random";
    private boolean thermals = true;
    private double AADAltitude = 15.0;
    private boolean smallCanopy = true;
    private boolean AADActive = false;
    private boolean autoDismount = true;
    private double fallThreshold = 5.0;
    private boolean weatherAffectsDrift;
    private boolean lavaThermals;
    private double minLavaDistance;
    private double maxLavaDistance;
    private boolean allowTurbulence;
    private boolean showContrails;
    private final int entityID = EntityRegistry.findGlobalUniqueEntityId();
    private static final int armorType = 1;
    public static final int armorSlot = 2;
    @SidedProxy(clientSide="com.parachute.client.ClientProxyParachute", serverSide="com.parachute.common.CommonProxyParachute")
    public static CommonProxyParachute proxy;
    public static ItemParachute parachuteItem;
    public static ItemHopAndPop hopnpopItem;
    public static ItemRipCord ripcordItem;
    public static ItemAutoActivateDevice aadItem;
    @Mod.Instance(value="parachutemod")
    public static Parachute instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String generalComments = "Parachute Mod Config\nMichael Sheppard (crackedEgg) For Minecraft Version 1.7.10\n";
        String usageComment = "singleUse - set to true for hop n pop single use (false)";
        String heightComment = "heightLimit  - 0 (zero) disables altitude limiting (256)";
        String thermalComment = "allowThermals - true|false enable/disable thermals (true)";
        String lavaThermalComment = "use lava heat to get thermals to rise up, disables space bar thermals (false)";
        String minLavaDistanceComment = "minimum distance from lava to grab thermals, if you\ngo less than 3.0 you will most likely dismount in the lava! (3.0)";
        String maxLavaDistanceComment = "maximum distance to rise from lava thermals (48)";
        String aadAltitudeComment = "AADAltitude - altitude (in meters) at which auto deploy occurs (10)";
        String fallThresholdComment = "fallThreshold - player must have fallen this far to activate AAD (5.0)";
        String aaDActiveComment = "AADActive - whether the AAD is active or not. default is inactive. (false)";
        String typeComment = "smallCanopy - set to true to use the smaller 3 panel canopy, false for the\nlarger 4 panel canopy (true)";
        String autoComment = "If true the parachute will dismount the player automatically,\nif false the player has to use LSHIFT to dismount the parachute.";
        String weatherComment = "set to false if you don't want the drift rate to be affected by bad weather (true)";
        String turbulenceComment = "set to true to feel the turbulent world of Minecraft (false)";
        String trailsComment = "set to true to show contrails from parachute (false)";
        String colorComment = "Parachute Colors Allowed:\nblack\nblue\nbrown\ncyan\ngray\ngreen\nlight_blue\nlime\nmagenta\norange\npink\npurple\nred\nsilver\nwhite\nyellow\nrandom - allows randomly chosen color each time chute is opened\ncustom[0-9] - allows use of a custom texture called 'custom' with a single number appended";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.singleUse = config.get("general", "singleUse", false, usageComment).getBoolean(false);
        this.heightLimit = config.get("general", "heightLimit", 256, heightComment).getInt();
        this.lavaThermals = config.get("general", "lavaThermals", false, lavaThermalComment).getBoolean(false);
        this.minLavaDistance = config.get("general", "minLavaDistance", 3.0, minLavaDistanceComment).getDouble(3.0);
        this.maxLavaDistance = config.get("general", "maxLavaDistance", 48.0, maxLavaDistanceComment).getDouble(48.0);
        this.thermals = config.get("general", "allowThermals", true, thermalComment).getBoolean(true);
        this.fallThreshold = config.get("general", "fallThreshold", 5.0, fallThresholdComment).getDouble(5.0);
        this.AADAltitude = config.get("general", "AADAltitude", 15.0, aadAltitudeComment).getDouble(15.0);
        this.AADActive = config.get("general", "AADActive", false, aaDActiveComment).getBoolean(false);
        this.smallCanopy = config.get("general", "smallCanopy", true, typeComment).getBoolean(true);
        this.autoDismount = config.get("general", "autoDismount", true, autoComment).getBoolean(true);
        this.chuteColor = config.get("general", "chuteColor", "random", colorComment).getString();
        this.weatherAffectsDrift = config.get("general", "weatherAffectsDrift", true, weatherComment).getBoolean(true);
        this.allowTurbulence = config.get("general", "allowTurbulence", false, turbulenceComment).getBoolean(false);
        this.showContrails = config.get("general", "showContrails", false, trailsComment).getBoolean(false);
        if (this.lavaThermals) {
            this.thermals = false;
            this.minLavaDistance = this.minLavaDistance < 2.0 ? 2.0 : this.minLavaDistance;
        }
        config.addCustomCategoryComment("general", generalComments);
        config.save();
        this.fallThreshold = this.fallThreshold < 2.0 ? 2.0 : this.fallThreshold;
        int chuteID = proxy.addArmor(parachuteName.toLowerCase());
        EntityRegistry.registerModEntity(EntityParachute.class, (String)parachuteName, (int)this.entityID, (Object)this, (int)64, (int)10, (boolean)true);
        parachuteItem = (ItemParachute)new ItemParachute(NYLON, chuteID, 1).func_77655_b(parachuteName);
        parachuteItem.func_111206_d("parachutemod:Parachute");
        GameRegistry.registerItem((Item)parachuteItem, (String)parachuteName);
        ripcordItem = (ItemRipCord)new ItemRipCord().func_77655_b(ripcordName);
        ripcordItem.func_111206_d("parachutemod:Ripcord");
        GameRegistry.registerItem((Item)ripcordItem, (String)ripcordName);
        aadItem = (ItemAutoActivateDevice)new ItemAutoActivateDevice().func_77655_b(aadName);
        aadItem.func_111206_d("parachutemod:AutoActivationDevice");
        GameRegistry.registerItem((Item)aadItem, (String)aadName);
        hopnpopItem = (ItemHopAndPop)new ItemHopAndPop(RIPSTOP).func_77655_b(hopnpopName);
        hopnpopItem.func_111206_d("parachutemod:HopAndPop");
        GameRegistry.registerItem((Item)hopnpopItem, (String)hopnpopName);
        proxy.registerRenderer();
        PacketHandler.init();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)parachuteItem, 1), (Object[])new Object[]{"###", "X X", " L ", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('L'), Items.field_151116_aA});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)hopnpopItem, 1), (Object[])new Object[]{"###", "X X", " X ", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ripcordItem, 1), (Object[])new Object[]{"#  ", " # ", "  *", Character.valueOf('#'), Items.field_151007_F, Character.valueOf('*'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)aadItem, 1), (Object[])new Object[]{" * ", " % ", " # ", Character.valueOf('*'), Items.field_151132_bS, Character.valueOf('%'), Items.field_151137_ax, Character.valueOf('#'), ripcordItem});
        Parachute.NYLON.customCraftingMaterial = Items.field_151007_F;
        Parachute.RIPSTOP.customCraftingMaterial = Items.field_151007_F;
        proxy.registerHandlers();
        FMLCommonHandler.instance().bus().register((Object)new AADTick());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerFallEvent());
        instance = this;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public String getVersion() {
        return mcversion;
    }

    public double getMaxAltitude() {
        return this.heightLimit;
    }

    public boolean getAllowThermals() {
        return this.thermals;
    }

    public boolean getAllowLavaThermals() {
        return this.lavaThermals;
    }

    public boolean getWeatherAffectsDrift() {
        return this.weatherAffectsDrift;
    }

    public double getMinLavaDistance() {
        return this.minLavaDistance;
    }

    public double getMaxLavaDistance() {
        return this.maxLavaDistance;
    }

    public boolean getAllowturbulence() {
        return this.allowTurbulence;
    }

    public boolean getShowContrails() {
        return this.showContrails;
    }

    public String getChuteColor() {
        return this.chuteColor;
    }

    public double getAADAltitude() {
        return this.AADAltitude;
    }

    public boolean getAADActive() {
        return this.AADActive;
    }

    public double getFallThreshold() {
        return this.fallThreshold;
    }

    public void setAADActive(boolean active) {
        this.AADActive = active;
    }

    public boolean isSmallCanopy() {
        return this.smallCanopy;
    }

    public boolean isAutoDismount() {
        return this.autoDismount;
    }

    public void setType(String type) {
        this.type = type;
        if (this.type.equals(hopnpopName)) {
            this.smallCanopy = true;
        }
    }

    public String getType() {
        return this.type;
    }

    public int getHopAndPopDamageAmount() {
        if (this.singleUse) {
            return hopnpopItem.func_77612_l() + 1;
        }
        return 1;
    }

    public static boolean playerIsWearingParachute(EntityPlayer player) {
        Item item;
        ItemStack stack;
        ItemStack itemStack = stack = player == null ? null : player.func_82169_q(2);
        return stack != null && (item = stack.func_77973_b()) != null && item instanceof ItemParachute;
    }

    public static boolean isFalling(EntityPlayer entity) {
        return entity.field_70143_R > 0.0f && !entity.field_70122_E && !entity.func_70617_f_();
    }
}

