/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.common.Parachute;
import net.minecraft.util.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHandler {
    public static Configuration config;
    public static final String aboutCategory = "About";
    private static boolean singleUse;
    private static int heightLimit;
    private static String chuteColor;
    private static boolean thermals;
    private static boolean autoDismount;
    private static boolean weatherAffectsDrift;
    private static boolean lavaThermals;
    private static double minLavaDistance;
    private static double maxLavaDistance;
    private static boolean constantTurbulence;
    private static boolean showContrails;
    private static boolean dismountInWater;
    private static boolean isAADActive;
    private static double aadAltitude;
    private static double minFallDistance;
    private static boolean aadImmediate;
    private static boolean useSpawnPoint;
    private static int[] waypoint;
    private static final String aboutComments = "Parachute Mod NG Config\nMichael Sheppard (crackedEgg) For Minecraft Version 1.8.9\n";
    private static final String usageComment = "set to true for parachute single use";
    private static final String heightComment = "0 (zero) disables altitude limiting";
    private static final String thermalComment = "enable thermal rise by pressing the space bar";
    private static final String lavaThermalComment = "use lava heat to get thermals to rise up, disables space bar thermals";
    private static final String minLavaDistanceComment = "minimum distance from lava to grab thermals, if you\ngo less than 3.0 you will most likely dismount in the lava!";
    private static final String maxLavaDistanceComment = "maximum distance to rise from lava thermals";
    private static final String autoComment = "If true the parachute will dismount the player automatically,\nif false the player has to use LSHIFT to dismount the parachute";
    private static final String weatherComment = "set to false if you don't want the drift rate to be affected by bad weather";
    private static final String turbulenceComment = "set to true to always feel the turbulent world of Minecraft";
    private static final String trailsComment = "set to true to show contrails from parachute";
    private static final String dismountComment = "true to dismount in water";
    private static final String lavaDisablesComment = "normal thermals are disabled by lava thermals";
    private static final String isAADActiveComment = "whether or not the AAD is active";
    private static final String aadAltitudeComment = "altitude (in meters) at which auto deploy occurs";
    private static final String aadImmedComment = "AAD deploys immediately after the player falls more than minFallDistance";
    private static final String minFallDistanceComment = "minimum distance to fall before the AAD deploys";
    private static final String useSpawnPointComment = "use spawn point for home direction or input your own coords";
    private static final String colorComment = "Parachute Colors Allowed:\nblack, blue, brown, cyan, gray, green, light_blue, lime,\nmagenta, orange, pink, purple, red, silver, white, yellow,\nrandom - randomly chosen color each time chute is opened\ncustom[0-9] - allows use of a custom texture called 'custom' with a single number appended";

    public static void startConfig(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        ConfigHandler.updateConfigInfo();
    }

    public static void updateConfigInfo() {
        try {
            config.addCustomCategoryComment(aboutCategory, aboutComments);
            singleUse = config.get("general", "singleUse", false, usageComment).getBoolean(false);
            heightLimit = config.get("general", "heightLimit", 256, heightComment).getInt();
            thermals = config.get("general", "allowThermals", true, thermalComment).getBoolean(true);
            lavaThermals = config.get("general", "lavaThermals", false, lavaThermalComment).getBoolean(false);
            minLavaDistance = config.get("general", "minLavaDistance", 3.0, minLavaDistanceComment).getDouble(3.0);
            maxLavaDistance = config.get("general", "maxLavaDistance", 48.0, maxLavaDistanceComment).getDouble(48.0);
            autoDismount = config.get("general", "autoDismount", true, autoComment).getBoolean(true);
            chuteColor = config.get("general", "chuteColor", "random", colorComment).getString();
            weatherAffectsDrift = config.get("general", "weatherAffectsDrift", true, weatherComment).getBoolean(true);
            constantTurbulence = config.get("general", "constantTurbulence", false, turbulenceComment).getBoolean(false);
            showContrails = config.get("general", "showContrails", false, trailsComment).getBoolean(false);
            dismountInWater = config.get("general", "dismountInWater", false, dismountComment).getBoolean(false);
            boolean lavaDisablesThermals = config.get("general", "lavaDisablesThermals", true, lavaDisablesComment).getBoolean(true);
            isAADActive = config.get("general", "isAADActive", false, isAADActiveComment).getBoolean(false);
            aadAltitude = config.get("general", "aadAltitude", 10.0, aadAltitudeComment).getDouble(10.0);
            minFallDistance = config.get("general", "minFallDistance", 5.0, minFallDistanceComment).getDouble(5.0);
            aadImmediate = config.get("general", "aadImmediate", false, aadImmedComment).getBoolean(false);
            useSpawnPoint = config.get("general", "usespawnpoint", true, useSpawnPointComment).getBoolean(false);
            waypoint = config.get("general", "waypoint", new int[]{0, 0}, "waypoint").getIntList();
            if (lavaThermals) {
                thermals = !lavaDisablesThermals;
                minLavaDistance = minLavaDistance < 2.0 ? 2.0 : minLavaDistance;
            }
        }
        catch (Exception e) {
            Parachute.proxy.info("failed to load or read the config file");
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static boolean getDismountInWater() {
        return dismountInWater;
    }

    public static double getMaxAltitude() {
        return heightLimit;
    }

    public static boolean getAllowThermals() {
        return thermals;
    }

    public static String getChuteColor() {
        return chuteColor;
    }

    public static boolean getAllowLavaThermals() {
        return lavaThermals;
    }

    public static boolean getWeatherAffectsDrift() {
        return weatherAffectsDrift;
    }

    public static double getMinLavaDistance() {
        return minLavaDistance;
    }

    public static double getMaxLavaDistance() {
        return maxLavaDistance;
    }

    public static boolean getAllowturbulence() {
        return constantTurbulence;
    }

    public static boolean getShowContrails() {
        return showContrails;
    }

    public static boolean isAutoDismount() {
        return autoDismount;
    }

    public static boolean getIsAADActive() {
        return isAADActive;
    }

    public static void setAADState(boolean state) {
        isAADActive = state;
    }

    public static double getAADAltitude() {
        return aadAltitude;
    }

    public static double getMinFallDistance() {
        return minFallDistance;
    }

    public static int getParachuteDamageAmount() {
        if (singleUse) {
            return Parachute.parachuteItem.func_77612_l() + 1;
        }
        return 1;
    }

    public static boolean getAADImmediate() {
        return aadImmediate;
    }

    public static boolean getUseSpawnPoint() {
        return useSpawnPoint;
    }

    public static BlockPos getWaypoint() {
        return new BlockPos(waypoint[0], 0, waypoint[1]);
    }
}

