/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.client;

import com.parachute.common.ConfigHandler;
import com.parachute.common.ParachuteCommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HudGuiRenderer
extends Gui {
    protected static final ResourceLocation hudTexture = new ResourceLocation("parachutemod:textures/gui/parachute-hud.png");
    private static FontRenderer fontRenderer;
    public static double altitude;
    private final Minecraft mc = Minecraft.func_71410_x();
    private int blink = 0;
    private final int hudWidth;
    private final int hudHeight;
    private final int ledWidth;
    private final int ledHeight;
    private final int fieldWidth;
    private final int colorYellow;
    private final int colorRed;
    private final int colorGreen;
    private final int colorBlue;
    private final int colorDimBlue;
    private final int colorDimGreen;
    private final int aadWidth;
    private final int aadHeight;
    private final int ledY;
    private final int lightY;
    private final int red;
    private final int darkRed;
    private final int green;
    private final int dark;
    private int blinkX = this.red;
    private final int blinkTime;
    private final int yOffset;
    public static int wayPointX;
    public static int wayPointZ;
    private static boolean wayPointEnabled;

    public HudGuiRenderer() {
        this.hudWidth = 182;
        this.hudHeight = 39;
        this.ledWidth = 11;
        this.ledHeight = 5;
        this.colorYellow = -5592576;
        this.colorRed = -5636096;
        this.colorGreen = -16733696;
        this.colorBlue = -16777046;
        this.colorDimBlue = -872415096;
        this.colorDimGreen = -872380416;
        this.aadWidth = 16;
        this.aadHeight = 25;
        this.ledY = 39;
        this.lightY = 44;
        this.red = 0;
        this.darkRed = 48;
        this.green = 16;
        this.dark = 32;
        this.blinkTime = 5;
        this.yOffset = 14;
        wayPointX = 0;
        wayPointZ = 0;
        wayPointEnabled = false;
        fontRenderer = this.mc.field_71466_p;
        this.fieldWidth = fontRenderer.func_78256_a("000.0") / 2;
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent event) {
        if (event.isCancelable() || this.mc.field_71474_y.field_74330_P || this.mc.field_71439_g.field_70122_E) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(this.mc);
        int hudX = sr.func_78326_a() / 2 - this.hudWidth / 2;
        int hudY = 2;
        int textX = hudX + 30;
        int textY = hudY + 22;
        int ledX = 1;
        if (this.mc.field_71415_G && event.type == RenderGameOverlayEvent.ElementType.ALL && ParachuteCommonProxy.onParachute((EntityPlayer)this.mc.field_71439_g)) {
            this.mc.func_110434_K().func_110577_a(hudTexture);
            BlockPos entityPos = new BlockPos(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.func_174813_aQ().field_72338_b, this.mc.field_71439_g.field_70161_v);
            altitude = this.getCurrentAltitude(entityPos);
            double homeDir = this.getHomeDirection();
            double distance = this.getHomeDistance();
            double heading = (((double)this.mc.field_71439_g.field_70177_z + 180.0) % 360.0 + 360.0) % 360.0;
            this.func_73729_b(hudX, hudY, 0, 0, this.hudWidth, this.hudHeight);
            if (homeDir < -80.0) {
                ledX = 1;
            } else if ((homeDir - 80.0) * (homeDir - -80.0) < 0.0) {
                ledX = (int)Math.floor(homeDir + 80.0 + 4.0);
            } else if (homeDir > 80.0) {
                ledX = 170;
            }
            this.func_73729_b(hudX + ledX, hudY, ledX, this.ledY, this.ledWidth, this.ledHeight);
            int aadIconY = 8;
            int aadIconX = ConfigHandler.getIsAADActive() ? 199 : 182;
            this.func_73729_b(hudX + this.hudWidth + 2, hudY + 8, aadIconX, aadIconY, this.aadWidth, this.aadHeight);
            if (ConfigHandler.isAutoDismount()) {
                this.func_73729_b(hudX - 18, hudY + this.yOffset, this.dark, this.lightY, 16, 16);
            } else if (altitude > 10.0) {
                this.func_73729_b(hudX - 18, hudY + this.yOffset, this.green, this.lightY, 16, 16);
            } else if (altitude <= 10.0 && altitude > 3.0) {
                this.func_73729_b(hudX - 18, hudY + this.yOffset, this.red, this.lightY, 16, 16);
            } else if (altitude <= 3.0) {
                if (this.blink % this.blinkTime == 0) {
                    this.blinkX = this.blinkX == this.red ? this.darkRed : this.red;
                }
                this.func_73729_b(hudX - 18, hudY + this.yOffset, this.blinkX, this.lightY, 16, 16);
                ++this.blink;
            }
            if (wayPointEnabled) {
                double waypointDirection = this.getWaypointDirection(wayPointX, wayPointZ);
                if (waypointDirection < -80.0) {
                    ledX = 1;
                } else if ((waypointDirection - 80.0) * (waypointDirection - -80.0) < 0.0) {
                    ledX = (int)Math.floor(waypointDirection + 80.0 + 4.0);
                } else if (waypointDirection > 80.0) {
                    ledX = 170;
                }
                this.func_73729_b(hudX, hudY + this.hudHeight, 0, 0, this.hudWidth, this.ledHeight);
                this.func_73729_b(hudX + ledX, hudY + this.hudHeight, ledX, this.ledY, this.ledWidth, this.ledHeight);
            }
            fontRenderer.func_175063_a("Altitude", (float)(hudX + 18), (float)(hudY + 12), this.colorDimBlue);
            fontRenderer.func_175063_a(this.format(altitude), (float)(textX + 5 - this.fieldWidth), (float)textY, this.colorAltitude());
            fontRenderer.func_175063_a("Compass", (float)(hudX + 123), (float)(hudY + 12), this.colorDimBlue);
            fontRenderer.func_175063_a(this.format(heading), (float)(textX + 118 - this.fieldWidth), (float)textY, this.colorCompass(heading));
            fontRenderer.func_175063_a(this.format(distance), (float)(textX + 65 - this.fieldWidth), (float)textY, this.colorDimGreen);
        }
    }

    public String format(double d) {
        return String.format("%.1f", d);
    }

    public double getHomeDirection() {
        BlockPos blockpos = ConfigHandler.getUseSpawnPoint() ? this.mc.field_71441_e.func_175694_M() : ConfigHandler.getWaypoint();
        double delta = Math.atan2((double)blockpos.func_177952_p() - this.mc.field_71439_g.field_70161_v, (double)blockpos.func_177958_n() - this.mc.field_71439_g.field_70165_t);
        double relAngle = delta - Math.toRadians(this.mc.field_71439_g.field_70177_z);
        return MathHelper.func_76138_g((double)(Math.toDegrees(relAngle) - 90.0));
    }

    public double getHomeDistance() {
        BlockPos blockpos = ConfigHandler.getUseSpawnPoint() ? this.mc.field_71441_e.func_175694_M() : ConfigHandler.getWaypoint();
        double a = Math.pow((double)blockpos.func_177952_p() - this.mc.field_71439_g.field_70161_v, 2.0);
        double b = Math.pow((double)blockpos.func_177958_n() - this.mc.field_71439_g.field_70165_t, 2.0);
        return Math.sqrt(a + b);
    }

    public int colorAltitude() {
        return altitude <= 10.0 && altitude >= 0.0 ? this.colorRed : (altitude < 0.0 ? this.colorYellow : this.colorGreen);
    }

    public int colorCompass(double d) {
        return d >= 0.0 && d < 45.0 ? this.colorGreen : (d >= 45.0 && d < 135.0 ? this.colorYellow : (d >= 135.0 && d < 225.0 ? this.colorRed : (d >= 225.0 && d < 315.0 ? this.colorBlue : this.colorGreen)));
    }

    public double getCurrentAltitude(BlockPos entityPos) {
        if (this.mc.field_71441_e.field_73011_w.func_76569_d()) {
            BlockPos blockPos = new BlockPos(entityPos.func_177958_n(), entityPos.func_177956_o(), entityPos.func_177952_p());
            while (this.mc.field_71441_e.func_175623_d(blockPos.func_177977_b())) {
                blockPos = blockPos.func_177977_b();
            }
            return entityPos.func_177956_o() - blockPos.func_177956_o();
        }
        return 1000.0 * this.mc.field_71441_e.field_73012_v.nextGaussian();
    }

    public double getWaypointDirection(int waypointX, int waypointZ) {
        BlockPos blockpos = new BlockPos(waypointX, 0, waypointZ);
        double delta = Math.atan2((double)blockpos.func_177952_p() - this.mc.field_71439_g.field_70161_v, (double)blockpos.func_177958_n() - this.mc.field_71439_g.field_70165_t);
        double relAngle = delta - Math.toRadians(this.mc.field_71439_g.field_70177_z);
        return MathHelper.func_76138_g((double)(Math.toDegrees(relAngle) - 90.0));
    }

    public static void setWaypoint(int waypointXIn, int waypointZIn) {
        wayPointX = waypointXIn;
        wayPointZ = waypointZIn;
    }

    public static void enableWaypoint(boolean enabled) {
        wayPointEnabled = enabled;
    }

    public static boolean getEnableWaypoint() {
        return wayPointEnabled;
    }

    public static String getWaypointString() {
        return String.format("%d %d", wayPointX, wayPointZ);
    }
}

