/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.common.ConfigHandler;
import com.parachute.common.Parachute;
import com.parachute.common.ParachuteCommonProxy;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityParachute
extends Entity {
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private double motionFactor;
    private double maxAltitude;
    private boolean allowThermals;
    private boolean lavaThermals;
    private double lavaDistance;
    private double maxThermalRise;
    private double curLavaDistance;
    private boolean allowTurbulence = ConfigHandler.getAllowturbulence();
    private boolean showContrails = ConfigHandler.getShowContrails();
    private boolean autoDismount;
    private boolean dismountInWater;
    static final double drift = 0.004;
    static final double ascend = -0.04;
    private static boolean ascendMode;

    public EntityParachute(World world) {
        super(world);
        this.lavaDistance = ConfigHandler.getMinLavaDistance();
        this.allowThermals = ConfigHandler.getAllowThermals();
        this.maxAltitude = ConfigHandler.getMaxAltitude();
        this.lavaThermals = ConfigHandler.getAllowLavaThermals();
        this.autoDismount = ConfigHandler.isAutoDismount();
        this.dismountInWater = ConfigHandler.getDismountInWater();
        this.maxThermalRise = ConfigHandler.getMaxLavaDistance();
        this.curLavaDistance = this.lavaDistance;
        this.field_70170_p = world;
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 0.0625f);
        this.motionFactor = 0.07;
        ascendMode = false;
        this.func_174810_b(false);
    }

    public EntityParachute(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public static void setAscendMode(boolean mode) {
        ascendMode = mode;
    }

    public void dismountParachute() {
        Entity skyDiver = this.func_184179_bs();
        if (!this.field_70170_p.field_72995_K && skyDiver != null) {
            this.func_184210_p();
            this.killParachute();
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity != this.func_184179_bs() && entity.func_184187_bx() != this) {
            return entity.func_174813_aQ();
        }
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean shouldRiderSit() {
        Entity skyDiver = this.func_184179_bs();
        boolean sitting = false;
        if (skyDiver != null) {
            BlockPos bp = new BlockPos(skyDiver.field_70165_t, skyDiver.func_174813_aQ().field_72338_b - 3.0, skyDiver.field_70161_v);
            sitting = this.field_70170_p.func_180495_p(bp).func_177230_c() != Blocks.field_150350_a;
        }
        return sitting;
    }

    public EnumFacing func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public boolean func_184186_bw() {
        return true;
    }

    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean shouldDismountInWater(Entity pilot) {
        return this.dismountInWater;
    }

    public double func_70042_X() {
        return -ParachuteCommonProxy.getOffsetY();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int inc, boolean teleport) {
        double deltaX = x - this.field_70165_t;
        double deltaY = y - this.field_70163_u;
        double deltaZ = z - this.field_70161_v;
        double magnitude = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (magnitude <= 1.0) {
            return;
        }
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.velocityZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        double adjustedYaw;
        double adjustedVelocity;
        double pilotFeetPos;
        BlockPos bp;
        Entity skyDiver = this.func_184179_bs();
        super.func_70071_h_();
        if (skyDiver == null && !this.field_70170_p.field_72995_K) {
            this.killParachute();
            return;
        }
        double initialVelocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.showContrails && initialVelocity > 0.2) {
            this.generateContrails(initialVelocity);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.autoDismount && skyDiver != null && this.checkForGroundProximity(bp = new BlockPos(skyDiver.field_70165_t, (pilotFeetPos = skyDiver.func_174813_aQ().field_72338_b) - 1.0, skyDiver.field_70161_v))) {
            this.dismountParachute();
            return;
        }
        if (skyDiver != null && skyDiver instanceof EntityLivingBase) {
            EntityLivingBase pilot = (EntityLivingBase)skyDiver;
            double yaw = (double)pilot.field_70177_z + (double)(-pilot.field_70702_br) * 90.0;
            this.field_70159_w += -Math.sin(Math.toRadians(yaw)) * this.motionFactor * 0.05 * ((double)pilot.field_70701_bs * 1.05);
            this.field_70179_y += Math.cos(Math.toRadians(yaw)) * this.motionFactor * 0.05 * ((double)pilot.field_70701_bs * 1.05);
        }
        if ((adjustedVelocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.35) {
            double motionAdj = 0.35 / adjustedVelocity;
            this.field_70159_w *= motionAdj;
            this.field_70179_y *= motionAdj;
            adjustedVelocity = 0.35;
        }
        if (adjustedVelocity > initialVelocity && this.motionFactor < 0.35) {
            this.motionFactor += (0.35 - this.motionFactor) / 35.0;
            if (this.motionFactor > 0.35) {
                this.motionFactor = 0.35;
            }
        } else {
            this.motionFactor -= (this.motionFactor - 0.07) / 35.0;
            if (this.motionFactor < 0.07) {
                this.motionFactor = 0.07;
            }
        }
        this.field_70181_x -= this.currentDescentRate();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.95;
        this.field_70179_y *= 0.99;
        this.field_70125_A = 0.0f;
        double yaw = this.field_70177_z;
        double delta_X = this.field_70169_q - this.field_70165_t;
        double delta_Z = this.field_70166_s - this.field_70161_v;
        if (delta_X * delta_X + delta_Z * delta_Z > 0.001) {
            yaw = Math.toDegrees(Math.atan2(delta_Z, delta_X));
        }
        if ((adjustedYaw = MathHelper.func_76138_g((double)(yaw - (double)this.field_70177_z))) > 20.0) {
            adjustedYaw = 20.0;
        }
        if (adjustedYaw < -20.0) {
            adjustedYaw = -20.0;
        }
        this.field_70177_z = (float)((double)this.field_70177_z + adjustedYaw);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if ((ConfigHandler.getWeatherAffectsDrift() && this.isBadWeather() || this.allowTurbulence) && this.field_70146_Z.nextBoolean()) {
            this.applyTurbulence(this.field_70170_p.func_72911_I());
        }
        if (!this.field_70170_p.field_72995_K && skyDiver != null && skyDiver.field_70128_L) {
            this.killParachute();
        }
        if (skyDiver != null) {
            double dX = this.field_70165_t - this.field_70169_q;
            double dZ = this.field_70161_v - this.field_70166_s;
            int distance = Math.round(MathHelper.func_76133_a((double)(dX * dX + dZ * dZ)) * 100.0f);
            if (skyDiver instanceof EntityPlayer) {
                ((EntityPlayer)skyDiver).func_71064_a((StatBase)Parachute.parachuteDistance, distance);
            }
        }
    }

    public void killParachute() {
        ParachuteCommonProxy.setDeployed(false);
        this.func_70106_y();
    }

    public boolean isBadWeather() {
        BlockPos bp = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Chunk chunk = this.field_70170_p.func_175726_f(bp);
        boolean canSnow = chunk.func_177411_a(bp, this.field_70170_p.field_73011_w.func_177499_m()).func_76746_c();
        boolean canRain = chunk.func_177411_a(bp, this.field_70170_p.field_73011_w.func_177499_m()).func_76727_i() > 0.0f;
        return !(!canRain && !canSnow || !this.field_70170_p.func_72896_J() && !this.field_70170_p.func_72911_I());
    }

    private double currentDescentRate() {
        double descentRate = 0.004;
        if (ConfigHandler.getWeatherAffectsDrift()) {
            if (this.field_70170_p.func_72896_J()) {
                descentRate += 0.002;
            }
            if (this.field_70170_p.func_72911_I()) {
                descentRate += 0.004;
            }
        }
        if (!this.allowThermals && !this.lavaThermals) {
            return descentRate;
        }
        if (this.lavaThermals) {
            descentRate = this.doHeatSourceThermals();
            if (!this.allowThermals) {
                return descentRate;
            }
        }
        if (ascendMode) {
            descentRate = -0.04;
        }
        if (this.maxAltitude > 0.0 && this.field_70163_u >= this.maxAltitude) {
            descentRate = 0.004;
        }
        return descentRate;
    }

    private boolean isHeatSource(BlockPos bp) {
        Block block = this.field_70170_p.func_180495_p(bp).func_177230_c();
        return this.field_70170_p.func_147470_e(new AxisAlignedBB(bp).func_72314_b(0.0, 1.0, 0.0));
    }

    private boolean isHeatSourceInRange(BlockPos bp) {
        BlockPos blockpos;
        Vec3d v1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d v2 = new Vec3d((double)bp.func_177958_n(), (double)bp.func_177956_o(), (double)bp.func_177952_p());
        RayTraceResult mop = this.field_70170_p.func_72901_a(v1, v2, true);
        return mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && this.isHeatSource(blockpos = mop.func_178782_a());
    }

    private double doHeatSourceThermals() {
        double thermals = 0.004;
        double inc = 0.5;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.field_70163_u - ParachuteCommonProxy.getOffsetY() - this.maxThermalRise, this.field_70161_v);
        if (this.isHeatSourceInRange(blockPos)) {
            this.curLavaDistance += 0.5;
            thermals = -0.04;
            if (this.curLavaDistance >= this.maxThermalRise) {
                this.curLavaDistance = this.lavaDistance;
                thermals = 0.004;
            }
        } else {
            this.curLavaDistance = this.lavaDistance;
        }
        return thermals;
    }

    public boolean checkForGroundProximity(BlockPos bp) {
        Block block = this.field_70170_p.func_180495_p(bp).func_177230_c();
        boolean isAir = block == Blocks.field_150350_a;
        boolean isVegetation = block instanceof BlockFlower || block instanceof BlockGrass || block instanceof BlockLeaves;
        return !isAir && !isVegetation;
    }

    public void applyTurbulence(boolean roughWeather) {
        double rmin = 0.1;
        double deltaPos = rmin + 0.9 * this.field_70146_Z.nextDouble();
        if (deltaPos >= 0.2) {
            double rmax = roughWeather ? 0.8 : 0.5;
            rmax = this.field_70146_Z.nextInt(5) == 0 ? 1.0 : rmax;
            double deltaX = rmin + (rmax - rmin) * this.field_70146_Z.nextDouble();
            double deltaY = rmin + 0.2 * this.field_70146_Z.nextDouble();
            double deltaZ = rmin + (rmax - rmin) * this.field_70146_Z.nextDouble();
            deltaPos = MathHelper.func_76133_a((double)deltaPos);
            double deltaInv = 1.0 / deltaPos;
            deltaX /= deltaPos;
            deltaY /= deltaPos;
            deltaZ /= deltaPos;
            if (deltaInv > 1.0) {
                deltaInv = 1.0;
            }
            deltaX *= deltaInv;
            deltaY *= deltaInv;
            deltaZ *= deltaInv;
            deltaX *= 0.05;
            deltaY *= 0.05;
            deltaZ *= 0.05;
            if (this.field_70146_Z.nextBoolean()) {
                this.func_70024_g(-deltaX, -deltaY, -deltaZ);
            } else {
                this.func_70024_g(deltaX, deltaY, deltaZ);
            }
        }
    }

    public void generateContrails(double velocity) {
        double cosYaw = 2.0 * Math.cos(Math.toRadians(this.field_70177_z));
        double sinYaw = 2.0 * Math.sin(Math.toRadians(this.field_70177_z));
        int k = 0;
        while ((double)k < 1.0 + velocity) {
            double sign = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
            double x = this.field_70169_q - cosYaw * -0.35 + sinYaw * sign;
            double y = this.field_70163_u - 0.25;
            double z = this.field_70166_s - sinYaw * -0.35 - cosYaw * sign;
            this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, x, y, z, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            ++k;
        }
    }

    public void func_184232_k(Entity skydiver) {
        if (skydiver != null) {
            double x = this.field_70165_t + Math.cos(Math.toRadians(this.field_70177_z)) * 0.04;
            double y = this.field_70163_u + this.func_70042_X() + skydiver.func_70033_W();
            double z = this.field_70161_v + Math.sin(Math.toRadians(this.field_70177_z)) * 0.04;
            skydiver.func_70107_b(x, y, z);
            skydiver.func_181013_g(this.field_70177_z + 90.0f);
            skydiver.func_70034_d(this.field_70177_z + 90.0f);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
    }

    public void func_70037_a(NBTTagCompound nbt) {
    }

    public String toString() {
        return String.format("%s: {x=%.1f, y=%.1f, z=%.1f}, {yaw=%.1f, pitch=%.1f}", ((Object)((Object)this)).getClass().getSimpleName(), this.field_70165_t, this.field_70163_u, this.field_70161_v, Float.valueOf(this.field_70177_z), Float.valueOf(this.field_70125_A));
    }
}

