/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.client.RenderParachute;
import com.parachute.common.ConfigHandler;
import com.parachute.common.EntityParachute;
import com.parachute.common.Parachute;
import com.parachute.common.ParachuteCommonProxy;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemParachute
extends Item {
    private static boolean active;

    public ItemParachute() {
        this.func_77656_e(Item.ToolMaterial.IRON.func_77997_a());
        this.field_77777_bU = 4;
        active = ConfigHandler.getIsAADActive();
        this.func_77637_a(CreativeTabs.field_78029_e);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer, EnumHand hand) {
        boolean result = entityplayer != null && ParachuteCommonProxy.isFalling(entityplayer) && entityplayer.func_184187_bx() == null ? this.deployParachute(world, entityplayer) : this.toggleAAD(itemstack, world, entityplayer);
        return new ActionResult(result ? EnumActionResult.SUCCESS : EnumActionResult.PASS, (Object)itemstack);
    }

    public boolean deployParachute(World world, EntityPlayer entityplayer) {
        double offset = ParachuteCommonProxy.getOffsetY();
        EntityParachute chute = new EntityParachute(world, entityplayer.field_70165_t, entityplayer.field_70163_u + offset, entityplayer.field_70161_v);
        chute.field_70177_z = entityplayer.field_70177_z - 90.0f;
        float volume = 1.0f;
        chute.func_184185_a(ParachuteCommonProxy.openChute, volume, this.pitch());
        if (world.field_72995_K) {
            RenderParachute.setParachuteColor(ConfigHandler.getChuteColor());
        } else {
            world.func_72838_d((Entity)chute);
        }
        entityplayer.func_184220_m((Entity)chute);
        ParachuteCommonProxy.setDeployed(true);
        entityplayer.func_71064_a((StatBase)Parachute.parachuteDeployed, 1);
        ItemStack itemstack = null;
        Iterable heldEquipment = entityplayer.func_184214_aD();
        for (ItemStack itemStack : heldEquipment) {
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemParachute)) continue;
            itemstack = itemStack;
        }
        if (itemstack != null) {
            boolean enchanted;
            boolean bl = enchanted = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"unbreaking"), itemstack) > 0;
            if (!entityplayer.field_71075_bZ.field_75098_d || !enchanted) {
                itemstack.func_77972_a(ConfigHandler.getParachuteDamageAmount(), (EntityLivingBase)entityplayer);
            }
        }
        return true;
    }

    public boolean toggleAAD(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K && entityplayer != null) {
            active = !active;
            itemstack.func_151001_c(active ? "Parachute|AAD" : "Parachute");
            ConfigHandler.setAADState(active);
        } else if (world.field_72995_K && entityplayer != null) {
            world.func_184133_a(entityplayer, new BlockPos(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v), SoundEvents.field_187909_gi, SoundCategory.MASTER, 1.0f, 1.0f);
        } else {
            return false;
        }
        return true;
    }

    private float pitch() {
        return 1.0f / (field_77697_d.nextFloat() * 0.4f + 0.8f);
    }

    public boolean func_82789_a(ItemStack itemstack1, ItemStack itemstack2) {
        return Items.field_151007_F == itemstack2.func_77973_b() || super.func_82789_a(itemstack1, itemstack2);
    }
}

