/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.common.ConfigHandler;
import com.parachute.common.EntityParachute;
import com.parachute.common.ItemParachute;
import com.parachute.common.ItemParachutePack;
import com.parachute.common.PacketHandler;
import com.parachute.common.Parachute;
import com.parachute.common.ParachuteItemCraftedEvent;
import com.parachute.common.PlayerFallEvent;
import com.parachute.common.PlayerLoginHandler;
import com.parachute.common.PlayerMountEvent;
import com.parachute.common.PlayerTickEventHandler;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParachuteCommonProxy {
    private static final Logger logger = LogManager.getLogger((String)"parachutemod");
    public static final EntityEquipmentSlot armorType = EntityEquipmentSlot.CHEST;
    private static final String parachuteName = "parachute";
    private static final String packName = "pack";
    private static boolean deployed = false;
    private static final double offsetY = 2.5;
    public static SoundEvent openChute;
    public static SoundEvent burnChute;
    protected static ModelResourceLocation parachuteResource;
    protected static ModelResourceLocation packResource;

    public void preInit(FMLPreInitializationEvent event) {
        int entityID = 1;
        EntityRegistry.registerModEntity(EntityParachute.class, (String)parachuteName, (int)entityID, (Object)Parachute.instance, (int)80, (int)3, (boolean)true);
        Parachute.parachuteItem = (Item)new ItemParachute().func_77655_b(parachuteName).setRegistryName((ResourceLocation)parachuteResource);
        GameRegistry.register((IForgeRegistryEntry)Parachute.parachuteItem);
        boolean renderIndex = false;
        Parachute.packItem = (Item)new ItemParachutePack(ItemArmor.ArmorMaterial.LEATHER, 0, armorType).func_77655_b(packName).setRegistryName((ResourceLocation)packResource);
        GameRegistry.register((IForgeRegistryEntry)Parachute.packItem);
        GameRegistry.register((IForgeRegistryEntry)new SoundEvent(new ResourceLocation("parachutemod:chuteopen")).setRegistryName("chuteopen"));
        openChute = ParachuteCommonProxy.getRegisteredSoundEvent("parachutemod:chuteopen");
        GameRegistry.register((IForgeRegistryEntry)new SoundEvent(new ResourceLocation("parachutemod:burn")).setRegistryName("burn"));
        burnChute = ParachuteCommonProxy.getRegisteredSoundEvent("parachutemod:burn");
        PacketHandler.init();
    }

    public void Init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)Parachute.instance);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTickEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerFallEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ParachuteItemCraftedEvent());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerMountEvent());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerLoginHandler());
        GameRegistry.addRecipe((ItemStack)new ItemStack(Parachute.parachuteItem, 1), (Object[])new Object[]{"###", "X X", " L ", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('L'), Items.field_151116_aA});
        Parachute.buildParachute = new Achievement("achievement.buildParachute", "buildParachute", 0, 0, Parachute.parachuteItem, AchievementList.field_187984_h);
        Parachute.buildParachute.func_75971_g();
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("Parachute", new Achievement[]{Parachute.buildParachute}));
        Parachute.parachuteDeployed.func_75971_g();
        Parachute.parachuteDistance.func_75966_h().func_75971_g();
        int fv = ForgeVersion.getBuildVersion();
        if (fv < 1928) {
            StatList.field_75940_b.add(Parachute.parachuteDeployed);
            StatList.field_75940_b.add(Parachute.parachuteDistance);
            this.info("Forge Version is " + fv + ", manually registered parachute stats.");
        } else {
            this.info("Forge Version is " + fv + ", Forge auto registered parachute stats.");
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void info(String s) {
        logger.info(s);
    }

    public void error(String s) {
        logger.error(s);
    }

    public static boolean getAutoActivateAltitude(EntityPlayer player) {
        boolean altitudeReached = false;
        double altitude = ConfigHandler.getAADAltitude();
        double minFallDistance = ConfigHandler.getMinFallDistance();
        BlockPos blockPos = new BlockPos(player.field_70165_t, player.field_70163_u - altitude, player.field_70161_v);
        if (!player.field_70170_p.func_175623_d(blockPos) && (double)player.field_70143_R > minFallDistance) {
            altitudeReached = true;
        }
        return altitudeReached;
    }

    public static boolean canActivateAADImmediate(EntityPlayer player) {
        double minFallDistance = ConfigHandler.getMinFallDistance();
        return (double)player.field_70143_R > minFallDistance;
    }

    public static boolean isFalling(EntityPlayer player) {
        return player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_();
    }

    public static boolean onParachute(EntityPlayer entity) {
        return entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityParachute;
    }

    public static void setDeployed(boolean isDeployed) {
        deployed = isDeployed;
    }

    public static boolean isDeployed() {
        return deployed;
    }

    public static double getOffsetY() {
        return 2.5;
    }

    private static SoundEvent getRegisteredSoundEvent(String id) {
        SoundEvent soundevent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(id));
        if (soundevent == null) {
            throw new IllegalStateException("Invalid Sound requested: " + id);
        }
        return soundevent;
    }

    static {
        parachuteResource = new ModelResourceLocation("parachutemod:parachute");
        packResource = new ModelResourceLocation("parachutemod:pack");
    }
}

