/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.client;

import com.parachute.client.ParachuteTexturedQuad;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import org.lwjgl.opengl.GL11;

public class ParachuteModelRenderer {
    private ParachuteTexturedQuad[] faces;
    private final int left;
    private final int top;
    private float rotationPointX;
    private float rotationPointY;
    private float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled = false;
    private int displayList = 0;
    private boolean mirror = false;
    private boolean showModel = true;
    private float textureWidth = 64.0f;
    private float textureHeight = 32.0f;

    public ParachuteModelRenderer(int x, int y) {
        this.left = x;
        this.top = y;
        this.setTextureSize(this.textureWidth, this.textureHeight);
    }

    public void addBox(float x, float y, float z, float w, float h, float d) {
        PositionTextureVertex[] corners = new PositionTextureVertex[8];
        this.faces = new ParachuteTexturedQuad[6];
        float width = x + w;
        float height = y + h;
        float depth = z + d;
        if (this.mirror) {
            float tmp = width;
            width = x;
            x = tmp;
        }
        corners[0] = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
        corners[1] = new PositionTextureVertex(width, y, z, 0.0f, 8.0f);
        corners[2] = new PositionTextureVertex(width, height, z, 8.0f, 8.0f);
        corners[3] = new PositionTextureVertex(x, height, z, 8.0f, 0.0f);
        corners[4] = new PositionTextureVertex(x, y, depth, 0.0f, 0.0f);
        corners[5] = new PositionTextureVertex(width, y, depth, 0.0f, 8.0f);
        corners[6] = new PositionTextureVertex(width, height, depth, 8.0f, 8.0f);
        corners[7] = new PositionTextureVertex(x, height, depth, 8.0f, 0.0f);
        int r1 = (int)(w > 16.0f ? 16.0f : w);
        int r2 = (int)(d > 16.0f ? 16.0f : d);
        int bottom = (int)(h > 16.0f ? 16.0f : h);
        this.faces[0] = new ParachuteTexturedQuad(new PositionTextureVertex[]{corners[5], corners[1], corners[2], corners[6]}, this.left, this.top, this.left + r1, this.top + bottom);
        this.faces[1] = new ParachuteTexturedQuad(new PositionTextureVertex[]{corners[0], corners[4], corners[7], corners[3]}, this.left, this.top, this.left + r1, this.top + bottom);
        this.faces[2] = new ParachuteTexturedQuad(new PositionTextureVertex[]{corners[5], corners[4], corners[0], corners[1]}, this.left, this.top, this.left + r1, this.top + r2);
        this.faces[3] = new ParachuteTexturedQuad(new PositionTextureVertex[]{corners[2], corners[3], corners[7], corners[6]}, this.left, this.top, this.left + r1, this.top + r2);
        this.faces[4] = new ParachuteTexturedQuad(new PositionTextureVertex[]{corners[1], corners[0], corners[3], corners[2]}, this.left, this.top, this.left + r1, this.top + bottom);
        this.faces[5] = new ParachuteTexturedQuad(new PositionTextureVertex[]{corners[4], corners[5], corners[6], corners[7]}, this.left, this.top, this.left + r1, this.top + bottom);
        if (this.mirror) {
            for (ParachuteTexturedQuad face : this.faces) {
                face.flipFace();
            }
        }
    }

    public void setRotationPoint(float x, float y, float z) {
        this.rotationPointX = x;
        this.rotationPointY = y;
        this.rotationPointZ = z;
    }

    public void render(float scale) {
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(scale);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
            if (this.rotateAngleZ != 0.0f) {
                GlStateManager.func_179114_b((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GlStateManager.func_179114_b((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GlStateManager.func_179114_b((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179148_o((int)this.displayList);
            GlStateManager.func_179121_F();
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
            GlStateManager.func_179148_o((int)this.displayList);
            GlStateManager.func_179109_b((float)(-this.rotationPointX * scale), (float)(-this.rotationPointY * scale), (float)(-this.rotationPointZ * scale));
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179148_o((int)this.displayList);
            GlStateManager.func_179121_F();
        }
    }

    public void renderWithRotation(float f) {
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        if (this.rotateAngleY != 0.0f) {
            GlStateManager.func_179114_b((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rotateAngleX != 0.0f) {
            GlStateManager.func_179114_b((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.rotateAngleZ != 0.0f) {
            GlStateManager.func_179114_b((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179148_o((int)this.displayList);
        GlStateManager.func_179121_F();
    }

    public void postRender(float f) {
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GlStateManager.func_179114_b((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GlStateManager.func_179114_b((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GlStateManager.func_179114_b((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179121_F();
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            GlStateManager.func_179121_F();
        }
    }

    private void compileDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        VertexBuffer vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        for (ParachuteTexturedQuad face : this.faces) {
            face.draw(vertexBuffer, scale);
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public final ParachuteModelRenderer setTextureSize(float width, float height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }
}

