/*
 * Decompiled with CFR 0.152.
 */
package assets.airi.src.assets.manager;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.swing.JOptionPane;

public class AIRiProtocolManager {
    public static void initialize(String protocolLstURL, String cprotocolFilename, String cprotocolLstFilename) {
        if (AIRiProtocolManager.getExternalInternetProtocol() == "000.000.000.000" || AIRiProtocolManager.getExternalInternetProtocol() == null) {
            try {
                if (AIRiProtocolManager.readFromFile(cprotocolLstFilename).contains(AIRiProtocolManager.readFromFile(cprotocolFilename))) {
                    AIRiProtocolManager.shutdownClient();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            AIRiProtocolManager.saveFileFromURL(protocolLstURL, cprotocolLstFilename);
            AIRiProtocolManager.writeLineToFile(cprotocolFilename, AIRiProtocolManager.getExternalInternetProtocol());
            AIRiProtocolManager.checkRemoteUser(protocolLstURL);
            AIRiProtocolManager.checkRemoteInternetProtocol(protocolLstURL);
        }
    }

    public static void checkRemoteUser(String URL2) {
        atv client = FMLClientHandler.instance().getClient();
        try {
            String URLData = AIRiProtocolManager.getStringFromURL(URL2);
            if (client.U.a != null && URLData.contains(client.U.a)) {
                AIRiProtocolManager.shutdownClient();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkRemoteInternetProtocol(String URL2) {
        atv client = FMLClientHandler.instance().getClient();
        try {
            String URLData = AIRiProtocolManager.getStringFromURL(URL2);
            if (URLData.contains(AIRiProtocolManager.getExternalInternetProtocol())) {
                AIRiProtocolManager.shutdownClient();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeLineToFile(String filename, String line) {
        try {
            PrintWriter write = new PrintWriter(filename);
            write.println(line);
            write.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(String filename) {
        String string;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                br.close();
                throw throwable;
            }
            catch (Exception exception) {
                return "";
            }
        }
        br.close();
        return string;
    }

    public static String getExternalInternetProtocol() {
        try {
            URL url = new URL("http://checkip.amazonaws.com");
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            return in.readLine();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "000.000.000.000";
    }

    public static String getStringFromURL(String var1) throws Exception {
        String inputLine;
        URL website = new URL(var1);
        URLConnection connection = website.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public static void saveFileFromURL(String url, String filename) {
        try {
            URL website = new URL(url);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(filename);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void shutdownClient() {
        atv client = FMLClientHandler.instance().getClient();
        AIRiProtocolManager.showMessage("Your system's internet protocol and in-game username have been blacklisted. Please uninstall AIRI to access the game. \nIf you think this was a mistake, please contact the Arisux team at http://ri5ux.weebly.com", "AIRI: Error");
        client.f();
    }

    public static void showMessage(String infoMessage, String location) {
        JOptionPane.showMessageDialog(null, infoMessage, location, 1);
    }
}

