/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.airi.client.render;

import java.lang.reflect.Constructor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderSpawnerItem
implements IItemRenderer {
    protected ModelBase model;
    private ResourceLocation resourceINV;
    private String mobName;
    private String classPackage;
    private float scale;
    private float y;
    private ResourceLocation resourceLocation;

    public RenderSpawnerItem(Class<?> entity, ResourceLocation resourceLocation, float scale, float y) {
        this(entity, resourceLocation, scale);
        this.y = y;
    }

    public RenderSpawnerItem(Class<?> entity, ResourceLocation resourceLocation, float scale) {
        this.scale = scale;
        this.mobName = entity.getSimpleName().replace("Model", "");
        this.classPackage = entity.getName().replace(".Model" + this.mobName, "");
        this.resourceLocation = resourceLocation;
        try {
            Class<?> clazz = Class.forName(this.classPackage + "." + "Model" + this.mobName);
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            this.model = (ModelBase)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: {
                return false;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                GL11.glPushMatrix();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.resourceLocation);
                GL11.glDisable((int)2884);
                GL11.glRotatef((float)195.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-18.0f, (float)(2.77f + this.y), (float)10.85f);
                GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
                this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GL11.glPopMatrix();
                break;
            }
            case INVENTORY: {
                GL11.glPushMatrix();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.resourceLocation);
                GL11.glDisable((int)2884);
                GL11.glRotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-8.0f, (float)(5.77f + this.y), (float)-20.85f);
                GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
                this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GL11.glPopMatrix();
                break;
            }
        }
    }
}

