/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.airi.dependencies;

import com.arisux.airi.dependencies.PlayerRendererInfo;
import com.arisux.avp.AliensVsPredator;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.input.Keyboard;

public abstract class ItemRenderer3D
implements IItemRenderer {
    private ModelBase model;
    private ResourceLocation resource;
    private boolean refresh;
    private boolean rendersInFirstPerson = true;
    private boolean rendersInThirdPerson = true;
    private boolean rendersInInventory = true;
    private PlayerRendererInfo renderer;
    private int ticksPassed;

    public ItemRenderer3D() {
        AliensVsPredator.instance().getClientTickHandler().getPlayerRendererInfo().add(this.renderer);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: {
                return this.rendersInThirdPerson;
            }
            case EQUIPPED_FIRST_PERSON: {
                return this.rendersInFirstPerson;
            }
            case INVENTORY: {
                return this.rendersInInventory;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (Keyboard.isKeyDown((int)61) && Keyboard.isKeyDown((int)19)) {
            this.setRefresh(true);
        } else {
            this.setRefresh(false);
        }
        switch (type) {
            case EQUIPPED: {
                this.renderThirdPerson(item, 1.0f, data);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderFirstPerson(item, 1.0f, data);
                break;
            }
            case INVENTORY: {
                this.renderInInventory(item, 1.0f, data);
            }
        }
    }

    public abstract void renderThirdPerson(ItemStack var1, float var2, Object ... var3);

    public abstract void renderFirstPerson(ItemStack var1, float var2, Object ... var3);

    public abstract void renderInInventory(ItemStack var1, float var2, Object ... var3);

    public boolean canRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void setModel(ModelBase model) {
        this.model = model;
    }

    public void setResource(ResourceLocation resource) {
        this.resource = resource;
    }

    public ModelBase getModel() {
        return this.model;
    }

    public void setRendersInThirdPerson(boolean rendersInThirdPerson) {
        this.rendersInThirdPerson = rendersInThirdPerson;
    }

    public void setRendersInFirstPerson(boolean rendersInFirstPerson) {
        this.rendersInFirstPerson = rendersInFirstPerson;
    }

    public void setRendersInInventory(boolean rendersInInventory) {
        this.rendersInInventory = rendersInInventory;
    }
}

