/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.airi.dependencies;

import com.arisux.airi.dependencies.AIRIEntityBullet;
import com.arisux.airi.dependencies.AIRIItemAmmo;
import com.arisux.airi.dependencies.AIRIUtil;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AIRIItemFireArm
extends Item {
    private AIRIItemAmmo itemAmmo;
    private float recoil;
    private double curCooldown;
    private double curCooldownClient;
    private double maxCooldown;
    private int curAmmo;
    private int maxAmmo;
    private int maxReload;
    private int curReload;
    private String sound;

    public AIRIItemFireArm(float recoil, double fireRate, int reloadSpeed, AIRIItemAmmo item, String snd, String ico) {
        this.field_77777_bU = 1;
        this.sound = snd;
        this.recoil = recoil;
        this.itemAmmo = item;
        this.maxAmmo = this.itemAmmo.getMaxCapacity();
        this.curAmmo = 0;
        this.maxReload = reloadSpeed;
        this.curReload = 0;
        this.maxCooldown = fireRate;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        this.curCooldown -= 1.0;
        --this.curReload;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par2World.field_72995_K && this.curAmmo > 0 && this.curCooldown <= 0.0 && this.curReload <= 0 || par2World.field_72995_K && par3EntityPlayer.field_71075_bZ.field_75098_d) {
            this.renderRecoil();
            this.fixDelay();
        }
        if (par3EntityPlayer.field_71071_by.func_70431_c(new ItemStack((Item)this.itemAmmo)) && this.curAmmo <= 0 && this.curReload <= 0) {
            AIRIUtil.consumeItem(par3EntityPlayer, this.itemAmmo);
            this.curAmmo = this.maxAmmo;
            this.curReload = this.maxReload;
        }
        if (this.curAmmo > 0 && this.curCooldown <= 0.0 && this.curReload <= 0 || par3EntityPlayer.field_71075_bZ.field_75098_d) {
            par2World.func_72838_d((Entity)new AIRIEntityBullet(par2World, (EntityLivingBase)par3EntityPlayer, 15.0f, (double)this.itemAmmo.getInflictionDamage()));
            par2World.func_72908_a(par3EntityPlayer.field_70165_t, par3EntityPlayer.field_70163_u, par3EntityPlayer.field_70161_v, this.sound, 1.0f, 1.0f);
            this.curCooldown = this.maxCooldown;
            if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
                --this.curAmmo;
            }
        }
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRecoil() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        mc.field_71439_g.field_71155_g -= this.recoil * 40.0f;
        mc.field_71439_g.field_71154_f += this.recoil * 5.0f;
        mc.field_71439_g.field_70125_A -= this.recoil * 1.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public void fixDelay() {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            mc.field_71460_t.field_78516_c.field_78454_c = 0.85f;
            mc.field_71467_ac = (int)this.maxCooldown;
        }
        catch (Exception e) {
            FMLLog.warning((String)"WARNING: AliensVsPredator attempted to access fields that are not visible.", (Object[])new Object[0]);
        }
    }

    public boolean getCanFire(EntityPlayer player) {
        return this.curAmmo > 0 && this.curCooldown <= 0.0 && this.curReload <= 0 || player.field_71075_bZ.field_75098_d;
    }

    public int getMaxAmmo() {
        return this.maxAmmo;
    }

    public int getCurrentAmmo() {
        return this.curAmmo;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add("Left click to aim, Right click to fire.");
    }
}

