/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client;

import com.arisux.mdxlib.lib.client.gui.GuiCustomTextbox;
import com.arisux.mdxlib.lib.client.gui.IGuiElement;
import com.arisux.mdxlib.lib.client.render.Screen;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import javax.vecmath.Vector2d;
import org.lwjgl.input.Mouse;

public class GUIElementTracker {
    public static final GUIElementTracker instance = new GUIElementTracker();
    private ArrayList<IGuiElement> guiElements = new ArrayList();
    private boolean canRelease;

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Vector2d mousePosition = Screen.scaledMousePosition();
            for (int x = 0; x < this.guiElements.size(); ++x) {
                IGuiElement element = this.guiElements.get(x);
                element.updateElement();
                if (element == null || !element.canTrackInput() || !element.isMouseInElement(mousePosition)) continue;
                if (Mouse.isButtonDown((int)0)) {
                    if (!this.canRelease) {
                        if (element instanceof GuiCustomTextbox) {
                            for (int ti = 0; ti < this.guiElements.size(); ++ti) {
                                IGuiElement te = this.guiElements.get(ti);
                                if (!(te instanceof GuiCustomTextbox) || te == element) continue;
                                GuiCustomTextbox textbox = (GuiCustomTextbox)te;
                                textbox.setFocused(false);
                            }
                        }
                        element.mousePressed(mousePosition);
                        this.canRelease = true;
                        continue;
                    }
                    element.mouseDragged(mousePosition);
                    continue;
                }
                if (!this.canRelease) continue;
                this.canRelease = false;
                element.mouseReleased(mousePosition);
            }
        }
    }

    public void track(IGuiElement element) {
        this.stopTracking(element);
        if (!this.guiElements.contains(element)) {
            this.guiElements.add(element);
        }
    }

    public void stopTracking(IGuiElement element) {
        if (this.guiElements.contains(element)) {
            this.guiElements.remove(element);
        }
    }
}

