/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client;

import com.arisux.mdxlib.MDX;
import com.arisux.mdxlib.lib.game.Game;
import com.arisux.mdxlib.lib.util.MDXMath;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

@SideOnly(value=Side.CLIENT)
public abstract class Model
extends ModelBase {
    public static final float DEFAULT_SCALE = 0.0625f;

    public void setTextureDimensions(int textureWidth, int textureHeight) {
        this.field_78090_t = textureWidth;
        this.field_78089_u = textureHeight;
    }

    public void setRotation(ModelRenderer model, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        model.field_78795_f = rotateAngleX;
        model.field_78796_g = rotateAngleY;
        model.field_78808_h = rotateAngleZ;
    }

    public static void draw(ModelRenderer modelRenderer) {
        modelRenderer.func_78785_a(0.0625f);
    }

    public static void draw(ModelRenderer[] group) {
        for (ModelRenderer child : group) {
            Model.draw(child);
        }
    }

    public void render() {
        this.render(null);
    }

    public void render(Object obj) {
    }

    public void func_78088_a(Entity entity, float swing, float swingPrev, float idle, float headYaw, float headPitch, float scale) {
        this.render(entity);
    }

    public void func_78087_a(float swing, float swingPrev, float idle, float headYaw, float headPitch, float scale, Entity entity) {
    }

    public void func_78086_a(EntityLivingBase entityLiving, float swingProgress, float swingProgressPrev, float renderPartialTicks) {
    }

    public static ModelRenderer[] group(ModelRenderer ... children) {
        return children;
    }

    public static ModelBase createModelBase(Class<? extends ModelBase> modelClass) {
        try {
            return modelClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            MDX.log().warn("Error creating new model instance.");
            e.printStackTrace();
            return null;
        }
    }

    public static Model createExtendedModelBase(Class<? extends Model> modelClass) {
        try {
            return modelClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            MDX.log().warn("Error creating new model instance.");
            e.printStackTrace();
            return null;
        }
    }

    public static ModelBase getMainModel(RendererLivingEntity renderer) {
        return MDX.access().getMainModel(renderer);
    }

    public static float getIdleProgress(EntityLivingBase base) {
        return (float)base.field_70173_aa + Game.partialTicks();
    }

    public static float getSwingProgress(EntityLivingBase base) {
        return base.field_70754_ba - base.field_70721_aZ * (1.0f - Game.partialTicks());
    }

    public static float getSwingProgressPrev(EntityLivingBase base) {
        return base.field_70722_aY + (base.field_70721_aZ - base.field_70722_aY) * Game.partialTicks();
    }

    public static float getHeadYaw(EntityLivingBase base) {
        float yawOffset = MDXMath.interpolateRotation(base.field_70760_ar, base.field_70761_aq, Game.partialTicks());
        float yawHead = MDXMath.interpolateRotation(base.field_70758_at, base.field_70759_as, Game.partialTicks());
        return yawHead - yawOffset;
    }

    public static float getHeadPitch(EntityLivingBase base) {
        return base.field_70127_C + (base.field_70125_A - base.field_70127_C) * Game.partialTicks();
    }

    public static float idleProgress(Object o) {
        if (o != null && o instanceof EntityLivingBase) {
            return Model.getIdleProgress((EntityLivingBase)o);
        }
        return 0.0f;
    }

    public static float swingProgress(Object o) {
        if (o != null && o instanceof EntityLivingBase) {
            return Model.getSwingProgress((EntityLivingBase)o);
        }
        return 0.0f;
    }

    public static float swingProgressPrev(Object o) {
        if (o != null && o instanceof EntityLivingBase) {
            return Model.getSwingProgressPrev((EntityLivingBase)o);
        }
        return 0.0f;
    }

    public static float headYaw(Object o) {
        if (o != null && o instanceof EntityLivingBase) {
            return Model.getHeadYaw((EntityLivingBase)o);
        }
        return 0.0f;
    }

    public static float headPitch(Object o) {
        if (o != null && o instanceof EntityLivingBase) {
            return Model.getHeadPitch((EntityLivingBase)o);
        }
        return 0.0f;
    }
}

