/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client;

import com.arisux.mdxlib.lib.world.Pos;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class Sound {
    private String key;
    private float volume;
    private float pitch;
    private boolean distanceDelay;

    public Sound(String key) {
        this(key, 1.0f, 1.0f);
    }

    public Sound(String key, float volume) {
        this(key, volume, 1.0f);
    }

    public Sound(String key, float volume, float pitch) {
        this.key = key;
        this.volume = volume;
        this.pitch = pitch;
        this.distanceDelay = true;
    }

    public Sound setDistanceDelay(boolean distanceDelay) {
        this.distanceDelay = distanceDelay;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public float getVolume() {
        return this.volume;
    }

    private void setReflectedVolume(Float volume) {
        this.volume = volume.floatValue();
    }

    public Sound setVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public float getPitch() {
        return this.pitch;
    }

    public Sound setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public String toString() {
        return this.getKey();
    }

    public void playSound(Entity entity) {
        this.playSound(entity, this.volume, this.pitch);
    }

    public void playSound(Entity entity, float volume, float pitch) {
        entity.func_85030_a(this.key, volume, pitch);
    }

    public void playSound(World world, Pos data) {
        this.playSound(world, (int)data.x, (int)data.y, (int)data.z, this.volume, this.pitch);
    }

    public void playSound(World world, Pos data, float volume, float pitch) {
        this.playSound(world, (int)data.x, (int)data.y, (int)data.z, volume, pitch);
    }

    public void playSound(World world, double posX, double posY, double posZ) {
        this.playSound(world, (int)posX, (int)posY, (int)posZ, this.volume, this.pitch);
    }

    public void playSound(World world, int posX, int posY, int posZ) {
        this.playSound(world, posX, posY, posZ, this.volume, this.pitch);
    }

    public void playSound(World world, double posX, double posY, double posZ, float volume, float pitch) {
        this.playSound(world, (int)posX, (int)posY, (int)posZ, volume, pitch, this.distanceDelay);
    }

    public void playSound(World world, int posX, int posY, int posZ, float volume, float pitch) {
        this.playSound(world, posX, posY, posZ, volume, pitch, this.distanceDelay);
    }

    public void playSound(World world, int posX, int posY, int posZ, float volume, float pitch, boolean distanceDelay) {
        world.func_72980_b((double)posX, (double)posY, (double)posZ, this.key, volume, pitch, distanceDelay);
    }
}

