/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.gui;

import com.arisux.mdxlib.lib.client.GUIElementTracker;
import com.arisux.mdxlib.lib.client.gui.GuiCustomScreen;
import com.arisux.mdxlib.lib.client.gui.IAction;
import com.arisux.mdxlib.lib.client.gui.IGuiElement;
import com.arisux.mdxlib.lib.client.render.Draw;
import com.arisux.mdxlib.lib.client.render.OpenGL;
import com.arisux.mdxlib.lib.game.Game;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.vecmath.Vector2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiCustomTextbox
implements IGuiElement {
    protected IAction action;
    protected GuiCustomScreen parentScreen;
    protected String text;
    protected String textPrev;
    protected String tooltip;
    protected boolean trackInput;
    protected boolean isRendered;
    protected boolean enableBackgroundDrawing;
    protected boolean canLoseFocus;
    protected boolean isFocused;
    protected boolean isEnabled;
    protected boolean visible;
    protected long lastRendered;
    protected int xPosition;
    protected int yPosition;
    protected int width;
    protected int height;
    protected int maxStringLength;
    protected int cursorCounter;
    protected int lineScrollOffset;
    protected int cursorPosition;
    protected int selectionEnd;
    protected int textColor;
    protected int textColorDisabled;
    protected int backgroundColor;
    protected int borderColor;

    public GuiCustomTextbox(GuiCustomScreen parentScreen, int x, int y, int width, int height) {
        this(x, y, width, height);
        this.parentScreen = parentScreen;
        this.parentScreen.customTextfieldList.add(this);
    }

    public GuiCustomTextbox(int x, int y, int width, int height) {
        this.xPosition = x;
        this.yPosition = y;
        this.width = width;
        this.height = height;
        this.trackInput = true;
        this.xPosition = x;
        this.yPosition = y;
        this.width = width;
        this.height = height;
        this.maxStringLength = 32;
        this.enableBackgroundDrawing = true;
        this.canLoseFocus = true;
        this.textColor = 0xE0E0E0;
        this.textColorDisabled = 0x707070;
        this.backgroundColor = 0x44000000;
        this.borderColor = 0;
        this.visible = true;
        this.isEnabled = true;
        this.text = "";
        this.trackElement();
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text.length() > this.maxStringLength ? text.substring(0, this.maxStringLength) : text;
        this.setCursorPositionEnd();
        int pos = this.xPosition + this.width;
        if (this.getEnableBackgroundDrawing()) {
            pos -= 4;
        }
        int lineScrollOffset = 0;
        String s = Minecraft.func_71410_x().field_71466_p.func_78269_a(text.substring(lineScrollOffset), this.width);
        this.setCursorPosition(Minecraft.func_71410_x().field_71466_p.func_78269_a(s, pos).length());
    }

    @Override
    public void updateElement() {
        if (this.isRendered()) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public String getSelectedText() {
        int start = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int end = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(start, end);
    }

    public void writeText(String text) {
        int l;
        String s1 = "";
        String s2 = ChatAllowedCharacters.func_71565_a((String)text);
        int start = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int end = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int r = this.maxStringLength - this.text.length() - (start - this.selectionEnd);
        if (this.text.length() > 0) {
            s1 = s1 + this.text.substring(0, start);
        }
        if (r < s2.length()) {
            s1 = s1 + s2.substring(0, r);
            l = r;
        } else {
            s1 = s1 + s2;
            l = s2.length();
        }
        if (this.text.length() > 0 && end < this.text.length()) {
            s1 = s1 + this.text.substring(end);
        }
        this.text = s1;
        this.moveCursorBy(start - this.selectionEnd + l);
    }

    public void deleteWords(int words) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(words) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int offset) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = offset < 0;
                int j = flag ? this.cursorPosition + offset : this.cursorPosition;
                int k = flag ? this.cursorPosition : this.cursorPosition + offset;
                String s = "";
                if (j >= 0) {
                    s = this.text.substring(0, j);
                }
                if (k < this.text.length()) {
                    s = s + this.text.substring(k);
                }
                this.text = s;
                if (flag) {
                    this.moveCursorBy(offset);
                }
            }
        }
    }

    public int getNthWordFromCursor(int position) {
        return this.getNthWordFromPos(position, this.getCursorPosition());
    }

    public int getNthWordFromPos(int position, int position2) {
        return this.getWord(position, position2, true);
    }

    public int getWord(int position, int cursorPos, boolean p_146197_3_) {
        int pos = cursorPos;
        boolean flag1 = position < 0;
        for (int i1 = 0; i1 < Math.abs(position); ++i1) {
            if (flag1) {
                while (p_146197_3_ && pos > 0 && this.text.charAt(pos - 1) == ' ') {
                    --pos;
                }
                while (pos > 0 && this.text.charAt(pos - 1) != ' ') {
                    --pos;
                }
                continue;
            }
            int j1 = this.text.length();
            if ((pos = this.text.indexOf(32, pos)) == -1) {
                pos = j1;
                continue;
            }
            while (p_146197_3_ && pos < j1 && this.text.charAt(pos) == ' ') {
                ++pos;
            }
        }
        return pos;
    }

    public void moveCursorBy(int offset) {
        this.setCursorPosition(this.selectionEnd + offset);
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = position;
        int j = this.text.length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > j) {
            this.cursorPosition = j;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    protected void selectAll() {
        this.setCursorPositionEnd();
        this.setSelectionPos(0);
    }

    protected void copy() {
        GuiScreen.func_146275_d((String)this.getSelectedText());
    }

    protected void paste() {
        this.textPrev = this.text;
        if (this.isEnabled) {
            this.writeText(GuiScreen.func_146277_j());
        }
    }

    protected void cut() {
        this.textPrev = this.text;
        GuiScreen.func_146275_d((String)this.getSelectedText());
        if (this.isEnabled) {
            this.writeText("");
        }
    }

    protected void undo() {
        if (this.textPrev != null && !this.textPrev.isEmpty()) {
            String newText = this.textPrev;
            this.textPrev = this.text;
            this.setText(newText);
        }
    }

    public boolean textboxKeyTyped(char c, int key) {
        if (!this.isFocused) {
            return false;
        }
        switch (c) {
            case '\u0001': {
                this.selectAll();
                return true;
            }
            case '\u0003': {
                this.copy();
                return true;
            }
            case '\u0016': {
                this.paste();
                return true;
            }
            case '\u0018': {
                this.cut();
                return true;
            }
            case '\u001a': {
                this.undo();
                return true;
            }
        }
        switch (key) {
            case 14: {
                this.textPrev = this.text;
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled) {
                        this.deleteWords(-1);
                    }
                } else if (this.isEnabled) {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return true;
            }
            case 211: {
                this.textPrev = this.text;
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled) {
                        this.deleteWords(1);
                    }
                } else if (this.isEnabled) {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)c)) {
            if (this.isEnabled) {
                this.writeText(Character.toString(c));
            }
            return true;
        }
        return false;
    }

    public void mouseClicked(int mouseX, int mouseY, int i) {
        boolean flag;
        boolean bl = flag = mouseX >= this.xPosition && mouseX < this.xPosition + this.width && mouseY >= this.yPosition && mouseY < this.yPosition + this.height;
        if (this.canLoseFocus) {
            this.setFocused(flag);
        }
        if (this.isFocused && i == 0) {
            int l = mouseX - this.xPosition;
            if (this.enableBackgroundDrawing) {
                l -= 4;
            }
            String s = Game.fontRenderer().func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
            this.setCursorPosition(Game.fontRenderer().func_78269_a(s, l).length() + this.lineScrollOffset);
        }
    }

    public void drawTextBox() {
        if (this.getVisible()) {
            if (this.getEnableBackgroundDrawing()) {
                Draw.drawRectWithOutline(this.xPosition, this.yPosition, this.width, this.height, 1, this.backgroundColor, this.borderColor);
            }
            int color = this.isEnabled ? this.textColor : this.textColorDisabled;
            int pos = this.cursorPosition - this.lineScrollOffset;
            int end = this.selectionEnd - this.lineScrollOffset;
            String textboxText = Game.fontRenderer().func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
            boolean flag = pos >= 0 && pos <= textboxText.length();
            boolean cursorActive = this.isFocused && this.cursorCounter / 6 % 2 == 0 && flag;
            int padding = this.enableBackgroundDrawing ? this.xPosition + 4 : this.xPosition;
            int cursorHeight = this.enableBackgroundDrawing ? this.yPosition + (this.height - 8) / 2 : this.yPosition;
            int cursorPosX = padding;
            if (end > textboxText.length()) {
                end = textboxText.length();
            }
            if (textboxText.length() > 0) {
                String s1 = flag ? textboxText.substring(0, pos) : textboxText;
                cursorPosX = Game.fontRenderer().func_78261_a(s1, padding, cursorHeight, color);
            }
            boolean selectCursor = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
            int cursorWidth = cursorPosX;
            if (!flag) {
                cursorWidth = pos > 0 ? padding + this.width : padding;
            } else if (selectCursor) {
                cursorWidth = cursorPosX - 1;
                --cursorPosX;
            }
            if (textboxText.length() > 0 && flag && pos < textboxText.length()) {
                Game.fontRenderer().func_78261_a(textboxText.substring(pos), cursorPosX, cursorHeight, color);
            }
            if (cursorActive) {
                if (selectCursor) {
                    Gui.func_73734_a((int)cursorWidth, (int)(cursorHeight - 1), (int)(cursorWidth + 1), (int)(cursorHeight + 1 + Game.fontRenderer().field_78288_b), (int)-3092272);
                } else {
                    Game.fontRenderer().func_78261_a("_", cursorWidth, cursorHeight, color);
                }
            }
            if (end != pos) {
                int l1 = padding + Game.fontRenderer().func_78256_a(textboxText.substring(0, end));
                this.drawCursorVertical(cursorWidth, cursorHeight - 1, l1 - 1, cursorHeight + 1 + Game.fontRenderer().field_78288_b);
            }
        }
        this.lastRendered = System.currentTimeMillis();
    }

    protected void drawCursorVertical(int x, int y, int w, int h) {
        int i1;
        if (x < w) {
            i1 = x;
            x = w;
            w = i1;
        }
        if (y < h) {
            i1 = y;
            y = h;
            h = i1;
        }
        if (w > this.xPosition + this.width) {
            w = this.xPosition + this.width;
        }
        if (x > this.xPosition + this.width) {
            x = this.xPosition + this.width;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        OpenGL.color(0.0f, 0.0f, 255.0f, 255.0f);
        OpenGL.disableTexture2d();
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x, (double)h, 0.0);
        tessellator.func_78377_a((double)w, (double)h, 0.0);
        tessellator.func_78377_a((double)w, (double)y, 0.0);
        tessellator.func_78377_a((double)x, (double)y, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3058);
        OpenGL.enableTexture2d();
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
        }
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void setEnableBackgroundDrawing(boolean backgroundDrawing) {
        this.enableBackgroundDrawing = backgroundDrawing;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setDisabledTextColour(int color) {
        this.textColorDisabled = color;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public void setFocused(boolean focused) {
        if (focused && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = focused;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getWidth() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int pos) {
        int textLength = this.text.length();
        if (pos > textLength) {
            pos = textLength;
        }
        if (pos < 0) {
            pos = 0;
        }
        this.selectionEnd = pos;
        if (Game.fontRenderer() != null) {
            if (this.lineScrollOffset > textLength) {
                this.lineScrollOffset = textLength;
            }
            String trimmedString = Game.fontRenderer().func_78269_a(this.text.substring(this.lineScrollOffset), this.width);
            int trimmedPos = trimmedString.length() + this.lineScrollOffset;
            if (pos == this.lineScrollOffset) {
                this.lineScrollOffset -= Game.fontRenderer().func_78262_a(this.text, this.width, true).length();
            }
            if (pos > trimmedPos) {
                this.lineScrollOffset += pos - trimmedPos;
            } else if (pos <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - pos;
            }
            if (this.lineScrollOffset < 0) {
                this.lineScrollOffset = 0;
            }
            if (this.lineScrollOffset > textLength) {
                this.lineScrollOffset = textLength;
            }
        }
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void mousePressed(Vector2d mousePosition) {
        this.mouseClicked((int)mousePosition.x, (int)mousePosition.y, 0);
    }

    @Override
    public void mouseReleased(Vector2d mousePosition) {
    }

    @Override
    public void mouseDragged(Vector2d mousePosition) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public long lastRenderTime() {
        return this.lastRendered;
    }

    @Override
    public boolean isRendered() {
        long currentTime = System.currentTimeMillis();
        if (currentTime > 100L && this.lastRenderTime() > 100L) {
            return currentTime - this.lastRenderTime() < 500L;
        }
        return false;
    }

    @Override
    public void trackElement() {
        GUIElementTracker.instance.track(this);
    }

    @Override
    public void stopTracking() {
        GUIElementTracker.instance.stopTracking(this);
    }

    @Override
    public boolean isMouseInElement(Vector2d mousePosition) {
        int mouseX = (int)mousePosition.x;
        int mouseY = (int)mousePosition.y;
        return this.isEnabled() && this.getVisible() && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    @Override
    public boolean canTrackInput() {
        return this.isEnabled() && this.trackInput && this.getVisible();
    }

    @Override
    public boolean setTrackInput(boolean trackInput) {
        this.trackInput = trackInput;
        return this.trackInput;
    }

    @Override
    public IAction getAction() {
        return this.action;
    }

    @Override
    public IGuiElement setAction(IAction action) {
        this.action = action;
        return this;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public int x() {
        return this.xPosition;
    }

    @Override
    public int y() {
        return this.yPosition;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public void setX(int x) {
        this.xPosition = x;
    }

    @Override
    public void setY(int y) {
        this.yPosition = y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }
}

