/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.render;

import com.arisux.mdxlib.lib.world.block.BlockSide;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public class IconSet {
    public IIcon defaultIcon;
    public String resourceDefault;

    public IconSet(String resourceDefault) {
        this.resourceDefault = resourceDefault;
    }

    public IconSet(IIcon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public void registerIcons(IIconRegister register) {
        this.defaultIcon = register.func_94245_a(this.resourceDefault);
    }

    public IIcon getIconForSide(int side) {
        BlockSide iconSide = BlockSide.getSide(side);
        switch (iconSide) {
            default: 
        }
        return this.defaultIcon;
    }

    public static class BlockIconSet
    extends IconSet {
        public IIcon top;
        public IIcon bottom;
        public IIcon front;
        public IIcon back;
        public IIcon left;
        public IIcon right;
        public String resourceTop;
        public String resourceBottom;
        public String resourceFront;
        public String resourceBack;
        public String resourceLeft;
        public String resourceRight;

        public BlockIconSet(String icon, String top, String bottom, String front, String back, String left, String right) {
            super(icon);
            this.resourceTop = top;
            this.resourceBottom = bottom;
            this.resourceFront = front;
            this.resourceBack = back;
            this.resourceLeft = left;
            this.resourceRight = right;
        }

        public BlockIconSet(IIcon icon, IIcon top, IIcon bottom, IIcon front, IIcon back, IIcon left, IIcon right) {
            super(icon);
            this.top = top;
            this.bottom = bottom;
            this.front = front;
            this.back = back;
            this.left = left;
            this.right = right;
        }

        @Override
        public void registerIcons(IIconRegister register) {
            super.registerIcons(register);
            this.top = register.func_94245_a(this.resourceTop == null ? this.resourceDefault : this.resourceTop);
            this.bottom = register.func_94245_a(this.resourceBottom == null ? this.resourceDefault : this.resourceBottom);
            this.front = register.func_94245_a(this.resourceFront == null ? this.resourceDefault : this.resourceFront);
            this.back = register.func_94245_a(this.resourceBack == null ? this.resourceDefault : this.resourceBack);
            this.left = register.func_94245_a(this.resourceLeft == null ? this.resourceDefault : this.resourceLeft);
            this.right = register.func_94245_a(this.resourceRight == null ? this.resourceDefault : this.resourceRight);
        }

        @Override
        public IIcon getIconForSide(int side) {
            BlockSide iconSide = BlockSide.getSide(side);
            switch (iconSide) {
                case BOTTOM: {
                    return this.bottom;
                }
                case TOP: {
                    return this.top;
                }
                case BACK: {
                    return this.back;
                }
                case FRONT: {
                    return this.front;
                }
                case LEFT: {
                    return this.left;
                }
                case RIGHT: {
                    return this.right;
                }
            }
            return this.bottom;
        }
    }

    public static class LiquidIconSet
    extends IconSet {
        public IIcon flowing;
        public IIcon still;
        public String resourceFlowing;
        public String resourceStill;

        public LiquidIconSet(String icon, String flowing, String still) {
            super(icon);
            this.resourceFlowing = flowing;
            this.resourceStill = still;
        }

        public LiquidIconSet(IIcon icon, IIcon flowing, IIcon still) {
            super(icon);
            this.flowing = flowing;
            this.still = still;
        }

        @Override
        public void registerIcons(IIconRegister register) {
            super.registerIcons(register);
            this.defaultIcon = register.func_94245_a(this.resourceDefault);
            this.flowing = register.func_94245_a(this.resourceFlowing == null ? this.resourceDefault : this.resourceFlowing);
            this.still = register.func_94245_a(this.resourceStill == null ? this.resourceDefault : this.resourceStill);
        }

        @Override
        public IIcon getIconForSide(int side) {
            switch (side) {
                case 0: {
                    return this.still;
                }
                case 1: {
                    return this.still;
                }
            }
            return this.flowing;
        }
    }
}

