/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.render;

import com.arisux.mdxlib.MDX;
import com.arisux.mdxlib.lib.client.render.OpenGL;
import com.arisux.mdxlib.lib.client.render.ScaledResolution;
import com.arisux.mdxlib.lib.game.Game;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.vecmath.Vector2d;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class Screen {
    public static ScaledResolution scaledDisplayResolution() {
        return new ScaledResolution(Game.minecraft(), Game.minecraft().field_71443_c, Game.minecraft().field_71440_d);
    }

    public static Vector2d scaledMousePosition() {
        int scaledWidth = Screen.scaledDisplayResolution().getScaledWidth();
        int scaledHeight = Screen.scaledDisplayResolution().getScaledHeight();
        int mouseX = Mouse.getX() * scaledWidth / Game.minecraft().field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Game.minecraft().field_71440_d - 1;
        return new Vector2d((double)mouseX, (double)mouseY);
    }

    public static Dimension displayResolution() {
        Minecraft mc = Game.minecraft();
        return new Dimension(mc.field_71443_c, mc.field_71440_d);
    }

    public static Point getMouseLocation() {
        ScaledResolution size = Screen.scaledDisplayResolution();
        Dimension res = Screen.displayResolution();
        return new Point(Mouse.getX() * size.getScaledWidth() / res.width, size.getScaledHeight() - Mouse.getY() * size.getScaledHeight() / res.height - 1);
    }

    public static void saveScreenshot(String filename, int x, int y, int width, int height) {
        File file = new File(Game.minecraft().field_71412_D.getPath());
        MDX.log().info("Saving screenshot to " + file.getPath());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (Game.minecraft().field_71456_v != null && Keyboard.isKeyDown((int)61) && Keyboard.isKeyDown((int)22)) {
            try {
                OpenGL.readBuffer(1028);
                int bpp = 4;
                ByteBuffer pixels = BufferUtils.createByteBuffer((int)(width * height * bpp));
                OpenGL.readPixels(x, y, width, height, 6408, 5121, pixels);
                String format = "png";
                BufferedImage image = new BufferedImage(width, height, 1);
                for (int px = x; px < width; ++px) {
                    for (int py = y; py < height; ++py) {
                        int i = (px + width * py) * bpp;
                        int r = pixels.get(i) & 0xFF;
                        int g = pixels.get(i + 1) & 0xFF;
                        int b = pixels.get(i + 2) & 0xFF;
                        image.setRGB(px, height - (py + 1), 0xFF000000 | r << 16 | g << 8 | b);
                    }
                }
                ImageIO.write((RenderedImage)image, format, new File(file, filename));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

