/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.render.wavefront;

import com.arisux.mdxlib.MDX;
import com.arisux.mdxlib.lib.client.render.Color;
import com.arisux.mdxlib.lib.client.render.Normal;
import com.arisux.mdxlib.lib.client.render.UV;
import com.arisux.mdxlib.lib.client.render.Vertex;
import com.arisux.mdxlib.lib.client.render.wavefront.Face;
import com.arisux.mdxlib.lib.client.render.wavefront.FaceGroup;
import com.arisux.mdxlib.lib.client.render.wavefront.Part;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import net.minecraft.util.ResourceLocation;

public class TriangulatedWavefrontModel {
    private String pathName;
    private String mtlName;
    private String modid;
    private String directory;
    public ArrayList<Vertex> vertex = new ArrayList();
    public ArrayList<UV> uv = new ArrayList();
    public Hashtable<String, Part> parts = new Hashtable();
    public Hashtable<String, String> strings = new Hashtable();
    public float xDim;
    public float yDim;
    public float zDim;
    public float xMin;
    public float yMin;
    public float zMin;
    public float xMax;
    public float yMax;
    public float zMax;
    public float dimMax;
    public float dimMaxInv;

    public ResourceLocation getAlternativeTexture(String name) {
        ResourceLocation resource = new ResourceLocation(this.modid, this.directory.substring(1) + name);
        return resource;
    }

    public boolean load(String modid, String path) {
        File fileModel = new File(path + ".obj");
        File fileTexture = new File(path + ".mtl");
        File fileOrigins = new File(path + ".ori");
        int lastSlashId = path.lastIndexOf(47);
        this.modid = modid;
        this.directory = path.substring(0, lastSlashId + 1);
        this.pathName = path.substring(lastSlashId + 1, path.length());
        Part part = null;
        FaceGroup fg = null;
        try {
            this.loadModel(fileModel, path, part, fg);
            part = null;
            this.loadMaterials(fileTexture, path);
            part = null;
        }
        catch (Exception e) {
            MDX.log().warn(String.format("[WavefrontAPI] Error loading model for mod with id %s: %s", modid, path));
            e.printStackTrace();
            return false;
        }
        try {
            this.loadOrigins(fileOrigins, part);
        }
        catch (Exception e) {
            MDX.log().warn(String.format("[WavefrontAPI] Error (%s) loading origins for model for mod with id %s: %s", e, modid, path));
        }
        this.xDim = this.xMax - this.xMin;
        this.yDim = this.yMax - this.yMin;
        this.zDim = this.zMax - this.zMin;
        this.dimMax = Math.max(Math.max(this.xMax, this.yMax), this.zMax);
        this.dimMaxInv = 1.0f / this.dimMax;
        MDX.log().info(String.format("[WavefrontAPI] Loaded wavefront model for mod with id %s: %s", this.modid, this.pathName));
        return true;
    }

    private boolean loadModel(File fileModel, String path, Part part, FaceGroup group) throws Exception {
        String line;
        FileInputStream stream = new FileInputStream(fileModel);
        if (stream == null || fileModel == null || path == null) {
            MDX.log().warn("OBJ Loading Failed: " + path);
            ((InputStream)stream).close();
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
        while ((line = bufferedReader.readLine()) != null) {
            String[] words = line.split(" ");
            String command = words[0];
            if (command.equals("o")) {
                part = new Part(this.vertex, this.uv);
                this.parts.put(words[1], part);
                continue;
            }
            if (command.equals("v")) {
                Vertex v = new Vertex(Float.parseFloat(words[1]), Float.parseFloat(words[2]), Float.parseFloat(words[3]));
                part.addVertex(v);
                this.xMin = Math.min(this.xMin, v.x);
                this.yMin = Math.min(this.yMin, v.y);
                this.zMin = Math.min(this.zMin, v.z);
                this.xMax = Math.max(this.xMax, v.x);
                this.yMax = Math.max(this.yMax, v.y);
                this.zMax = Math.max(this.zMax, v.z);
                continue;
            }
            if (command.equals("vt")) {
                part.getUV().add(new UV(Float.parseFloat(words[1]), 1.0f - Float.parseFloat(words[2])));
                continue;
            }
            if (command.equals("f")) {
                int vertexNbr = words.length - 1;
                if (vertexNbr != 3) continue;
                Vertex[] verticeId = new Vertex[vertexNbr];
                UV[] uvId = new UV[vertexNbr];
                for (int idx = 0; idx < vertexNbr; ++idx) {
                    String[] id = words[idx + 1].split("/");
                    verticeId[idx] = part.getVertices().get(Integer.parseInt(id[0]) - 1);
                    uvId[idx] = id.length > 1 && !id[1].equals("") ? part.getUV().get(Integer.parseInt(id[1]) - 1) : null;
                }
                group.faces.add(new Face(verticeId, uvId, new Normal(verticeId[0], verticeId[1], verticeId[2])));
                continue;
            }
            if (command.equals("mtllib")) {
                this.mtlName = words[1];
                continue;
            }
            if (!command.equals("usemtl")) continue;
            group = new FaceGroup();
            group.material = words[1];
            if (part == null || part.groups == null) continue;
            part.groups.add(group);
        }
        bufferedReader.close();
        return true;
    }

    private boolean loadMaterials(File fileTexture, String path) throws Exception {
        String line;
        FileInputStream stream = new FileInputStream(fileTexture);
        System.out.println("Loading MTL: " + fileTexture);
        if (stream == null || fileTexture == null || path == null) {
            MDX.log().warn("MTL Loading failed: " + path);
            ((InputStream)stream).close();
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
        String mtlName = "";
        while ((line = bufferedReader.readLine()) != null) {
            String[] args = line.split(" ");
            String command = args[0];
            if (command.equals("newmtl")) {
                mtlName = args[1];
                continue;
            }
            if (command.equals("map_Kd")) {
                for (Part partPtr : this.parts.values()) {
                    for (FaceGroup faceGroup : partPtr.groups) {
                        if (faceGroup.material == null || !faceGroup.material.equals(mtlName)) continue;
                        faceGroup.resource = new ResourceLocation(this.modid, "models/" + this.directory + args[1]);
                    }
                }
                continue;
            }
            if (!command.equals("Kd")) continue;
            for (Part partPtr : this.parts.values()) {
                for (FaceGroup faceGroup : partPtr.groups) {
                    if (faceGroup.material == null || !faceGroup.material.equals(mtlName)) continue;
                    faceGroup.color = new Color(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]), 1.0f);
                }
            }
        }
        bufferedReader.close();
        return true;
    }

    private void loadOrigins(File fileOrigins, Part part) throws Exception {
        FileInputStream stream = new FileInputStream(fileOrigins);
        if (stream != null) {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
            while ((line = bufferedReader.readLine()) != null) {
                String[] words = line.split(" ");
                String command = words[0];
                if (command.equals("o")) {
                    part = this.parts.get(words[1]);
                    continue;
                }
                if (command.equals("f")) {
                    String key = words[1];
                    float value = Float.valueOf(words[2]).floatValue();
                    if (key.equals("originX")) {
                        part.setOriginX(value);
                        continue;
                    }
                    if (key.equals("originY")) {
                        part.setOriginY(value);
                        continue;
                    }
                    if (key.equals("originZ")) {
                        part.setOriginZ(value);
                        continue;
                    }
                    if (key.equals("originX2")) {
                        part.setOriginX2(value);
                        continue;
                    }
                    if (key.equals("originY2")) {
                        part.setOriginY2(value);
                        continue;
                    }
                    if (key.equals("originZ2")) {
                        part.setOriginZ2(value);
                        continue;
                    }
                    part.floats.put(key, Float.valueOf(value));
                    continue;
                }
                if (!command.equals("s")) continue;
                this.strings.put(words[1], words[2]);
            }
            bufferedReader.close();
        }
    }

    public void draw(String part) {
        Part partPtr = this.getPart(part);
        if (partPtr != null) {
            partPtr.draw();
        }
    }

    public Part getPart(String part) {
        return this.parts.get(part);
    }

    public String getString(String name) {
        return this.strings.get(name);
    }

    public String getMtlName() {
        return this.mtlName;
    }

    public static boolean renderPart(String modelName, String partName) {
        Part part = TriangulatedWavefrontModel.getPart(modelName, partName);
        if (part != null) {
            part.draw();
            return true;
        }
        return false;
    }

    public static Part getPart(String modelName, String partName) {
        TriangulatedWavefrontModel model = MDX.getWavefrontModel(modelName);
        return model != null ? model.getPart(partName) : null;
    }
}

