/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class LargeExplosion {
    private int x;
    private int y;
    private int z;
    private int rX;
    private int rY;
    private int rZ;
    private int erb;
    private int erm;
    private float damage;
    private World worldObj;
    private Random random;
    private ArrayList<Block> excludedBlocks;
    private ArrayList<Material> excludedMaterials;
    private static final ArrayList<Block> excludeDefault = new ArrayList();

    public LargeExplosion(World worldObj, double rX, double rY, double rZ, int x, int y, int z, long seed) {
        this(worldObj, rX, rY, rZ, x, y, z, 1000.0f, seed, excludeDefault);
    }

    public LargeExplosion(World worldObj, double rX, double rY, double rZ, int x, int y, int z, float damage, long seed) {
        this(worldObj, rX, rY, rZ, x, y, z, damage, seed, excludeDefault);
    }

    public LargeExplosion(World worldObj, double rX, double rY, double rZ, int x, int y, int z, float damage, long seed, ArrayList<Block> exclude) {
        this(worldObj, rX, rY, rZ, x, y, z, damage, seed, excludeDefault, null, 0, 0);
    }

    public LargeExplosion(World worldObj, double rX, double rY, double rZ, int x, int y, int z, float damage, long seed, ArrayList<Block> excludedBlocks, ArrayList<Material> excludedMaterials, int erb, int erm) {
        this.worldObj = worldObj;
        this.x = x;
        this.y = y;
        this.z = z;
        this.rX = (int)Math.ceil(rX);
        this.rY = (int)Math.ceil(rY);
        this.rZ = (int)Math.ceil(rZ);
        this.damage = damage;
        this.random = new Random(seed);
        this.excludedBlocks = excludedBlocks;
        this.excludedMaterials = excludedMaterials;
        this.erb = erb;
        this.erm = erm;
    }

    public void process() {
        this.rX = (int)((double)this.rX + 0.5);
        this.rY = (int)((double)this.rY + 0.5);
        this.rZ = (int)((double)this.rZ + 0.5);
        int size = (this.rX + this.rY + this.rZ) / 3 / 2;
        for (int idx = 0; idx <= size; ++idx) {
            float scale = 1.0f - 1.0f / (float)size;
            this.rX = Math.round((float)this.rX * scale);
            this.rY = Math.round((float)this.rY * scale);
            this.rZ = Math.round((float)this.rZ * scale);
            double x1 = 0.0;
            for (int posX = 0; posX <= this.rX; ++posX) {
                double x2 = x1;
                x1 = (double)(posX + 1) * (1.0 / (double)this.rX);
                block2: for (int posY = 0; posY <= this.rY; ++posY) {
                    double y1 = 0.0;
                    double y2 = (double)(posY + 1) * (1.0 / (double)this.rY);
                    double z2 = 0.0;
                    for (int posZ = 0; posZ <= this.rZ; ++posZ) {
                        double z1 = z2;
                        z2 = (double)(posZ + 1) * (1.0 / (double)this.rZ);
                        if (this.sq(x2, y1, z1) > 1.0 && posZ == 0 && posY == 0) continue block2;
                        if (!(this.sq(x1, y1, z1) <= 1.0) || !(this.sq(x2, y2, z1) <= 1.0) || !(this.sq(x2, y1, z2) <= 1.0)) continue;
                        this.pos(posX, posY, posZ);
                        this.pos(-posX, posY, posZ);
                        this.pos(posX, -posY, posZ);
                        this.pos(posX, posY, -posZ);
                        this.pos(-posX, -posY, posZ);
                        this.pos(posX, -posY, -posZ);
                        this.pos(-posX, posY, -posZ);
                        this.pos(-posX, -posY, -posZ);
                    }
                }
            }
        }
    }

    public void start() {
        this.process();
        this.worldObj.func_72908_a((double)this.x, (double)this.y, (double)this.z, "random.old_explode", 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        List entities = this.worldObj.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)this.x - (double)this.rX), (double)((double)this.y - (double)this.rY), (double)((double)this.z - (double)this.rY), (double)((double)this.x + (double)this.rY), (double)((double)this.y + (double)this.rY), (double)((double)this.z + (double)this.rY)));
        for (int idx = 0; idx < entities.size(); ++idx) {
            ((Entity)entities.get(idx)).func_70097_a(DamageSource.field_76377_j.func_94540_d(), this.damage);
        }
    }

    private final double sq(double posX, double posY, double posZ) {
        return posX * posX + posY * posY + posZ * posZ;
    }

    private final void pos(double posX, double posY, double posZ) {
        int dX = (int)posX + this.x;
        int dY = (int)posY + this.y;
        int dZ = (int)posZ + this.z;
        Block block = this.worldObj.func_147439_a(dX, dY, dZ);
        if (this.excludedBlocks != null && this.excludedBlocks.contains(block) && (this.erb > 0 && this.random.nextInt(this.erb) == 0 || this.erb == 0) || block == Blocks.field_150350_a) {
            return;
        }
        if (this.excludedMaterials != null && this.excludedMaterials.contains(block.func_149688_o()) && (this.erm > 0 && this.random.nextInt(this.erm) == 0 || this.erm == 0)) {
            return;
        }
        block.func_149723_a(this.worldObj, dX, dY, dZ, new Explosion(this.worldObj, null, (double)dX, (double)dY, (double)dZ, 1.0f));
        this.worldObj.func_147468_f(dX, dY, dZ);
    }

    static {
        excludeDefault.add(Blocks.field_150357_h);
    }
}

