/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world;

import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class Pos {
    public double x;
    public double y;
    public double z;
    private IStorable stored;

    public Pos(Entity entity) {
        this(Math.round(entity.field_70165_t), Math.round(entity.field_70163_u), Math.round(entity.field_70161_v));
    }

    public Pos(TileEntity tileEntity) {
        this(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public Pos(double posX, double posY, double posZ) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
    }

    public Pos(long posX, long posY, long posZ) {
        this((double)posX, (double)posY, (double)posZ);
    }

    public Pos(float posX, float posY, float posZ) {
        this((double)posX, (double)posY, (double)posZ);
    }

    public Pos(int posX, int posY, int posZ) {
        this((double)posX, (double)posY, (double)posZ);
    }

    public Pos store(IStorable store) {
        this.stored = store;
        return this;
    }

    public boolean equals(Object o) {
        Pos test;
        return o != null && o instanceof Pos && (this == (test = (Pos)o) || test.x == this.x && test.y == this.y && test.z == this.z);
    }

    public int hashCode() {
        int result = (int)this.x;
        result = 31 * result + (int)this.y;
        result = 31 * result + (int)this.z;
        return result;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Block getBlock(World world) {
        return world.func_147439_a((int)this.x, (int)this.y, (int)this.z);
    }

    public int getBlockMetadata(World world) {
        return world != null ? world.func_72805_g((int)this.x, (int)this.y, (int)this.z) : 0;
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o((int)this.x, (int)this.y, (int)this.z);
    }

    public Pos min(Pos data) {
        return new Pos(Math.min(this.x, data.x), Math.min(this.y, data.y), Math.min(this.z, data.z));
    }

    public Pos max(Pos data) {
        return new Pos(Math.max(this.x, data.x), Math.max(this.y, data.y), Math.max(this.z, data.z));
    }

    public Pos add(Pos data) {
        return new Pos(this.x + data.x, this.y + data.y, this.z + data.z);
    }

    public Pos add(double posX, double posY, double posZ) {
        return this.add(new Pos(posX, posY, posZ));
    }

    public Pos subtract(Pos data) {
        return new Pos(this.max((Pos)data).x - this.min((Pos)data).x, this.max((Pos)data).y - this.min((Pos)data).y, this.max((Pos)data).z - this.min((Pos)data).z);
    }

    public Pos subtract(double posX, double posY, double posZ) {
        return this.add(new Pos(posX, posY, posZ));
    }

    public Pos offsetX(double amount) {
        this.x += amount;
        return this;
    }

    public Pos offsetY(double amount) {
        this.y += amount;
        return this;
    }

    public Pos offsetZ(double amount) {
        this.z += amount;
        return this;
    }

    public NBTTagCompound writeToNBT() {
        return this.writeToNBT(null);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt, "Id", "PosX", "PosY", "PosZ");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt, String labelId, String labelX, String labelY, String labelZ) {
        NBTTagCompound dataTag;
        NBTTagCompound nBTTagCompound = dataTag = nbt == null ? new NBTTagCompound() : nbt;
        if (this.stored != null && this.stored instanceof IStorable && this.stored instanceof BlockDataStore) {
            BlockDataStore blockdata = (BlockDataStore)this.stored;
            dataTag.func_74778_a(labelId, blockdata.toString());
        }
        dataTag.func_74780_a(labelX, this.x);
        dataTag.func_74780_a(labelY, this.y);
        dataTag.func_74780_a(labelZ, this.z);
        return dataTag;
    }

    public Pos readFromNBT(NBTTagCompound nbt) {
        return this.readFromNBT(nbt, "Id", "PosX", "PosY", "PosZ");
    }

    public Pos readFromNBT(NBTTagCompound nbt, String labelId, String labelX, String labelY, String labelZ) {
        return this.readFromNBT(nbt, labelId, labelX, labelY, labelZ, "Meta");
    }

    public Pos readFromNBT(NBTTagCompound nbt, String labelId, String labelX, String labelY, String labelZ, String labelMeta) {
        return new Pos(nbt.func_74762_e(labelX), nbt.func_74762_e(labelY), nbt.func_74762_e(labelZ)).store(new BlockDataStore(nbt.func_74779_i(labelId), nbt.func_74771_c(labelMeta)));
    }

    public String toString() {
        return String.format("CoordData[%s, %s, %s]/Object[%s]", this.x, this.y, this.z, this.stored);
    }

    public boolean isAnySurfaceEmpty(World world) {
        return this.isAnySurfaceNextTo(world, Blocks.field_150350_a);
    }

    public boolean isAnySurfaceNextTo(World world, Block block) {
        Pos up = this.add(0.0, 1.0, 0.0);
        Pos down = this.add(0.0, -1.0, 0.0);
        Pos left = this.add(-1.0, 0.0, 0.0);
        Pos right = this.add(1.0, 0.0, 0.0);
        Pos front = this.add(0.0, 0.0, -1.0);
        Pos back = this.add(0.0, 0.0, 1.0);
        return up.getBlock(world) == block || down.getBlock(world) == block || left.getBlock(world) == block || right.getBlock(world) == block || front.getBlock(world) == block || back.getBlock(world) == block;
    }

    public Pos findSafePosAround(World world) {
        Pos pos = this;
        Pos up = pos.add(0.0, 1.0, 0.0);
        Pos down = pos.add(0.0, -1.0, 0.0);
        Pos left = pos.add(-1.0, 0.0, 0.0);
        Pos right = pos.add(1.0, 0.0, 0.0);
        Pos front = pos.add(0.0, 0.0, -1.0);
        Pos frontLeft = pos.add(-1.0, 0.0, -1.0);
        Pos frontRight = pos.add(1.0, 0.0, -1.0);
        Pos back = pos.add(0.0, 0.0, 1.0);
        Pos backLeft = pos.add(-1.0, 0.0, 1.0);
        Pos backRight = pos.add(1.0, 0.0, 1.0);
        if (pos.getBlock(world) != Blocks.field_150350_a) {
            if (left.getBlock(world) == Blocks.field_150350_a) {
                pos = left;
            } else if (right.getBlock(world) == Blocks.field_150350_a) {
                pos = right;
            } else if (front.getBlock(world) == Blocks.field_150350_a) {
                pos = front;
            } else if (frontLeft.getBlock(world) == Blocks.field_150350_a) {
                pos = frontLeft;
            } else if (frontRight.getBlock(world) == Blocks.field_150350_a) {
                pos = frontRight;
            } else if (back.getBlock(world) == Blocks.field_150350_a) {
                pos = left;
            } else if (backLeft.getBlock(world) == Blocks.field_150350_a) {
                pos = backLeft;
            } else if (backRight.getBlock(world) == Blocks.field_150350_a) {
                pos = backRight;
            } else if (up.getBlock(world) == Blocks.field_150350_a) {
                pos = up;
            } else if (down.getBlock(world) == Blocks.field_150350_a) {
                pos = down;
            }
        }
        return pos.add(0.5, 0.0, 0.5);
    }

    public Pos writeToBuffer(ByteBuf buf) {
        buf.writeDouble(this.x());
        buf.writeDouble(this.y());
        buf.writeDouble(this.z());
        return this;
    }

    public Pos readFromBuffer(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        return this;
    }

    public Pos divide(int i) {
        this.x /= (double)i;
        this.y /= (double)i;
        this.z /= (double)i;
        return this;
    }

    public Pos half() {
        return this.divide(2);
    }

    public Pos remainder(int i) {
        this.x %= (double)i;
        this.y %= (double)i;
        this.z %= (double)i;
        return this;
    }

    public double distanceFrom(Pos coord) {
        return Pos.distance(coord.x, coord.y, coord.z, this.x, this.y, this.z);
    }

    public double distanceSqFrom(Pos coord) {
        return Pos.distanceSq(coord.x, coord.y, coord.z, this.x, this.y, this.z);
    }

    public double distanceFrom(Entity entity) {
        return Pos.distance(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.x, this.y, this.z);
    }

    public double distanceSqFrom(Entity entity) {
        return Pos.distanceSq(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.x, this.y, this.z);
    }

    public static ArrayList<Pos> getPointsBetween(Pos p1, Pos p2, int sections) {
        ArrayList<Pos> points = new ArrayList<Pos>();
        for (int section = sections; section > 0; --section) {
            float s = (float)section / (float)sections;
            double x = p1.x + (double)s * (p2.x - p1.x);
            double y = p1.y + (double)s * (p2.y - p1.y);
            double z = p1.z + (double)s * (p2.z - p1.z);
            points.add(new Pos(x, y, z));
        }
        return points;
    }

    public static double distance(Pos p1, Pos p2) {
        return Pos.distance(p1.x, p1.y, p1.z, p2.x, p2.y, p2.z);
    }

    public static double distanceSq(Pos p1, Pos p2) {
        return Pos.distanceSq(p1.x, p1.y, p1.z, p2.x, p2.y, p2.z);
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathHelper.func_76133_a((double)Pos.distanceSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double x = x1 - x2;
        double y = y1 - y2;
        double z = z1 - z2;
        return x * x + y * y + z * z;
    }

    public static class BlockDataStore
    implements IStorable {
        public String blockid;
        public byte metadata;

        public BlockDataStore(Block block, byte metadata) {
            this(BlockDataStore.identity(block), metadata);
        }

        public BlockDataStore(GameRegistry.UniqueIdentifier uid, byte metadata) {
            this(uid.toString(), metadata);
        }

        public BlockDataStore(String blockid, byte metadata) {
            this.blockid = blockid;
            this.metadata = metadata;
        }

        public static GameRegistry.UniqueIdentifier identity(Block block) {
            return GameRegistry.findUniqueIdentifierFor((Block)block);
        }
    }

    public static interface IStorable {
    }
}

