/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world;

import com.arisux.mdxlib.lib.world.Pos;
import com.arisux.mdxlib.lib.world.entity.Entities;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;

public class Worlds {
    public static Explosion createExplosion(Entity entity, World worldObj, Pos data, float strength, boolean isFlaming, boolean isSmoking, boolean doesBlockDamage) {
        Explosion explosion = new Explosion(worldObj, entity, data.x, data.y, data.z, strength);
        explosion.field_77286_a = isFlaming;
        explosion.field_82755_b = isSmoking;
        if (doesBlockDamage) {
            explosion.func_77278_a();
        }
        explosion.func_77279_a(true);
        return explosion;
    }

    public static Pos getNextSafePositionAbove(Pos pos, World world) {
        for (int y = (int)pos.y; y < world.func_72800_K(); ++y) {
            Pos position = new Pos(pos.x, (double)(y + 1), pos.z);
            if (!Entities.isPositionSafe(position, world)) continue;
            return position;
        }
        return pos;
    }

    public static boolean canSeeSky(Pos pos, World world) {
        for (int y = (int)pos.y; y < world.func_72800_K(); ++y) {
            Pos position = new Pos(pos.x, (double)(y + 1), pos.z);
            if (position.getBlock(world) == Blocks.field_150350_a) continue;
            return false;
        }
        return true;
    }

    public static int getLightAtCoord(World worldObj, Pos data) {
        int block = worldObj.func_72925_a(EnumSkyBlock.Block, (int)data.x, (int)data.y, (int)data.z);
        int sky = worldObj.func_72925_a(EnumSkyBlock.Sky, (int)data.x, (int)data.y, (int)data.z) - worldObj.func_72967_a(0.0f);
        return Math.max(block, sky);
    }

    public static Pos getNextSafePositionBelow(Pos pos, World world) {
        for (int y = (int)pos.y; y > 0; --y) {
            Pos position = new Pos(pos.x, (double)(y - 1), pos.z);
            if (!Entities.isPositionSafe(position, world)) continue;
            return position;
        }
        return pos;
    }

    public static void generateInChunk(World world, WorldGenerator generator, Random seed, int genPerChunk, Pos chunkCoord) {
        Worlds.generateInChunk(world, generator, seed, genPerChunk, 0, 128, chunkCoord);
    }

    public static void generateInChunk(World world, WorldGenerator generator, Random seed, int genPerChunk, int levelStart, int levelEnd, Pos chunkCoord) {
        for (int i = 0; i < genPerChunk; ++i) {
            int posX = (int)chunkCoord.x + seed.nextInt(16);
            int posY = levelStart + seed.nextInt(levelEnd);
            int posZ = (int)chunkCoord.z + seed.nextInt(16);
            generator.func_76484_a(world, seed, posX, posY, posZ);
        }
    }

    public static void generateInBiome(World world, WorldGenerator generator, Random seed, int genPerChunk, Pos chunkCoord, BiomeGenBase[] biomes) {
        Worlds.generateInBiome(world, generator, seed, genPerChunk, 0, 128, chunkCoord, biomes);
    }

    public static void generateInBiome(World world, WorldGenerator generator, Random seed, int genPerChunk, int levelStart, int levelEnd, Pos chunkCoord, BiomeGenBase[] biomes) {
        for (BiomeGenBase biome : biomes) {
            if (world.field_73011_w.getBiomeGenForCoords((int)chunkCoord.x, (int)chunkCoord.z) != biome) continue;
            Worlds.generateInChunk(world, generator, seed, genPerChunk, levelStart, levelEnd, chunkCoord);
        }
    }

    public static Entity getEntityByUUID(World world, UUID uuid) {
        for (Object o : world.field_72996_f.toArray()) {
            Entity entity;
            if (!(o instanceof Entity) || !(entity = (Entity)o).func_110124_au().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static UUID uuidFromNBT(NBTTagCompound nbt, String key) {
        return Worlds.uuidFromSignature(nbt.func_74779_i(key));
    }

    public static UUID uuidFromSignature(String signature) {
        if (signature != null && signature.matches("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[34][0-9a-fA-F]{3}-[89ab][0-9a-fA-F]{3}-[0-9a-fA-F]{12}")) {
            return UUID.fromString(signature);
        }
        return null;
    }
}

