/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.world.entity;

import com.arisux.mdxlib.MDX;
import com.arisux.mdxlib.lib.game.Game;
import com.arisux.mdxlib.lib.world.Pos;
import com.arisux.mdxlib.lib.world.Worlds;
import com.arisux.mdxlib.lib.world.block.Blocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Entities {
    private static Entity pointedEntity;

    public static Entity getEntityInCoordsRange(World worldObj, Class<? extends Entity> entityClass, Pos data, int range) {
        return Entities.getEntityInCoordsRange(worldObj, entityClass, data, range, 16);
    }

    public static boolean isPositionSafe(Pos pos, World world) {
        if (pos != null && world != null) {
            Pos newPos = new Pos(pos.x, pos.y, pos.z);
            Pos newPosBelow = new Pos(pos.x, pos.y - 1.0, pos.z);
            return newPosBelow.getBlock(world) != net.minecraft.init.Blocks.field_150350_a && newPos.getBlock(world) == net.minecraft.init.Blocks.field_150350_a;
        }
        return false;
    }

    public static Pos getSafePositionAboveBelow(Pos pos, World world) {
        Pos newSafePosition = Worlds.getNextSafePositionAbove(pos, world);
        if (newSafePosition == null) {
            newSafePosition = Worlds.getNextSafePositionBelow(pos, world);
        }
        return newSafePosition;
    }

    public static Entity getEntityInCoordsRange(World worldObj, Class<? extends Entity> entityClass, Pos data, int range, int height) {
        List<? extends Entity> entities = Entities.getEntitiesInCoordsRange(worldObj, entityClass, data, range, height);
        return entities.size() >= 1 ? entities.get(worldObj.field_73012_v.nextInt(entities.size())) : null;
    }

    public static Entity getRandomEntityInCoordsRange(World worldObj, Class<? extends Entity> entityClass, Pos data, int range) {
        return Entities.getRandomEntityInCoordsRange(worldObj, entityClass, data, range, 16);
    }

    public static Entity getRandomEntityInCoordsRange(World worldObj, Class<? extends Entity> entityClass, Pos data, int range, int height) {
        List<? extends Entity> entities = Entities.getEntitiesInCoordsRange(worldObj, entityClass, data, range, height);
        return entities.size() > 1 ? entities.get(new Random().nextInt(entities.size())) : null;
    }

    public static List<? extends Entity> getEntitiesInCoordsRange(World worldObj, Class<? extends Entity> entityClass, Pos data, int range) {
        return Entities.getEntitiesInCoordsRange(worldObj, entityClass, data, range, 16);
    }

    public static List<? extends Entity> getEntitiesInCoordsRange(World worldObj, Class<? extends Entity> entityClass, Pos data, int range, int height) {
        return worldObj.func_72872_a(entityClass, AxisAlignedBB.func_72330_a((double)data.x, (double)data.y, (double)data.z, (double)(data.x + 1.0), (double)(data.y + 1.0), (double)(data.z + 1.0)).func_72314_b((double)(range * 2), (double)height, (double)(range * 2)));
    }

    public static MovingObjectPosition.MovingObjectType getMovingObjectType(int ordinal) {
        for (MovingObjectPosition.MovingObjectType type : MovingObjectPosition.MovingObjectType.values()) {
            if (type.ordinal() != ordinal) continue;
            return type;
        }
        return null;
    }

    public static boolean canEntityBeSeenBy(Entity e1, Entity e2) {
        return Entities.rayTraceBlocks(e1, e2) == null;
    }

    public static boolean canEntityBeSeenBy(Entity e, Pos coord) {
        return Entities.rayTraceBlocks(e, coord) == null;
    }

    public static boolean canCoordBeSeenBy(World world, Pos p1, Pos p2) {
        return Entities.rayTraceBlocks(world, p1, p2) == null;
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingObjectPosition rayTraceSpecial(double reach, float partialTicks) {
        if (Game.minecraft().field_71451_h != null && Game.minecraft().field_71441_e != null) {
            pointedEntity = null;
            double distance = reach;
            Vec3 renderPosition = Game.minecraft().field_71451_h.func_70666_h(partialTicks);
            Vec3 lookVec = Game.minecraft().field_71451_h.func_70676_i(partialTicks);
            Vec3 lookPos = renderPosition.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
            MovingObjectPosition blockTrace = Entities.rayTraceBlocks((World)Game.minecraft().field_71441_e, Game.minecraft().field_71451_h.func_70666_h(partialTicks), lookPos, false, true, true);
            if (blockTrace != null) {
                distance = blockTrace.field_72307_f.func_72438_d(renderPosition);
            }
            pointedEntity = null;
            Vec3 hitVec = null;
            List list = Game.minecraft().field_71441_e.func_72839_b((Entity)Game.minecraft().field_71451_h, Game.minecraft().field_71451_h.field_70121_D.func_72321_a(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach).func_72314_b(1.0, 1.0, 1.0));
            double entityDist = distance;
            for (int idx = 0; idx < list.size(); ++idx) {
                double distToHit;
                Entity entity = (Entity)list.get(idx);
                if (!entity.func_70067_L()) continue;
                AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)entity.func_70111_Y(), (double)entity.func_70111_Y(), (double)entity.func_70111_Y());
                MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(renderPosition, lookPos);
                if (axisalignedbb.func_72318_a(renderPosition)) {
                    if (!(0.0 < entityDist) && entityDist != 0.0) continue;
                    pointedEntity = entity;
                    hitVec = movingobjectposition == null ? renderPosition : movingobjectposition.field_72307_f;
                    entityDist = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((distToHit = renderPosition.func_72438_d(movingobjectposition.field_72307_f)) < entityDist) && entityDist != 0.0) continue;
                if (entity == Game.minecraft().field_71451_h.field_70154_o && !entity.canRiderInteract()) {
                    if (entityDist != 0.0) continue;
                    pointedEntity = entity;
                    hitVec = movingobjectposition.field_72307_f;
                    continue;
                }
                pointedEntity = entity;
                hitVec = movingobjectposition.field_72307_f;
                entityDist = distToHit;
            }
            if (pointedEntity != null && entityDist < distance) {
                return new MovingObjectPosition(pointedEntity, hitVec);
            }
            if (blockTrace != null) {
                return blockTrace;
            }
        }
        return null;
    }

    public static MovingObjectPosition rayTraceBlocks(Entity e1, Entity e2) {
        return e1 != null && e2 != null ? Entities.rayTraceBlocks(e1.field_70170_p, e1.field_70165_t, e1.field_70163_u + (double)(e1.field_70131_O / 2.0f), e1.field_70161_v, e2.field_70165_t, e2.field_70163_u + (double)e2.func_70047_e(), e2.field_70161_v) : null;
    }

    public static MovingObjectPosition rayTraceBlocks(Entity e, Pos p) {
        return e != null && p != null ? Entities.rayTraceBlocks(e.field_70170_p, e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v, p.x, p.y, p.z) : null;
    }

    public static MovingObjectPosition rayTraceBlocks(World worldObj, Pos p1, Pos p2) {
        return p1 != null && p2 != null ? Entities.rayTraceBlocks(worldObj, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z) : null;
    }

    public static MovingObjectPosition rayTraceBlocks(World worldObj, double x1, double y1, double z1, double x2, double y2, double z2) {
        return worldObj != null ? Entities.rayTraceBlocks(worldObj, Vec3.func_72443_a((double)x1, (double)y1, (double)z1), Vec3.func_72443_a((double)x2, (double)y2, (double)z2), false, false, false) : null;
    }

    public static MovingObjectPosition rayTraceAll(Entity entity, int reach) {
        return Entities.rayTraceAll(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A, reach, new ArrayList<Entity>(Arrays.asList(entity)));
    }

    public static MovingObjectPosition rayTraceAll(World world, double x, double y, double z, float rotationYaw, float rotationPitch, int reach, ArrayList<Entity> exclude) {
        MovingObjectPosition blockHitVec;
        Vec3 pos = Vec3.func_72443_a((double)x, (double)y, (double)z);
        Vec3 lookVec = Entities.getLookVector(rotationYaw, rotationPitch);
        Entity entityHit = null;
        Vec3 hitVec = null;
        Vec3 posHit = null;
        if (lookVec != null) {
            posHit = pos.func_72441_c(lookVec.field_72450_a * (double)reach, lookVec.field_72448_b * (double)reach, lookVec.field_72449_c * (double)reach);
            List entities = world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0)).func_72321_a(lookVec.field_72450_a * (double)reach, lookVec.field_72448_b * (double)reach, lookVec.field_72449_c * (double)reach).func_72314_b(1.0, 1.0, 1.0));
            for (Entity e : entities) {
                if (e == null || !e.func_70067_L() || exclude.contains(e)) continue;
                float size = e.func_70111_Y();
                AxisAlignedBB box = e.field_70121_D.func_72314_b((double)size, (double)size, (double)size);
                MovingObjectPosition movobjpos = box.func_72327_a(pos, posHit);
                entityHit = e;
                if (movobjpos == null) {
                    hitVec = pos;
                    continue;
                }
                hitVec = movobjpos.field_72307_f;
            }
        }
        if (entityHit != null && hitVec != null) {
            return new MovingObjectPosition(entityHit, hitVec);
        }
        if (posHit != null && (blockHitVec = Entities.rayTraceBlocks(world, pos, posHit, true, true, true)) != null) {
            return blockHitVec;
        }
        return null;
    }

    public static MovingObjectPosition rayTraceBlocks(World world, Pos pos, Pos pos2, boolean hitLiquid, boolean ignoreBlocksWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return Entities.rayTraceBlocks(world, Vec3.func_72443_a((double)pos.x, (double)pos.y, (double)pos.z), Vec3.func_72443_a((double)pos2.x, (double)pos2.y, (double)pos2.z), hitLiquid, ignoreBlocksWithoutBoundingBox, returnLastUncollidableBlock);
    }

    public static MovingObjectPosition rayTraceBlocks(World world, Vec3 pos, Vec3 pos2, boolean hitLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(pos.field_72450_a) || Double.isNaN(pos.field_72448_b) || Double.isNaN(pos.field_72449_c))) {
            if (!(Double.isNaN(pos2.field_72450_a) || Double.isNaN(pos2.field_72448_b) || Double.isNaN(pos2.field_72449_c))) {
                MovingObjectPosition obj;
                int posX = MathHelper.func_76128_c((double)pos.field_72450_a);
                int posY = MathHelper.func_76128_c((double)pos.field_72448_b);
                int posZ = MathHelper.func_76128_c((double)pos.field_72449_c);
                Block posBlock = world.func_147439_a(posX, posY, posZ);
                int posMeta = world.func_72805_g(posX, posY, posZ);
                if ((!ignoreBlockWithoutBoundingBox || posBlock.func_149668_a(world, posX, posY, posZ) != null) && posBlock.func_149678_a(posMeta, hitLiquid) && (obj = posBlock.func_149731_a(world, posX, posY, posZ, pos, pos2)) != null) {
                    return obj;
                }
                MovingObjectPosition movObjPos = null;
                int dist = 200;
                while (dist-- >= 0) {
                    int side;
                    if (Double.isNaN(pos.field_72450_a) || Double.isNaN(pos.field_72448_b) || Double.isNaN(pos.field_72449_c)) {
                        return null;
                    }
                    if ((double)posX == pos2.field_72450_a && (double)posY == pos2.field_72448_b && (double)posZ == pos2.field_72449_c) {
                        return returnLastUncollidableBlock ? movObjPos : null;
                    }
                    boolean endX = true;
                    boolean endY = true;
                    boolean endZ = true;
                    double distX = 999.0;
                    double distY = 999.0;
                    double distZ = 999.0;
                    if (pos2.field_72450_a > (double)posX) {
                        distX = (double)posX + 1.0;
                    } else if (pos2.field_72450_a < (double)posX) {
                        distX = (double)posX + 0.0;
                    } else {
                        endX = false;
                    }
                    if (pos2.field_72448_b > (double)posY) {
                        distY = (double)posY + 1.0;
                    } else if (pos2.field_72448_b < (double)posY) {
                        distY = (double)posY + 0.0;
                    } else {
                        endY = false;
                    }
                    if (pos2.field_72449_c > (double)posZ) {
                        distZ = (double)posZ + 1.0;
                    } else if (pos2.field_72449_c < (double)posZ) {
                        distZ = (double)posZ + 0.0;
                    } else {
                        endZ = false;
                    }
                    double dX = 999.0;
                    double dY = 999.0;
                    double dZ = 999.0;
                    double displacementX = pos2.field_72450_a - pos.field_72450_a;
                    double displacementY = pos2.field_72448_b - pos.field_72448_b;
                    double displacementZ = pos2.field_72449_c - pos.field_72449_c;
                    if (endX) {
                        dX = (distX - pos.field_72450_a) / displacementX;
                    }
                    if (endY) {
                        dY = (distY - pos.field_72448_b) / displacementY;
                    }
                    if (endZ) {
                        dZ = (distZ - pos.field_72449_c) / displacementZ;
                    }
                    if (dX < dY && dX < dZ) {
                        side = pos2.field_72450_a > (double)posX ? 4 : 5;
                        pos.field_72450_a = distX;
                        pos.field_72448_b += displacementY * dX;
                        pos.field_72449_c += displacementZ * dX;
                    } else if (dY < dZ) {
                        side = pos2.field_72448_b > (double)posY ? 0 : 1;
                        pos.field_72450_a += displacementX * dY;
                        pos.field_72448_b = distY;
                        pos.field_72449_c += displacementZ * dY;
                    } else {
                        side = pos2.field_72449_c > (double)posZ ? 2 : 3;
                        pos.field_72450_a += displacementX * dZ;
                        pos.field_72448_b += displacementY * dZ;
                        pos.field_72449_c = distZ;
                    }
                    Vec3 posNew = Vec3.func_72443_a((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
                    posNew.field_72450_a = MathHelper.func_76128_c((double)pos.field_72450_a);
                    posX = (int)posNew.field_72450_a;
                    if (side == 5) {
                        --posX;
                        posNew.field_72450_a += 1.0;
                    }
                    posNew.field_72448_b = MathHelper.func_76128_c((double)pos.field_72448_b);
                    posY = (int)posNew.field_72448_b;
                    if (side == 1) {
                        --posY;
                        posNew.field_72448_b += 1.0;
                    }
                    posNew.field_72449_c = MathHelper.func_76128_c((double)pos.field_72449_c);
                    posZ = (int)posNew.field_72449_c;
                    if (side == 3) {
                        --posZ;
                        posNew.field_72449_c += 1.0;
                    }
                    Block newPosBlock = world.func_147439_a(posX, posY, posZ);
                    int newPosMeta = world.func_72805_g(posX, posY, posZ);
                    if (ignoreBlockWithoutBoundingBox && newPosBlock.func_149668_a(world, posX, posY, posZ) == null) continue;
                    if (newPosBlock.func_149678_a(newPosMeta, hitLiquid)) {
                        MovingObjectPosition obj2 = newPosBlock.func_149731_a(world, posX, posY, posZ, pos, pos2);
                        if (obj2 == null) continue;
                        return obj2;
                    }
                    movObjPos = new MovingObjectPosition(posX, posY, posZ, side, pos, false);
                }
                return returnLastUncollidableBlock ? movObjPos : null;
            }
            return null;
        }
        return null;
    }

    public static Vec3 getLookVector(float rotationYaw, float rotationPitch) {
        return Entities.getLookVector(rotationYaw, rotationPitch, 0.0f, 0.0f, 1.0f);
    }

    public static Vec3 getLookVector(float rotationYaw, float rotationPitch, float prevRotationYaw, float prevRotationPitch, float partialTicks) {
        if (partialTicks == 1.0f) {
            float f1 = MathHelper.func_76134_b((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -MathHelper.func_76134_b((float)(-rotationPitch * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76126_a((float)(-rotationPitch * ((float)Math.PI / 180)));
            return Vec3.func_72443_a((double)(f2 * f3), (double)f4, (double)(f1 * f3));
        }
        float f1 = prevRotationPitch + (rotationPitch - prevRotationPitch) * partialTicks;
        float f2 = prevRotationYaw + (rotationYaw - prevRotationYaw) * partialTicks;
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        return Vec3.func_72443_a((double)(f4 * f5), (double)f6, (double)(f3 * f5));
    }

    public static Entity constructEntityViaClasspath(World worldObj, String name) {
        try {
            return Entities.constructEntity(worldObj, Class.forName(name));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Entity constructEntity(World worldObj, Class<? extends Entity> c) {
        if (worldObj == null) {
            MDX.log().warn("World object null while attempting to construct entity.");
            return null;
        }
        if (c == null) {
            MDX.log().warn("Entity class null while attempting to construct entity.");
            return null;
        }
        try {
            return c.getConstructor(World.class).newInstance(worldObj);
        }
        catch (Exception e) {
            MDX.log().warn("Failed to construct entity: " + (c != null ? c.getName() : c));
            e.printStackTrace();
            return null;
        }
    }

    public static void faceEntity(Entity facer, Entity faced, float maxYaw, float maxPitch) {
        double yDistance;
        double xDistance = faced.field_70165_t - facer.field_70165_t;
        double zDistance = faced.field_70161_v - facer.field_70161_v;
        if (faced instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)faced;
            yDistance = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (facer.field_70163_u + (double)facer.func_70047_e());
        } else {
            yDistance = (faced.field_70121_D.field_72338_b + faced.field_70121_D.field_72337_e) / 2.0 - (facer.field_70163_u + (double)facer.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(xDistance * xDistance + zDistance * zDistance));
        float f2 = (float)(Math.atan2(zDistance, xDistance) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(yDistance, d3) * 180.0 / Math.PI));
        facer.field_70125_A = Entities.updateRotation(facer.field_70125_A, f3, maxPitch);
        facer.field_70177_z = Entities.updateRotation(facer.field_70177_z, f2, maxYaw);
    }

    public static float updateRotation(float currentRotation, float targetRotation, float maxChange) {
        float newRotation = MathHelper.func_76142_g((float)(targetRotation - currentRotation));
        return currentRotation + (newRotation > maxChange ? maxChange : (newRotation < -maxChange ? -maxChange : maxChange));
    }

    public static void applyCollision(Entity entity) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72340_a + 0.001));
        if (entity.field_70170_p.func_72904_c(minX, minY = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72338_b + 0.001)), minZ = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72339_c + 0.001)), maxX = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72336_d - 0.001)), maxY = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72337_e - 0.001)), maxZ = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72334_f - 0.001)))) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Block block = entity.field_70170_p.func_147439_a(x, y, z);
                        try {
                            block.func_149670_a(entity.field_70170_p, x, y, z, entity);
                            continue;
                        }
                        catch (Throwable throwable) {
                            MDX.log().warn("Exception while handling entity collision with block.");
                        }
                    }
                }
            }
        }
    }

    public static boolean isInLava(Entity entity) {
        return Entities.isInMaterial(entity, Material.field_151587_i);
    }

    public static boolean isInWater(Entity entity) {
        return Entities.isInMaterial(entity, Material.field_151586_h);
    }

    public static boolean isInMaterial(Entity entity, Material material) {
        if (entity != null && entity.field_70170_p != null && entity.func_70046_E() != null) {
            return entity.field_70170_p.func_72875_a(entity.func_70046_E().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), material);
        }
        return false;
    }

    public static void setMoveHelper(EntityLiving living, EntityMoveHelper moveHelper) {
        MDX.access().setMoveHelper(living, moveHelper);
    }

    public static void setNavigator(EntityLiving living, PathNavigate navigator) {
        MDX.access().setNavigator(living, navigator);
    }

    public static void setLookHelper(EntityLiving living, EntityLookHelper lookHelper) {
        MDX.access().setLookHelper(living, lookHelper);
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getEntityTexture(Render render, Entity entity) {
        return MDX.access().getEntityTexture(render, entity);
    }

    public static Class<? extends Entity> getRegisteredEntityClass(String entityId) {
        return (Class)EntityList.field_75625_b.get(entityId);
    }

    public static String getEntityRegistrationId(Entity entity) {
        return Entities.getEntityRegistrationId(entity.getClass());
    }

    public static String getEntityRegistrationId(Class<? extends Entity> c) {
        return (String)EntityList.field_75626_c.get(c);
    }

    public static Pos getSafeLocationAround(Entity toCheck, Pos around) {
        ArrayList<Pos> potentialLocations = Blocks.getCoordDataInRangeIncluding((int)around.x, (int)around.y, (int)around.z, 2, toCheck.field_70170_p, net.minecraft.init.Blocks.field_150350_a);
        for (Pos potentialLocation : potentialLocations) {
            Block blockAt = potentialLocation.getBlock(toCheck.field_70170_p);
            Block blockBelow = potentialLocation.add(0.0, -1.0, 0.0).getBlock(toCheck.field_70170_p);
            if (blockAt == null || blockBelow == null || blockAt != net.minecraft.init.Blocks.field_150350_a || !Entities.isGround(blockBelow)) continue;
            double entityWidth = toCheck.field_70121_D.field_72336_d - toCheck.field_70121_D.field_72340_a;
            double entityHeight = toCheck.field_70121_D.field_72337_e - toCheck.field_70121_D.field_72338_b;
            double entityDepth = toCheck.field_70121_D.field_72334_f - toCheck.field_70121_D.field_72339_c;
            entityWidth = entityWidth < 1.0 ? 1.0 : entityWidth;
            entityDepth = entityDepth < 1.0 ? 1.0 : entityDepth;
            Block blockAbove = potentialLocation.add(0.0, entityHeight = entityHeight < 1.0 ? 1.0 : entityHeight, 0.0).getBlock(toCheck.field_70170_p);
            if (!Entities.isSafe(blockAbove)) continue;
            Block blockToLeft = potentialLocation.add(-entityWidth, 0.0, 0.0).getBlock(toCheck.field_70170_p);
            Block blockToRight = potentialLocation.add(entityWidth, 0.0, 0.0).getBlock(toCheck.field_70170_p);
            Block blockInFront = potentialLocation.add(0.0, 0.0, entityDepth).getBlock(toCheck.field_70170_p);
            Block blockInBack = potentialLocation.add(0.0, 0.0, -entityDepth).getBlock(toCheck.field_70170_p);
            if (!Entities.isSafe(blockToLeft) || !Entities.isSafe(blockToRight) || !Entities.isSafe(blockInFront) || !Entities.isSafe(blockInBack)) continue;
            return potentialLocation;
        }
        return null;
    }

    public static boolean isGround(Block block) {
        return block.func_149688_o().func_76220_a() && block != net.minecraft.init.Blocks.field_150350_a;
    }

    public static boolean isSafe(Block block) {
        return block == net.minecraft.init.Blocks.field_150350_a;
    }
}

