/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib;

import com.arisux.mdxlib.Console;
import com.arisux.mdxlib.MDXModule;
import com.arisux.mdxlib.lib.client.Notification;
import com.arisux.mdxlib.lib.client.render.wavefront.TriangulatedWavefrontModel;
import com.arisux.mdxlib.lib.game.Access;
import com.arisux.mdxlib.lib.game.ModIdentityMap;
import com.arisux.mdxlib.lib.world.storage.Schematic;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Logger;

public class MDX {
    public static final String MODID = "mdxlib";
    public static final String VERSION = "1.0.0.70";
    private static Access access;
    private HashMap<String, TriangulatedWavefrontModel> modelRegistry;
    private ArrayList<Schematic> schematicRegistry;
    private static ArrayList<Notification> notificationsInQueue;
    private static ArrayList<ModIdentityMap> remappedMods;
    private static ArrayList<ModIdentityMap.IdentityMap> remappedIdentities;

    public MDX() {
        access = new Access();
        this.modelRegistry = new HashMap();
        this.schematicRegistry = new ArrayList();
        notificationsInQueue = new ArrayList();
        remappedMods = new ArrayList();
        remappedIdentities = new ArrayList();
    }

    public static MDX instance() {
        return MDXModule.instance();
    }

    public static Access access() {
        return access;
    }

    public static Logger log() {
        return Console.logger;
    }

    public static void sendNotification(Notification notification) {
        if (notification.allowMultiple() || !notification.allowMultiple() && !MDX.getNotificationsInQueue().contains(notification)) {
            notificationsInQueue.add(notification);
        }
    }

    public static ArrayList<Notification> getNotificationsInQueue() {
        return notificationsInQueue;
    }

    public static HashMap<String, TriangulatedWavefrontModel> getModelRegistry() {
        return MDX.instance().modelRegistry;
    }

    public static File getModelsDirectory() {
        return new File("models");
    }

    public static TriangulatedWavefrontModel loadWavefrontModel(Class<?> c, String modid, String model, String assetsPath) {
        File baseDir = new File(MDX.getModelsDirectory(), String.format("%s/", modid));
        File path = new File(baseDir, model);
        if (!MDX.getModelsDirectory().exists()) {
            MDX.getModelsDirectory().mkdirs();
        }
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        try {
            URL urlOBJ = c.getResource(assetsPath + ".obj");
            File fileOBJ = new File(path.getAbsolutePath() + ".obj");
            URL urlMTL = c.getResource(assetsPath + ".mtl");
            File fileMTL = new File(path.getAbsolutePath() + ".mtl");
            if (!fileOBJ.exists()) {
                FileUtils.copyURLToFile((URL)urlOBJ, (File)fileOBJ);
                MDX.log().info(String.format("Extracted wavefront model: %s", fileOBJ.getAbsoluteFile().getPath()));
            }
            if (!fileMTL.exists()) {
                FileUtils.copyURLToFile((URL)urlMTL, (File)fileMTL);
                MDX.log().info(String.format("Extracted wavefront texture: %s", fileMTL.getAbsoluteFile().getPath()));
            }
        }
        catch (Exception e) {
            MDX.log().info(String.format("Error while extracting %s from %s: %s", path, assetsPath, e));
            e.printStackTrace();
        }
        return MDX.loadWavefrontModel(modid, path);
    }

    public static TriangulatedWavefrontModel loadWavefrontModel(String modid, File path) {
        TriangulatedWavefrontModel model = new TriangulatedWavefrontModel();
        if (model.load(modid, path.getAbsolutePath())) {
            String tag = path.getAbsolutePath().replaceAll(".obj", "").replaceAll(".OBJ", "");
            tag = tag.substring(tag.lastIndexOf(47) + 1, tag.length());
            MDX.getModelRegistry().put(tag, model);
            MDX.log().info("[WavefrontAPI] Loaded wavefront model: " + path);
        } else {
            MDX.log().info("[WavefrontAPI] Unable to load wavefront model: " + path);
        }
        return model;
    }

    public static TriangulatedWavefrontModel getWavefrontModel(String modelName) {
        return MDX.getModelRegistry().get(modelName);
    }

    public static ArrayList<Schematic> getSchematicRegistry() {
        return MDX.instance().schematicRegistry;
    }

    public static File getSchematicsDirectory() {
        return new File("./", "schematics");
    }

    public static Collection<File> getSchematicsInDirectory() {
        return FileUtils.listFiles((File)MDX.getSchematicsDirectory(), (String[])new String[]{"schematic"}, (boolean)true);
    }

    public static String[] getSchematicNames() {
        Collection<File> files = MDX.getSchematicsInDirectory();
        String[] filenames = new String[files.size()];
        int i = 0;
        for (File file : files) {
            filenames[i++] = FilenameUtils.getBaseName((String)file.getName());
        }
        return filenames;
    }

    public static Schematic loadSchematic(File path) {
        try {
            Schematic schematic = new Schematic(path, CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(path)));
            MDX.getSchematicRegistry().add(schematic);
            return schematic;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Schematic loadSchematic(String name) {
        name = FilenameUtils.getExtension((String)name).length() == 0 ? name + ".schematic" : name;
        for (File file : MDX.getSchematicsInDirectory()) {
            if (!file.getPath().endsWith(name) || !name.endsWith(file.getName())) continue;
            return MDX.loadSchematic(file);
        }
        return null;
    }

    public static Schematic loadSchematic(File path, URL resource) {
        if (!MDX.getSchematicsDirectory().exists()) {
            MDX.getSchematicsDirectory().mkdirs();
        }
        if (!path.exists()) {
            try {
                FileUtils.copyURLToFile((URL)resource, (File)path);
                MDX.log().info(String.format("Extracted %s", path.getAbsoluteFile().getPath()));
            }
            catch (Exception e) {
                MDX.log().info(String.format("Error while extracting %s: %s", path, e));
            }
        }
        return MDX.loadSchematic(path);
    }

    public static void registerRemappedEntity(Class<? extends Entity> entityClass, String invalidId) {
        EntityList.field_75625_b.put(invalidId, entityClass);
    }

    public static void registerRemappedMod(String oldID, String newID, String modClassLocation) {
        MDX.getRemappedMods().add(new ModIdentityMap(oldID, newID, modClassLocation));
    }

    public static void registerMappingInfo(String oldID, String newID, String modId) {
        MDX.getRemappedIdentities().add(new ModIdentityMap.IdentityMap(oldID, newID, new ModIdentityMap(modId)));
    }

    public static void replaceMapping(FMLMissingMappingsEvent.MissingMapping mapping, String oldID, String newID) {
        String newName = mapping.name.replace(oldID, newID);
        if (mapping.type == GameRegistry.Type.ITEM) {
            MDX.log().info("Converting item mapping [" + mapping.name + "@" + mapping.id + "] -> [" + newName + "@" + mapping.id + "]");
            Item item = (Item)Item.field_150901_e.func_82594_a(newName);
            if (item != null) {
                mapping.remap(item);
            } else {
                MDX.log().warn("Error converting item mapping [" + mapping.name + "@" + mapping.id + "]");
            }
        }
        if (mapping.type == GameRegistry.Type.BLOCK) {
            Block block = (Block)Block.field_149771_c.func_82594_a(newName);
            MDX.log().info("Converting block mapping [" + mapping.name + "@" + mapping.id + "] -> [" + newName + "@" + mapping.id + "]");
            if (block != null) {
                mapping.remap(block);
            } else {
                MDX.log().warn("Error converting block mapping. [" + mapping.name + "@" + mapping.id + "]");
            }
        }
    }

    public static ArrayList<ModIdentityMap.IdentityMap> getRemappedIdentities() {
        return remappedIdentities;
    }

    public static ArrayList<ModIdentityMap> getRemappedMods() {
        return remappedMods;
    }
}

