/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client;

import com.arisux.mdxlib.MDX;
import com.arisux.mdxlib.lib.client.NotifierModule;
import com.arisux.mdxlib.lib.client.render.Draw;
import com.arisux.mdxlib.lib.client.render.OpenGL;
import java.util.ArrayList;

public abstract class Notification {
    private int ticksExisted;
    private int x = 5;
    private int y = 5;
    private int width = 128;
    private int height = 32;
    private int pad = 5;
    private int lineSpacing = 10;
    private float textScale = 0.75f;

    public abstract String getMessage();

    public int displayTimeout() {
        return 200;
    }

    public int tick() {
        return this.ticksExisted++;
    }

    public void timeoutAction() {
        MDX.getNotificationsInQueue().remove(this);
        NotifierModule.currentNotification = null;
        this.ticksExisted = 0;
    }

    protected void preDraw() {
        this.draw();
    }

    public void draw() {
        this.textScale = 0.5f;
        int lineIndex = 0;
        ArrayList<String> lines = Draw.wrapString(this.getMessage(), (int)((float)(this.width - this.pad * 2) / this.textScale));
        String tickString = String.format("%s", this.displayTimeout() / 20 - this.ticksExisted / 20);
        int tickStringWidth = Draw.getStringRenderWidth(tickString);
        Draw.drawRect(this.x, this.y, this.width, this.height, -1442840576);
        OpenGL.pushMatrix();
        OpenGL.scale(this.textScale, this.textScale, this.textScale);
        Draw.drawString(String.format("Notification %s of %s", MDX.getNotificationsInQueue().indexOf(NotifierModule.currentNotification) + 1, MDX.getNotificationsInQueue().size()), (int)((float)(this.x + this.pad - 3) / this.textScale), (int)((float)(this.y + this.pad - 3) / this.textScale) + this.lineSpacing * lineIndex, 0x66FFFFFF, false);
        Draw.drawString(tickString, (int)(((float)(this.x + this.width - this.pad + 3) - (float)tickStringWidth * this.textScale) / this.textScale), (int)((float)(this.y + this.pad - 3) / this.textScale) + this.lineSpacing * lineIndex, 0x66FFFFFF, false);
        for (String line : lines) {
            Draw.drawString(line, (int)((float)(this.x + this.pad) / this.textScale), (int)((float)(this.y + this.pad) / this.textScale) + this.lineSpacing * lineIndex + this.lineSpacing, -1, false);
            ++lineIndex;
        }
        this.height = (int)((float)(this.pad * 2) + (float)lineIndex * ((float)this.lineSpacing * this.textScale) + (float)this.lineSpacing * this.textScale);
        OpenGL.popMatrix();
    }

    public int getTicksExisted() {
        return this.ticksExisted;
    }

    public boolean allowMultiple() {
        return true;
    }

    public static class DynamicNotification
    extends Notification {
        private String message;
        private int displayTimeout;

        @Override
        public boolean allowMultiple() {
            return false;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public int displayTimeout() {
            return this.displayTimeout == 0 ? super.displayTimeout() : this.displayTimeout;
        }

        public void setDisplayTimeout(int seconds) {
            this.displayTimeout = seconds * 20;
        }
    }
}

