/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.render;

import com.arisux.mdxlib.lib.client.gui.GuiCustomScreen;
import com.arisux.mdxlib.lib.client.render.OpenGL;
import com.arisux.mdxlib.lib.client.render.Screen;
import com.arisux.mdxlib.lib.game.Game;
import com.arisux.mdxlib.lib.game.GameResources;
import com.arisux.mdxlib.lib.util.MDXMath;
import com.arisux.mdxlib.lib.util.Remote;
import com.arisux.mdxlib.lib.world.block.Blocks;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.lwjgl.opengl.GL11;

public class Draw {
    public static final String TOOLTIP_LINESPACE = "\u00a7h";
    public static final String TOOLTIP_HANDLER = "\u00a7x";
    public static List<ITooltipLineHandler> tipLineHandlers = new ArrayList<ITooltipLineHandler>();
    public static final GuiCustomScreen guiHook = new GuiCustomScreen();

    public static void line(int x1, int y1, int x2, int y2, float depth, float width, int color) {
        GL11.glLineWidth((float)width);
        OpenGL.color4i(color);
        OpenGL.translate(0.0f, 0.0f, depth);
        GL11.glEnable((int)2848);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
        OpenGL.translate(0.0f, 0.0f, -depth);
    }

    public static void drawRect(int x, int y, int w, int h, int color) {
        Draw.drawGradientRect(x, y, w, h, color, color);
    }

    public static void drawGradientRect(int x, int y, int w, int h, int color1, int color2) {
        Draw.drawGradientRect(x, y, x + w, y + h, 0, color1, color2);
    }

    public static void drawGradientRect(int x, int y, int w, int h, int zLevel, int color1, int color2) {
        OpenGL.disableTexture2d();
        OpenGL.shadeSmooth();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a((float)(color1 >> 16 & 0xFF) / 255.0f, (float)(color1 >> 8 & 0xFF) / 255.0f, (float)(color1 & 0xFF) / 255.0f, (float)(color1 >> 24 & 0xFF) / 255.0f);
        tessellator.func_78377_a((double)w, (double)y, (double)zLevel);
        tessellator.func_78377_a((double)x, (double)y, (double)zLevel);
        tessellator.func_78369_a((float)(color2 >> 16 & 0xFF) / 255.0f, (float)(color2 >> 8 & 0xFF) / 255.0f, (float)(color2 & 0xFF) / 255.0f, (float)(color2 >> 24 & 0xFF) / 255.0f);
        tessellator.func_78377_a((double)x, (double)h, (double)zLevel);
        tessellator.func_78377_a((double)w, (double)h, (double)zLevel);
        tessellator.func_78381_a();
        OpenGL.shadeFlat();
        OpenGL.enableTexture2d();
    }

    public static void drawQuad(int x, int y, int w, int h) {
        Draw.drawQuad(x, y, w, h, -90);
    }

    public static void drawQuad(int x, int y, int w, int h, int z) {
        Draw.drawQuad(x, y, w, h, z, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void drawQuad(int x, int y, int w, int h, int u, int v) {
        Draw.drawQuad(x, y, w, h, -90, u, v);
    }

    public static void drawQuad(int x, int y, int w, int h, int z, int u, int v) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + h), (double)z, (double)((float)(u + 0) * f), (double)((float)(v + h) * f1));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)z, (double)((float)(u + w) * f), (double)((float)(v + h) * f1));
        tessellator.func_78374_a((double)(x + w), (double)(y + 0), (double)z, (double)((float)(u + w) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)z, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78381_a();
    }

    public static void drawQuad(int x, int y, int w, int h, float minU, float maxU, float minV, float maxV) {
        Draw.drawQuad(x, y, w, h, -90, minU, maxU, minV, maxV);
    }

    public static void drawQuad(int x, int y, int w, int h, int z, float minU, float maxU, float minV, float maxV) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + h), (double)z, (double)minU, (double)maxV);
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)z, (double)maxU, (double)maxV);
        tessellator.func_78374_a((double)(x + w), (double)(y + 0), (double)z, (double)maxU, (double)minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)z, (double)minU, (double)minV);
        tessellator.func_78381_a();
    }

    public static void drawString(String text, int x, int y, int color, boolean shadow) {
        String original = text;
        if ((text = I18n.func_135052_a((String)text, (Object[])new Object[0])).toLowerCase().contains("error:".toLowerCase())) {
            text = original;
        }
        if (shadow) {
            Game.fontRenderer().func_78261_a(text, x, y, color);
        }
        if (!shadow) {
            Game.fontRenderer().func_78276_b(text, x, y, color);
        }
        OpenGL.color3i(0xFFFFFF);
    }

    public static void drawString(String text, int x, int y, int color) {
        Draw.drawString(text, x, y, color, true);
    }

    public static void drawStringAlignCenter(String text, int x, int y, int w, int h, int color, boolean shadow) {
        Draw.drawString(text, x + (w - Draw.getStringRenderWidth(StatCollector.func_74838_a((String)text))) / 2, y + (h - 8) / 2, color, shadow);
    }

    public static void drawStringAlignCenter(String text, int x, int y, int w, int h, int color) {
        Draw.drawStringAlignCenter(text, x, y, w, h, color, true);
    }

    public static void drawStringAlignCenter(String text, int x, int y, int color, boolean shadow) {
        Draw.drawString(text, x - Draw.getStringRenderWidth(StatCollector.func_74838_a((String)text)) / 2, y, color, shadow);
    }

    public static void drawStringAlignCenter(String text, int x, int y, int color) {
        Draw.drawStringAlignCenter(text, x, y, color, true);
    }

    public static void drawStringAlignRight(String text, int x, int y, int color, boolean shadow) {
        Draw.drawString(text, x - Draw.getStringRenderWidth(StatCollector.func_74838_a((String)text)), y, color, shadow);
    }

    public static void drawStringAlignRight(String text, int x, int y, int color) {
        Draw.drawStringAlignRight(text, x, y, color, true);
    }

    public static int getStringRenderWidth(String s) {
        return Game.fontRenderer().func_78256_a(EnumChatFormatting.func_110646_a((String)s));
    }

    public static void drawToolTip(int x, int y, String text) {
        Draw.drawMultilineToolTip(x, y, Arrays.asList(text));
    }

    public static int getTipLineId(ITooltipLineHandler handler) {
        tipLineHandlers.add(handler);
        return tipLineHandlers.size() - 1;
    }

    public static ITooltipLineHandler getTipLine(String line) {
        return !line.startsWith(TOOLTIP_HANDLER) ? null : tipLineHandlers.get(Integer.parseInt(line.substring(2)));
    }

    public static void drawMultilineToolTip(int x, int y, List<String> list) {
        ITooltipLineHandler line;
        if (list.isEmpty()) {
            return;
        }
        OpenGL.disableRescaleNormal();
        OpenGL.disableDepthTest();
        OpenGL.disableStandardItemLighting();
        int w = 0;
        int h = -2;
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            line = Draw.getTipLine(s);
            Dimension d = line != null ? line.getSize() : new Dimension(Draw.getStringRenderWidth(s), list.get(i).endsWith(TOOLTIP_LINESPACE) && i + 1 < list.size() ? 12 : 10);
            w = Math.max(w, d.width);
            h += d.height;
        }
        if (x < 8) {
            x = 8;
        } else if (x > Screen.scaledDisplayResolution().getScaledWidth() - w - 8) {
            x -= 24 + w;
        }
        y = (int)MDXMath.clip(y, 8.0, Screen.scaledDisplayResolution().getScaledHeight() - 8 - h);
        guiHook.incZLevel(300.0f);
        Draw.drawTooltipBox(x - 4, y - 4, w + 7, h + 7);
        for (String s : list) {
            line = Draw.getTipLine(s);
            if (line != null) {
                line.draw(x, y);
                y += line.getSize().height;
                continue;
            }
            Game.fontRenderer().func_78261_a(s, x, y, -1);
            y += s.endsWith(TOOLTIP_LINESPACE) ? 12 : 10;
        }
        tipLineHandlers.clear();
        guiHook.incZLevel(-300.0f);
        OpenGL.enableDepthTest();
        OpenGL.enableRescaleNormal();
    }

    public static void drawTooltipBox(int x, int y, int w, int h) {
        int bg = -267386864;
        Draw.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        Draw.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        Draw.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        Draw.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        Draw.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        int grad1 = 0x505000FF;
        int grad2 = 1344798847;
        Draw.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        Draw.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        Draw.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        Draw.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }

    public static void drawProgressBar(String label, int maxProgress, int curProgress, int posX, int posY, int barWidth, int barHeight, int stringPosY, int color, boolean barStyle) {
        OpenGL.pushMatrix();
        Gui.func_73734_a((int)(posX + 0), (int)(posY + 0), (int)(posX + barWidth), (int)(posY + 5 + barHeight), (int)0x77000000);
        if (!barStyle && curProgress > maxProgress / barWidth) {
            Gui.func_73734_a((int)(posX + 1), (int)(posY + 1), (int)(posX + curProgress * maxProgress / maxProgress * barWidth / maxProgress - 1), (int)(posY + 4 + barHeight), (int)color);
            Gui.func_73734_a((int)(posX + 1), (int)(posY + 2 + barHeight / 2), (int)(posX + curProgress * maxProgress / maxProgress * barWidth / maxProgress - 1), (int)(posY + 4 + barHeight), (int)0x55000000);
        } else if (curProgress > maxProgress / barWidth) {
            int spaceBetweenBars = 1;
            int amountOfBars = 70;
            int widthOfBar = barWidth / amountOfBars - spaceBetweenBars;
            for (int x = 1; x <= amountOfBars - curProgress * amountOfBars / maxProgress; ++x) {
                int barStartX = (posX + widthOfBar) * x - widthOfBar;
                Gui.func_73734_a((int)(barStartX + spaceBetweenBars * x), (int)(posY + 1), (int)(barStartX + widthOfBar + spaceBetweenBars * x), (int)(posY + 4 + barHeight), (int)color);
                Gui.func_73734_a((int)(barStartX + spaceBetweenBars * x), (int)(posY + 2 + barHeight / 2), (int)(barStartX + widthOfBar + spaceBetweenBars * x), (int)(posY + 4 + barHeight), (int)0x55000000);
            }
        }
        Game.fontRenderer().func_78261_a(label, posX + barWidth / 2 - Game.fontRenderer().func_78256_a(label) + Game.fontRenderer().func_78256_a(label) / 2, posY - 1 + stringPosY, -1);
        OpenGL.popMatrix();
    }

    public static void drawCenteredRectWithOutline(int x, int y, int w, int h, int borderWidth, int fillColor, int borderColor) {
        Draw.drawRect(x - w / 2 + borderWidth, y - h / 2, w, h, fillColor);
        Draw.drawRect(x - w / 2 + borderWidth, y - h / 2, w, borderWidth, borderColor);
        Draw.drawRect(x - w / 2, y + h / 2, w, borderWidth, borderColor);
        Draw.drawRect(x - w / 2, y - h / 2, borderWidth, h, borderColor);
        Draw.drawRect(x + w / 2, y - h / 2 + borderWidth, borderWidth, h, borderColor);
    }

    public static void drawRectWithOutline(int x, int y, int w, int h, int borderWidth, int fillColor, int borderColor) {
        int x1 = x;
        int y1 = y;
        int x2 = x + w;
        int y2 = y + h;
        Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)fillColor);
        Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)(y2 - h + borderWidth), (int)borderColor);
        Gui.func_73734_a((int)x1, (int)(y1 + h - borderWidth), (int)x2, (int)y2, (int)borderColor);
        Gui.func_73734_a((int)x1, (int)(y1 + borderWidth), (int)(x2 - w + borderWidth), (int)(y2 - borderWidth), (int)borderColor);
        Gui.func_73734_a((int)(x1 + w - borderWidth), (int)(y1 + borderWidth), (int)x2, (int)(y2 - borderWidth), (int)borderColor);
    }

    public static void drawOverlay(ResourceLocation resource) {
        Draw.drawOverlay(resource, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawOverlay(ResourceLocation resource, float a) {
        Draw.drawOverlay(resource, 1.0f, 1.0f, 1.0f, a);
    }

    public static void drawOverlay(ResourceLocation resource, float r, float g, float b) {
        Draw.drawOverlay(resource, r, g, b, 1.0f);
    }

    public static void drawOverlay(ResourceLocation resource, float r, float g, float b, float a) {
        OpenGL.enableBlend();
        OpenGL.disableDepthTest();
        OpenGL.depthMask(false);
        OpenGL.blendFunc(770, 771);
        OpenGL.color(r, g, b, a);
        OpenGL.disableAlphaTest();
        Draw.bindTexture(resource);
        Draw.drawQuad(0, 0, Screen.scaledDisplayResolution().getScaledWidth(), Screen.scaledDisplayResolution().getScaledHeight());
        OpenGL.depthMask(true);
        OpenGL.enableDepthTest();
        OpenGL.enableAlphaTest();
        OpenGL.color(1.0f, 1.0f, 1.0f, 1.0f);
        OpenGL.disableBlend();
    }

    public static void drawModel(ModelBase model, ResourceLocation resource) {
        Draw.drawModel(null, model, resource, 0.0, 0.0, 0.0);
    }

    public static void drawModel(ModelBase model, ResourceLocation resource, double posX, double posY, double posZ) {
        Draw.drawModel(null, model, resource, posX, posY, posZ);
    }

    public static void drawModel(Entity entity, ModelBase model, ResourceLocation resource) {
        Draw.drawModel(entity, model, resource, 0.0, 0.0, 0.0);
    }

    public static void drawModel(Entity entity, ModelBase model, ResourceLocation resource, double posX, double posY, double posZ) {
        OpenGL.disableCullFace();
        Draw.bindTexture(resource);
        OpenGL.translate(posX, posY, posZ);
        model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f);
    }

    public static void drawShowcaseModel(ModelBase model, ResourceLocation resource, int x, int y, float scale) {
        OpenGL.color(1.0f, 1.0f, 1.0f, 1.0f);
        OpenGL.pushMatrix();
        OpenGL.translate(x, (float)y - scale * 0.43f, 10.0f);
        OpenGL.scale(0.06f * scale, 0.06f * scale, 1.0f);
        OpenGL.rotate(-20.0f, 1.0f, 0.0f, 0.0f);
        OpenGL.rotate(205.0f, 0.0f, 1.0f, 0.0f);
        OpenGL.disableCullFace();
        OpenGL.enableDepthTest();
        Draw.bindTexture(resource);
        model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        OpenGL.enableCullFace();
        OpenGL.disableDepthTest();
        OpenGL.popMatrix();
    }

    public static void drawEntity(int x, int y, int scale, float yaw, float pitch, Entity entity) {
        OpenGL.enable(2903);
        OpenGL.pushMatrix();
        OpenGL.translate(x, y, 100.0f);
        OpenGL.scale(-scale, scale, scale);
        OpenGL.rotate(180.0f, 0.0f, 0.0f, 1.0f);
        OpenGL.rotate(yaw, 0.0f, 1.0f, 0.0f);
        OpenGL.rotate(pitch, 1.0f, 0.0f, 0.0f);
        RenderManager.field_78727_a.func_147940_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        OpenGL.enableLightMapping();
        OpenGL.popMatrix();
    }

    public static void drawPlayerFace(String username, int x, int y, int width, int height) {
        ResourceLocation resource = Remote.downloadResource(String.format("http://s3.amazonaws.com/MinecraftSkins/%s.png", username), AbstractClientPlayer.field_110314_b, false);
        Draw.bindTexture(resource);
        Draw.drawQuad(x, y, width, height, 90, 0.125f, 0.25f, 0.25f, 0.5f);
        Draw.drawQuad(x, y, width, height, 90, 0.75f, 0.625f, 0.25f, 0.5f);
    }

    public static void drawResource(ResourceLocation resource, int posX, int posY, int width, int height) {
        Draw.drawResource(resource, posX, posY, width, height, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawResource(ResourceLocation resource, int posX, int posY, int width, int height, float r, float g, float b, float a) {
        Draw.drawResource(resource, posX, posY, width, height, r, g, b, a, 1.0f, 1.0f);
    }

    public static void drawResource(ResourceLocation resource, int posX, int posY, int width, int height, float r, float g, float b, float a, float u, float v) {
        OpenGL.disableLighting();
        OpenGL.disableFog();
        Draw.bindTexture(resource);
        OpenGL.color(r, g, b, a);
        Draw.drawQuad(posX, posY, width, height, 0, 0.0f, u, 0.0f, v);
    }

    public static void drawResourceCentered(ResourceLocation resource, int posX, int posY, int width, int height) {
        Draw.drawResourceCentered(resource, posX, posY, width, height, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawResourceCentered(ResourceLocation resource, int posX, int posY, int width, int height, float r, float g, float b, float a) {
        Draw.drawResourceCentered(resource, posX, posY, width, height, r, g, b, a, 1.0f, 1.0f);
    }

    public static void drawResourceCentered(ResourceLocation resource, int posX, int posY, int width, int height, float r, float g, float b, float a, float u, float v) {
        OpenGL.disableLighting();
        OpenGL.disableFog();
        Draw.bindTexture(resource);
        OpenGL.color(r, g, b, a);
        Draw.drawQuad(posX - width / 2, posY, width, height, 0, 0.0f, u, 0.0f, v);
    }

    public static void drawParticle(int index, int x, int y, int width, int height) {
        float tS = 0.0624375f;
        float u = (float)(index % 16) / 16.0f;
        float mU = u + tS;
        float v = (float)(index / 16) / 16.0f;
        float mV = v + tS;
        Draw.bindTexture(GameResources.particleTexture);
        Draw.drawQuad(x, y, width, height, 0, u, mU, v, mV);
    }

    public static void drawItemIcon(Item item, int x, int y, int width, int height) {
        IIcon icon = item.getIcon(new ItemStack(item), 1);
        if (icon != null) {
            Draw.bindTexture(Game.minecraft().func_110434_K().func_130087_a(item.func_94901_k()));
            Draw.drawQuad(x, y, width, height, 0, icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h());
        }
    }

    public static void drawBlockSide(Block block, int side, int x, int y, int width, int height) {
        Draw.drawBlockSide(block, side, x, y, width, height, 1.0f, 1.0f);
    }

    public static void drawBlockSide(Block block, int side, int x, int y, int width, int height, float u, float v) {
        IIcon icon = block.func_149733_h(side);
        if (icon != null) {
            Draw.bindTexture(Blocks.getBlockTexture(block, side));
            Draw.drawQuad(x, y, width, height, 0, 0.0f, u, 0.0f, v);
        }
    }

    public static void drawRecipe(Object obj, int x, int y, int size, int slotPadding, int backgroundColor) {
        IRecipe irecipe;
        Object object = obj instanceof Item ? Game.getRecipe(obj) : (irecipe = obj instanceof Block ? Game.getRecipe(obj) : null);
        if (irecipe == null) {
            return;
        }
        for (int gX = 0; gX < 3; ++gX) {
            for (int gY = 0; gY < 3; ++gY) {
                ItemStack slotStack;
                Draw.drawRect(x + slotPadding + gX * (size + slotPadding), y + slotPadding + gY * (size + slotPadding), size, size, backgroundColor);
                if (irecipe instanceof ShapedRecipes && (slotStack = ((ShapedRecipes)irecipe).field_77574_d[gX + gY * 3]) != null) {
                    Draw.drawItemIcon(slotStack.func_77973_b(), x + slotPadding + gX * (size + slotPadding), y + slotPadding + gY * (size + slotPadding), size, size);
                }
                if (!(irecipe instanceof ShapedOreRecipe)) continue;
                ShapedOreRecipe recipe = (ShapedOreRecipe)irecipe;
                for (Object o : recipe.getInput()) {
                    try {
                        ItemStack slotStack2;
                        Class<?> unmodifiableArrayList = Class.forName("net.minecraftforge.oredict.OreDictionary$UnmodifiableArrayList");
                        if (unmodifiableArrayList.isInstance(o)) {
                            String domain = o.toString().contains("item.") ? (o.toString().substring(o.toString().indexOf("x") + 1, o.toString().indexOf("item.")).equalsIgnoreCase("") ? "minecraft" : o.toString().substring(o.toString().indexOf("x") + 1, o.toString().indexOf("item."))) : "null";
                            Item item = GameRegistry.findItem((String)domain, (String)o.toString().substring(o.toString().indexOf(".") + 1, o.toString().indexOf("@")));
                            if (item == null) continue;
                            Draw.drawItemIcon(item, x + slotPadding + gX * (size + slotPadding), y + slotPadding + gY * (size + slotPadding), size, size);
                            continue;
                        }
                        if (gX + gY * 3 >= recipe.getInput().length || !(recipe.getInput()[gX + gY * 3] instanceof ItemStack) || (slotStack2 = (ItemStack)recipe.getInput()[gX + gY * 3]) == null) continue;
                        Draw.drawItemIcon(slotStack2.func_77973_b(), x + slotPadding + gX * (size + slotPadding), y + slotPadding + gY * (size + slotPadding), size, size);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void bindTexture(ResourceLocation resource) {
        Game.minecraft().field_71446_o.func_110577_a(resource);
    }

    public static String getResourcePath(ResourceLocation resource) {
        return String.format("%s:%s", resource.func_110624_b(), resource.func_110623_a());
    }

    public static void lightingHelper(Entity entity, float offset) {
        int brightness = entity.field_70170_p.func_72802_i(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)(entity.field_70163_u + (double)(offset / 16.0f))), MathHelper.func_76128_c((double)entity.field_70161_v), 0);
        OpenGL.setLightmapTextureCoords(OpenGlHelper.field_77476_b, brightness % 65536, brightness / 65536);
        OpenGL.color(1.0f, 1.0f, 1.0f);
    }

    public static ArrayList<String> wrapString(String string, int width) {
        ArrayList<String> strings = new ArrayList<String>();
        int stringWidth = Draw.getStringRenderWidth(string);
        if (stringWidth > width) {
            String currentLine = "";
            for (String word : string.split(" ")) {
                int wordWidth = Draw.getStringRenderWidth(word);
                int currentLineWidth = Draw.getStringRenderWidth(currentLine);
                if (currentLineWidth + wordWidth <= width) {
                    currentLine = currentLine.isEmpty() ? word : currentLine + " " + word;
                    continue;
                }
                strings.add(currentLine);
                currentLine = word;
            }
            if (!currentLine.isEmpty()) {
                strings.add(currentLine);
            }
        } else {
            strings.add(string);
        }
        return strings;
    }

    public static interface ITooltipLineHandler {
        public Dimension getSize();

        public void draw(int var1, int var2);
    }
}

