/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.render;

public class Matrix4 {
    private float[] matrix;
    public static final int size = 4;

    public Matrix4() {
        this.matrix = new float[16];
        this.setIdentity();
    }

    public Matrix4(float[] arr) {
        int n = 16;
        if (arr.length != n) {
            throw new RuntimeException("Matrix4 constructor needs a double array of " + n + " elements");
        }
        this.matrix = arr;
    }

    public void clone(Matrix4 other) {
        this.matrix = new float[16];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = other.matrix[i];
        }
    }

    public void setIdentity() {
        int i;
        for (i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = 0.0f;
        }
        for (i = 0; i < 4; ++i) {
            this.matrix[i * 4 + i] = 1.0f;
        }
    }

    public Matrix4 mul(Matrix4 right) {
        Matrix4 result = new Matrix4();
        int idx = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float r = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    r += this.matrix[i * 4 + k] * right.matrix[k * 4 + j];
                }
                result.matrix[idx] = r;
                ++idx;
            }
        }
        return result;
    }

    public float get(int col, int row) {
        return this.matrix[row * 4 + col];
    }

    public float[] transform(float x, float y, float z, float w) {
        float[] r = new float[4];
        float[] m = this.matrix;
        int idx = 0;
        for (int i = 0; i < r.length; ++i) {
            r[i] = m[idx] * x + m[idx + 1] * y + m[idx + 2] * z + m[idx + 3] * w;
            idx += 4;
        }
        return r;
    }

    public String toString() {
        String r = "[Matrix4]\n";
        int idx = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                r = r + " " + this.matrix[idx++];
            }
            r = r + "\n";
        }
        return r;
    }
}

