/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.mdxlib.lib.client.render;

import com.arisux.mdxlib.lib.game.Game;
import com.arisux.mdxlib.lib.world.tile.IRotatable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class OpenGL {
    public static ArrayList<Framebuffer> frameBuffers = new ArrayList();
    public static boolean lightmapTexUnitTextureEnable;
    public static int lightmapTexUnit;
    public static int defaultTexUnit;

    public static void pushMatrix() {
        GL11.glPushMatrix();
    }

    public static void popMatrix() {
        GL11.glPopMatrix();
    }

    public static void translate(double offsetX, double offsetY, double offsetZ) {
        GL11.glTranslated((double)offsetX, (double)offsetY, (double)offsetZ);
    }

    public static void translate(float offsetX, float offsetY, float offsetZ) {
        GL11.glTranslatef((float)offsetX, (float)offsetY, (float)offsetZ);
    }

    public static void scale(double scaleX, double scaleY, double scaleZ) {
        GL11.glScaled((double)scaleX, (double)scaleY, (double)scaleZ);
    }

    public static void scale(float scaleX, float scaleY, float scaleZ) {
        GL11.glScalef((float)scaleX, (float)scaleY, (float)scaleZ);
    }

    public static void begin(int mode) {
        GL11.glBegin((int)mode);
    }

    public static void end() {
        GL11.glEnd();
    }

    public static void newList(int list, int mode) {
        GL11.glNewList((int)list, (int)mode);
    }

    public static void callList(int list) {
        GL11.glCallList((int)list);
    }

    public static void endList() {
        GL11.glEndList();
    }

    public static void enableTexture2d() {
        OpenGL.enable(3553);
    }

    public static void disableTexture2d() {
        OpenGL.disable(3553);
    }

    public static void normal(float x, float y, float z) {
        GL11.glNormal3f((float)x, (float)y, (float)z);
    }

    public static void texCoord(float u, float v) {
        GL11.glTexCoord2f((float)u, (float)v);
    }

    public static void vertex(float x, float y, float z) {
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public static void rotate(float angle, float x, float y, float z) {
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
    }

    public static void enableBlend() {
        OpenGL.enable(3042);
    }

    public static void disableBlend() {
        OpenGL.disable(3042);
    }

    public static void color(float r, float g, float b) {
        GL11.glColor3f((float)r, (float)g, (float)b);
    }

    public static void color(float r, float g, float b, float a) {
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void color4i(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        OpenGL.color(r, g, b, a);
    }

    public static void color3i(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        OpenGL.color(r, g, b);
    }

    public static String getString(int name) {
        return GL11.glGetString((int)name);
    }

    public static void enableDepthTest() {
        GL11.glEnable((int)2929);
    }

    public static void disableDepthTest() {
        GL11.glDisable((int)2929);
    }

    public static void enable(int cap) {
        GL11.glEnable((int)cap);
    }

    public static void disable(int cap) {
        GL11.glDisable((int)cap);
    }

    public static void blendFunc(int sfactor, int dfactor) {
        GL11.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public static void depthMask(boolean flag) {
        GL11.glDepthMask((boolean)flag);
    }

    public static void setLightmapTextureCoords(int lightmapTexUnit, float x, float y) {
        OpenGlHelper.func_77475_a((int)lightmapTexUnit, (float)x, (float)y);
    }

    public static void setActiveTexture(int id) {
        OpenGlHelper.func_77473_a((int)id);
    }

    public static void enableLighting() {
        OpenGL.enable(2896);
    }

    public static void disableLighting() {
        OpenGL.disable(2896);
    }

    public static boolean getBoolean(int pname) {
        return GL11.glGetBoolean((int)pname);
    }

    public static void texParameter(int target, int pname, int param) {
        GL11.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public static void texParameter(int target, int pname, float param) {
        GL11.glTexParameterf((int)target, (int)pname, (float)param);
    }

    public static void texParameter(int target, int pname, FloatBuffer buffer) {
        GL11.glTexParameter((int)target, (int)pname, (FloatBuffer)buffer);
    }

    public static void texParameter(int target, int pname, IntBuffer buffer) {
        GL11.glTexParameter((int)target, (int)pname, (IntBuffer)buffer);
    }

    public static int getTextureId(ResourceLocation resource) {
        ITextureObject object = Game.minecraft().func_110434_K().func_110581_b(resource);
        object = object == null ? new SimpleTexture(resource) : object;
        return object.func_110552_b();
    }

    public static void shadeSmooth() {
        GL11.glShadeModel((int)7425);
    }

    public static void shadeFlat() {
        GL11.glShadeModel((int)7424);
    }

    public static void enableRescaleNormal() {
        OpenGL.enable(32826);
    }

    public static void disableRescaleNormal() {
        OpenGL.disable(32826);
    }

    public static void enableStandardItemLighting() {
        RenderHelper.func_74519_b();
    }

    public static void disableStandardItemLighting() {
        RenderHelper.func_74518_a();
    }

    public static void enableAlphaTest() {
        OpenGL.enable(3008);
    }

    public static void disableAlphaTest() {
        OpenGL.disable(3008);
    }

    public static void readBuffer(int mode) {
        GL11.glReadBuffer((int)mode);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void enableCullFace() {
        OpenGL.enable(2884);
    }

    public static void disableCullFace() {
        OpenGL.disable(2884);
    }

    public static void disableLightMapping() {
        int light = 61680;
        OpenGL.enableBlend();
        OpenGL.blendFunc(1, 1);
        OpenGL.depthMask(true);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)light % 65536.0f / 1.0f), (float)((float)light / 65536.0f / 1.0f));
        OpenGL.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void enableLightMapping() {
        int light = 61680;
        OpenGL.disableBlend();
        OpenGL.depthMask(true);
        OpenGL.setLightmapTextureCoords(OpenGlHelper.field_77476_b, (float)light % 65536.0f / 1.0f, (float)light / 65536.0f / 1.0f);
        OpenGL.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void disableLight() {
        OpenGL.setActiveTexture(lightmapTexUnit);
        lightmapTexUnitTextureEnable = OpenGL.getBoolean(3553);
        if (lightmapTexUnitTextureEnable) {
            OpenGL.disableTexture2d();
        }
        OpenGL.setActiveTexture(OpenGlHelper.field_77478_a);
        OpenGL.disableLighting();
    }

    public static void enableLight() {
        OpenGL.setActiveTexture(lightmapTexUnit);
        if (lightmapTexUnitTextureEnable) {
            OpenGL.enableTexture2d();
        }
        OpenGL.setActiveTexture(defaultTexUnit);
        OpenGL.enableLighting();
    }

    public static void blendClear() {
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
    }

    public static void antiAlias2d() {
        OpenGL.texParameter(3553, 10241, 9729);
        OpenGL.texParameter(3553, 10240, 9729);
        OpenGL.texParameter(3553, 10242, 10496);
        OpenGL.texParameter(3553, 10243, 10496);
    }

    public static void enableFog() {
        OpenGL.enable(2912);
    }

    public static void disableFog() {
        OpenGL.disable(2912);
    }

    public static void bindTexture(int target, int texture) {
        GL11.glBindTexture((int)target, (int)texture);
    }

    public static void copyTexSubImage(int target, int level, int xoffset, int yoffset, int x, int y) {
        GL11.glCopyTexSubImage1D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y);
    }

    public static void copyTexSubImage(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GL11.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public static void copyDownsizedRender(TextureManager manager, ResourceLocation target, int x, int y, int w, int h, int index) {
        ITextureObject textureObject = manager.func_110581_b(target);
        if (textureObject != null) {
            OpenGL.bindTexture(3553, textureObject.func_110552_b());
            OpenGL.copyTexSubImage(3553, 0, index, index, x, y, w, h);
        }
    }

    public static Framebuffer createFrameBuffer(int width, int height, boolean useDepth) {
        Framebuffer render = new Framebuffer(width, height, useDepth);
        frameBuffers.add(render);
        return render;
    }

    public static void destroyFrameBuffer(Framebuffer buffer) {
        OpenGL.enableDepthTest();
        if (buffer.field_147616_f >= 0) {
            buffer.func_147608_a();
        }
        frameBuffers.remove(buffer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void rotate(TileEntity tile) {
        IRotatable rotatable;
        if (tile instanceof IRotatable && (rotatable = (IRotatable)tile) != null && rotatable.getDirection() != null && rotatable.getDirection() != null) {
            if (rotatable.getDirection() == ForgeDirection.NORTH) {
                OpenGL.rotate(180.0f, 0.0f, 1.0f, 0.0f);
            } else if (rotatable.getDirection() == ForgeDirection.SOUTH) {
                OpenGL.rotate(0.0f, 0.0f, 0.0f, 0.0f);
            } else if (rotatable.getDirection() == ForgeDirection.WEST) {
                OpenGL.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
            } else if (rotatable.getDirection() == ForgeDirection.EAST) {
                OpenGL.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void rotateOpposite(TileEntity tile) {
        IRotatable rotatable;
        if (tile instanceof IRotatable && (rotatable = (IRotatable)tile) != null && rotatable.getDirection() != null && rotatable.getDirection() != null) {
            if (rotatable.getDirection() == ForgeDirection.SOUTH) {
                OpenGL.rotate(180.0f, 0.0f, 1.0f, 0.0f);
            } else if (rotatable.getDirection() == ForgeDirection.NORTH) {
                OpenGL.rotate(0.0f, 0.0f, 0.0f, 0.0f);
            } else if (rotatable.getDirection() == ForgeDirection.EAST) {
                OpenGL.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
            } else if (rotatable.getDirection() == ForgeDirection.WEST) {
                OpenGL.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    static {
        lightmapTexUnit = OpenGlHelper.field_77476_b;
        defaultTexUnit = OpenGlHelper.field_77478_a;
    }
}

